#region << Using Directives >>
using System;
using Volpe.Cafe.Utils;
#endregion
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public class ScenarioInfo : ICloneable
    {
        #region 
        ScenarioInfo() { }
        internal ScenarioInfo(
            RegulatoryClass regClass,
            int[] function, double[][] coefficients, double[] minStndMpg, double[] minStndPct,
            double[] fineRate,
            int[] multiFuel, double[] multiFuelFFVShare, double[] multiFuelPHEVShare,
            bool[] includeAC, double[] acAdjustment, double[] acCost,
            double[] offCycleCap, double[] ffvCap,
            double[] shevTaxCredit, double[] phevTaxCredit, double[] evTaxCredit,
            int[] twFunction, double[] payloadReturn, double[] towingReturn,
            int[] creditCarryFwd)
        {
            this.RegClass           = regClass;
            this.Function           = function;
            this.Coefficients       = coefficients;
            this.MinStndMpg         = minStndMpg;
            this.MinStndPct         = minStndPct;
            this.FineRate           = fineRate;
            this.MultiFuel          = multiFuel;
            this.MultiFuelFFVShare  = multiFuelFFVShare;
            this.MultiFuelPHEVShare = multiFuelPHEVShare;
            this.IncludeAC          = includeAC;
            this.ACAdjustment       = acAdjustment;
            this.ACCost             = acCost;
            this.OffCycleCap        = offCycleCap;
            this.FFVCap             = ffvCap;
            this.SHEVTaxCredit      = shevTaxCredit;
            this.PHEVTaxCredit      = phevTaxCredit;
            this.EVTaxCredit        = evTaxCredit;
            this.TWFunction         = twFunction;
            this.PayloadReturn      = payloadReturn;
            this.TowingReturn       = towingReturn;
            this.CreditCarryFwd     = creditCarryFwd;
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public ScenarioInfo Clone()
        {
            ScenarioInfo scen = new ScenarioInfo();
            scen.RegClass           = this.RegClass;
            scen.Function           = this.Function          .CloneArray();
            scen.Coefficients       = this.Coefficients      .CloneArray();
            scen.MinStndMpg         = this.MinStndMpg        .CloneArray();
            scen.MinStndPct         = this.MinStndPct        .CloneArray();
            scen.FineRate           = this.FineRate          .CloneArray();
            scen.MultiFuel          = this.MultiFuel         .CloneArray();
            scen.MultiFuelFFVShare  = this.MultiFuelFFVShare .CloneArray();
            scen.MultiFuelPHEVShare = this.MultiFuelPHEVShare.CloneArray();
            scen.IncludeAC          = this.IncludeAC         .CloneArray();
            scen.ACAdjustment       = this.ACAdjustment      .CloneArray();
            scen.ACCost             = this.ACCost            .CloneArray();
            scen.OffCycleCap        = this.OffCycleCap       .CloneArray();
            scen.FFVCap             = this.FFVCap            .CloneArray();
            scen.SHEVTaxCredit      = this.SHEVTaxCredit     .CloneArray();
            scen.PHEVTaxCredit      = this.PHEVTaxCredit     .CloneArray();
            scen.EVTaxCredit        = this.EVTaxCredit       .CloneArray();
            scen.TWFunction         = this.TWFunction        .CloneArray();
            scen.PayloadReturn      = this.PayloadReturn     .CloneArray();
            scen.TowingReturn       = this.TowingReturn      .CloneArray();
            scen.CreditCarryFwd     = this.CreditCarryFwd    .CloneArray();
            return scen;
        }
        #endregion
        #endregion
        #region 
        public RegulatoryClass RegClass { get; private set; }
        public int[] Function { get; private set; }
        public double[][] Coefficients { get; private set; }
        public double[] MinStndMpg { get; private set; }
        public double[] MinStndPct { get; private set; }
        public double[] FineRate { get; private set; }
        public int[] MultiFuel { get; private set; }
        public double[] MultiFuelFFVShare { get; private set; }
        public double[] MultiFuelPHEVShare { get; private set; }
        public bool[] IncludeAC { get; private set; }
        public double[] ACAdjustment { get; private set; }
        public double[] ACCost { get; private set; }
        public double[] OffCycleCap { get; private set; }
        public double[] FFVCap { get; private set; }
        public double[] SHEVTaxCredit { get; private set; }
        public double[] PHEVTaxCredit { get; private set; }
        public double[] EVTaxCredit { get; private set; }
        public int[] TWFunction { get; private set; }
        public double[] PayloadReturn { get; private set; }
        public double[] TowingReturn { get; private set; }
        public int[] CreditCarryFwd { get; private set; }
        #endregion
    }
}

