#region << Using Directives >>
using System;
using System.IO;
using System.Reflection;
using System.Windows.Forms;
#endregion
namespace Volpe.Cafe.Utils
{
    public static class ApplicationInfo
    {
        #region 
        static ApplicationInfo()
        {
            Assembly exeAssembly = Assembly.GetExecutingAssembly();
            ApplicationVersion = exeAssembly.GetName().Version.ToString();
            ApplicationTimestamp = (new FileInfo(exeAssembly.GetFiles()[0].Name)).LastWriteTime.ToString("M/dd/yy H:mm:ss");
            ApplicationPath    = Application.StartupPath;
            UserResourcesPath  = Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData) + "\\Volpe Center\\CAFE Model";
            LogPath            = UserResourcesPath + "\\logs";
            DefaultOutputPath  = UserResourcesPath + "\\output";
            SettingsFilePath   = UserResourcesPath + "\\settings.bin";
            RecentListFilePath = UserResourcesPath + "\\recent.list";
            if (!Directory.Exists(LogPath          )) { Directory.CreateDirectory(LogPath          ); }
            if (!Directory.Exists(DefaultOutputPath)) { Directory.CreateDirectory(DefaultOutputPath); }
        }
        #endregion
        #region 
        public static readonly string ApplicationVersion;
        public static readonly string ApplicationTimestamp;
        public static readonly string ApplicationPath;
        public static readonly string UserResourcesPath;
        public static readonly string LogPath;
        public static readonly string DefaultOutputPath;
        public static readonly string SettingsFilePath;
        public static readonly string RecentListFilePath;
        #endregion
    }
}

