#region << Using Directives >>
using System;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using Volpe.Cafe.UI;
using System.Diagnostics;
using Volpe.Cafe.UI.Properties;
using Volpe.Cafe.Utils;
#endregion
namespace Volpe.Cafe.UI
{
	public class RtfDialog : System.Windows.Forms.Form
	{
        #region 
		protected RtfDialog()
		{
			this.InitializeComponent();
            this.PromptOption = PromptOption.Ok;
            this.ShowBuildInfo = false;
            this.ShowLicenseButtons = false;
		}
		protected override void Dispose(bool disposing)
		{
			base.Dispose(disposing);
		}
        #endregion
        #region 
		#region 
		void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(RtfDialog));
            this.ux_rtf = new System.Windows.Forms.RichTextBox();
            this.ux_buttons = new System.Windows.Forms.Panel();
            this.ux_viewLGPLv21 = new System.Windows.Forms.Button();
            this.ux_noButton = new System.Windows.Forms.Button();
            this.ux_yesButton = new System.Windows.Forms.Button();
            this.ux_cancelButton = new System.Windows.Forms.Button();
            this.ux_okButton = new System.Windows.Forms.Button();
            this.ux_buildInfo = new System.Windows.Forms.Label();
            this.ux_buttons.SuspendLayout();
            this.SuspendLayout();
            this.ux_rtf.BackColor = System.Drawing.Color.White;
            this.ux_rtf.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_rtf.Location = new System.Drawing.Point(0, 0);
            this.ux_rtf.Name = "ux_rtf";
            this.ux_rtf.ReadOnly = true;
            this.ux_rtf.Size = new System.Drawing.Size(514, 325);
            this.ux_rtf.TabIndex = 1;
            this.ux_rtf.TabStop = false;
            this.ux_rtf.Text = "";
            this.ux_rtf.LinkClicked += new System.Windows.Forms.LinkClickedEventHandler(this.RTF_LinkClicked);
            this.ux_buttons.Controls.Add(this.ux_viewLGPLv21);
            this.ux_buttons.Controls.Add(this.ux_noButton);
            this.ux_buttons.Controls.Add(this.ux_yesButton);
            this.ux_buttons.Controls.Add(this.ux_cancelButton);
            this.ux_buttons.Controls.Add(this.ux_okButton);
            this.ux_buttons.Controls.Add(this.ux_buildInfo);
            this.ux_buttons.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.ux_buttons.Location = new System.Drawing.Point(0, 325);
            this.ux_buttons.Name = "ux_buttons";
            this.ux_buttons.Size = new System.Drawing.Size(514, 37);
            this.ux_buttons.TabIndex = 0;
            this.ux_viewLGPLv21.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_viewLGPLv21.Location = new System.Drawing.Point(8, 8);
            this.ux_viewLGPLv21.Name = "ux_viewLGPLv21";
            this.ux_viewLGPLv21.Size = new System.Drawing.Size(104, 21);
            this.ux_viewLGPLv21.TabIndex = 6;
            this.ux_viewLGPLv21.Text = "View LGPLv2.1";
            this.ux_viewLGPLv21.UseVisualStyleBackColor = true;
            this.ux_viewLGPLv21.Click += new System.EventHandler(this.ViewLGPLv21_Click);
            this.ux_noButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_noButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_noButton.Location = new System.Drawing.Point(424, 8);
            this.ux_noButton.Name = "ux_noButton";
            this.ux_noButton.Size = new System.Drawing.Size(80, 21);
            this.ux_noButton.TabIndex = 2;
            this.ux_noButton.Text = "&No";
            this.ux_noButton.Click += new System.EventHandler(this.NoButton_Click);
            this.ux_yesButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_yesButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_yesButton.Location = new System.Drawing.Point(336, 8);
            this.ux_yesButton.Name = "ux_yesButton";
            this.ux_yesButton.Size = new System.Drawing.Size(80, 21);
            this.ux_yesButton.TabIndex = 1;
            this.ux_yesButton.Text = "&Yes";
            this.ux_yesButton.Click += new System.EventHandler(this.YesButton_Click);
            this.ux_cancelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_cancelButton.Location = new System.Drawing.Point(248, 8);
            this.ux_cancelButton.Name = "ux_cancelButton";
            this.ux_cancelButton.Size = new System.Drawing.Size(80, 21);
            this.ux_cancelButton.TabIndex = 3;
            this.ux_cancelButton.Text = "C&ancel";
            this.ux_cancelButton.Click += new System.EventHandler(this.CancelButton_Click);
            this.ux_okButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_okButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_okButton.Location = new System.Drawing.Point(160, 8);
            this.ux_okButton.Name = "ux_okButton";
            this.ux_okButton.Size = new System.Drawing.Size(80, 21);
            this.ux_okButton.TabIndex = 0;
            this.ux_okButton.Text = "&OK";
            this.ux_okButton.Click += new System.EventHandler(this.OkButton_Click);
            this.ux_buildInfo.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.ux_buildInfo.Location = new System.Drawing.Point(8, 4);
            this.ux_buildInfo.Name = "ux_buildInfo";
            this.ux_buildInfo.Size = new System.Drawing.Size(232, 29);
            this.ux_buildInfo.TabIndex = 4;
            this.ux_buildInfo.Text = "Build info:";
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(514, 362);
            this.Controls.Add(this.ux_rtf);
            this.Controls.Add(this.ux_buttons);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "RtfDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "CAFE Model";
            this.ux_buttons.ResumeLayout(false);
            this.ResumeLayout(false);
        }
		#endregion
        #region 
        public static DialogResult ShowDialog(string caption, string text)
        {
            return ShowDialog(caption, text, null, Color.Empty, PromptOption.Ok, false, false);
        }
        public static DialogResult ShowDialog(string caption, string text, Font font, Color fontColor, PromptOption promptOption,
            bool showBuildInfo, bool showLicenseButtons)
        {
            RtfDialog dlg = new RtfDialog();
            dlg.Initialize(caption, text, promptOption, showBuildInfo, showLicenseButtons);
            if (font != null) { dlg.ux_rtf.Font = font; }
            if (fontColor != Color.Empty) { dlg.ux_rtf.ForeColor = fontColor; }
            return dlg.ShowDialog();
        }
        public static DialogResult ShowDialogFromFile(string caption, string path)
        {
            return ShowDialogFromFile(caption, path, PromptOption.Ok);
        }
        public static DialogResult ShowDialogFromFile(string caption, string path, PromptOption promptOption)
        {
            return ShowDialogFromFile(caption, path, promptOption, false, false);
        }
        public static DialogResult ShowDialogFromFile(string caption, string path, PromptOption promptOption, bool showBuildInfo,
            bool showLicenseButtons)
        {
            FileStream stream = new FileStream(path, FileMode.Open, FileAccess.Read);
            DialogResult dr = ShowDialogFromStream(caption, stream, promptOption, showBuildInfo, showLicenseButtons);
            stream.Close();
            return dr;
        }
        public static DialogResult ShowDialogFromStream(string caption, Stream stream, PromptOption promptOption,
            bool showBuildInfo, bool showLicenseButtons)
        {
            RtfDialog dlg = new RtfDialog();
            dlg.Initialize(caption, string.Empty, promptOption, showBuildInfo, showLicenseButtons);
            dlg.ux_rtf.LoadFile(stream, RichTextBoxStreamType.RichText);
            return dlg.ShowDialog();
        }
        #endregion
        void Initialize(string caption, string text, PromptOption promptOption, bool showBuildInfo, bool showLicenseButtons)
        {
            this.Text        = caption;
            this.ux_rtf.Text = text;
            this.PromptOption       = promptOption;
            this.ShowBuildInfo      = showBuildInfo;
            this.ShowLicenseButtons = showLicenseButtons;
        }
        void SetupButtons(bool okVisbile, bool cancelVisbile, bool yesVisbile, bool noVisbile,
            Button acceptButton, Button cancelButton)
        {
            this.ux_okButton    .Visible = okVisbile;
            this.ux_cancelButton.Visible = cancelVisbile;
            this.ux_yesButton   .Visible = yesVisbile;
            this.ux_noButton    .Visible = noVisbile;
            this.AcceptButton = acceptButton;
            this.CancelButton = cancelButton;
        }
        void ViewLGPLv21_Click(object sender, EventArgs e)
        {
            MemoryStream stream = new MemoryStream(Resources.License_GNU_LGPL_2_1_txt);
            RtfViewer.Show("GNU LESSER GENERAL PUBLIC LICENSE", stream);
            stream.Close();
        }
        void OkButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }
        void CancelButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }
        void YesButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.Yes;
        }
        void NoButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.No;
        }
        void RTF_LinkClicked(object sender, LinkClickedEventArgs e)
        {
            Process.Start("iexplore", e.LinkText);
        }
        #endregion
        #region 
        [Category("Appearance")]
        [Description("Indicates the prompt options displayed in the RtfDialog.")]
        [DefaultValue(PromptOption.Ok)]
        public PromptOption PromptOption
        {
            get { return this._promptOption; }
            set
            {
                this._promptOption = value;
                switch (value)
                {
                    case PromptOption.OkCancel:
                        this.SetupButtons(true, true, false, false, this.ux_okButton, this.ux_cancelButton);
                        this.ux_cancelButton.Left = this.ux_buttons     .Width - 8 - this.ux_cancelButton.Width;
                        this.ux_okButton    .Left = this.ux_cancelButton.Left  - 8 - this.ux_okButton    .Width;
                        break;
                    case PromptOption.YesNo:
                        this.SetupButtons(false, false, true, true, this.ux_yesButton, this.ux_noButton);
                        this.ux_noButton .Left = this.ux_buttons .Width - 8 - this.ux_noButton .Width;
                        this.ux_yesButton.Left = this.ux_noButton.Left  - 8 - this.ux_yesButton.Width;
                        break;
                    case PromptOption.YesNoCancel:
                        this.SetupButtons(false, true, true, true, this.ux_yesButton, this.ux_cancelButton);
                        this.ux_cancelButton.Left = this.ux_buttons     .Width - 8 - this.ux_cancelButton.Width;
                        this.ux_noButton    .Left = this.ux_cancelButton.Left  - 8 - this.ux_noButton    .Width;
                        this.ux_yesButton   .Left = this.ux_noButton    .Left  - 8 - this.ux_yesButton   .Width;
                        break;
                    default:    
                        this.SetupButtons(true, false, false, false, this.ux_okButton, this.ux_okButton);
                        this.ux_okButton.Left = this.ux_buttons.Width - 8 - this.ux_cancelButton.Width;
                        break;
                }
            }
        }
        [Category("Appearance")]
        [Description("Indicates whether the applicaiton build info is displayed in the RtfDialog.")]
        [DefaultValue(true)]
        public bool ShowBuildInfo
        {
            get { return this._showBuildInfo; }
            set
            {
                this._showBuildInfo = value;
                if (value)
                {
                    string version  = ApplicationInfo.ApplicationVersion;
                    string timstamp = ApplicationInfo.ApplicationTimestamp;
                    this.ux_buildInfo.Text = "CAFE Model Version:  " + version + "\nBuild Date:  " + timstamp;
                }
                this.ux_buildInfo.Visible = value;
            }
        }
        [Category("Appearance")]
        [Description("Indicates whether the \"View LGPLv2.1\" and \"View Ms-PL\" buttons are displayed in the RtfDialog.")]
        [DefaultValue(true)]
        public bool ShowLicenseButtons
        {
            get { return this._showLicenseButtons; }
            set
            {
                this._showLicenseButtons    = value;
                this.ux_viewLGPLv21.Visible = value;
            }
        }
        #endregion
        #region 
        #region 
        RichTextBox ux_rtf;
        Panel ux_buttons;
        Button      ux_viewLGPLv21;
        Button      ux_okButton;
        Button      ux_cancelButton;
        Button      ux_yesButton;
        Button      ux_noButton;
        Label       ux_buildInfo;
        #endregion
        PromptOption _promptOption;
        bool         _showBuildInfo;
        bool         _showLicenseButtons;
        #endregion
	}
}

