using System;
using System.Collections.Generic;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public sealed class Platform : Component
    {
        #region 
        Platform() : base() { }
        internal Platform(string name) : base()
        {
            this._name     = name.Trim();
            this._year     = 0;
            this._revision = 0;
        }
        #endregion
        #region 
        internal Platform Clone()
        {
            Platform value  = new Platform();
            value._name     = this._name;
            value._year     = this._year;
            value._revision = this._revision;
            this.CopyTo(value);
            return value;
        }
        public Platform Split(List<Vehicle> vehicles, int year)
        {
            Platform value = (Platform)this.Clone();
            if (value._year == year) { value._revision++; }
            value._year = year;
            for (int i = 0, vehCount = vehicles.Count; i < vehCount; i++)
            {
                vehicles[i].SetPlatform(value);
            }
            this.SplitTo(vehicles, value);
            return value;
        }
        protected override Vehicle SelectPlatformLeader(List<Vehicle> vehicles)
        {
            int techCount = 0;
            foreach (Vehicle veh in vehicles)
            {
                int vehTechCount = this.GetVehicleTechCount(veh);
                if (vehTechCount > techCount) { techCount = vehTechCount; }
            }
            List<Vehicle> filteredVehicles = new List<Vehicle>();
            foreach (Vehicle veh in vehicles)
            {
                int vehTechCount = this.GetVehicleTechCount(veh);
                if (vehTechCount == techCount) { filteredVehicles.Add(veh); }
            }
            return base.SelectPlatformLeader(filteredVehicles);
        }
        int GetVehicleTechCount(Vehicle veh)
        {
            int[] techList = this.TechnologyList;
            int vehTechCount = 0;
            for (int i = 0; i < techList.Length; i++)
            {
                if (veh.ModelData.TechUsed[techList[i]] && !veh.ModelData.TechSuperseded[techList[i]]) { vehTechCount++; }
            }
            return vehTechCount;
        }
        #endregion
        #region 
        public override int[] TechnologyList { get { return TechnologyIndexes.PlatformLevel; } }
        public string Name
        {
            get
            {
                string name = this._name;
                if (this._year > 0)
                {
                    name += " (v." + this._year;
                    if (this._revision > 0)
                    {
                        name += "-R" + this._revision;
                    }
                    name += ")";
                }
                return name;
            }
        }
        public Platform Parent { get { return (Platform)this._parent; } }
        #endregion
        #region 
        string _name;
        int _year;
        int _revision;
        #endregion
    }
}

