#region << Using Directives >>
using System;
using Volpe.Cafe.Utils;
using Volpe.Cafe.Generic;
#endregion
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public sealed class Scenario : ICloneable
    {
        #region 
        Scenario() { }
        internal Scenario(int index, string description, RCObject<ScenarioInfo> scenInfo)
        {
            this.Index       = index;
            this.IsBaseline  = (index == 0);
            this.Description = description;
            this.ScenInfo    = scenInfo;
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public Scenario Clone()
        {
            Scenario scen = new Scenario();
            scen.Index       = this.Index;
            scen.IsBaseline  = this.IsBaseline;
            scen.Description = this.Description;
            scen.ScenInfo    = this.ScenInfo.Clone();
            return scen;
        }
        #endregion
        public override string ToString()
        {
            return this.Index + ". " + Interaction.GetTitleCase(this.Description);
        }
        public string ToString(int descrLength)
        {
            int len = this.Description.Length;
            bool outOfBounds = (descrLength < len);
            descrLength = (outOfBounds) ? descrLength - 3 : len;
            string descr = Interaction.GetTitleCase(this.Description.Substring(0, descrLength));
            if (outOfBounds) { descr += " ..."; }
            return this.Index + ". " + descr;
        }
        #endregion
        #region 
        public int Index { get; private set; }
        public bool IsBaseline { get; private set; }
        public string Description { get; private set; }
        public RCObject<ScenarioInfo> ScenInfo { get; private set; }
        #endregion
    }
}

