#region << Using Directives >>
using System;
using System.ComponentModel;
using System.IO;
using System.IO.Compression;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Utils;
using Volpe.Cafe.UI.Panels;
#endregion
namespace Volpe.Cafe.UI
{
	public class Session : Form
	{
        #region 
        public Session(Cafe2d parent)
        {
            this.InitializeComponent();
            this._parent = parent;
            this.ux_sessionPanel.CreateNewSession();
        }
        public Session(Cafe2d parent, string path)
        {
            this.InitializeComponent();
            this._parent = parent;
            this.ux_sessionPanel.OpenSession(path);
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Session));
            this.ux_sessionPanel = new Volpe.Cafe.UI.Panels.SessionPanel();
            this.SuspendLayout();
            this.ux_sessionPanel.Compliance = null;
            this.ux_sessionPanel.Data = null;
            this.ux_sessionPanel.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_sessionPanel.Location = new System.Drawing.Point(0, 0);
            this.ux_sessionPanel.Name = "ux_sessionPanel";
            this.ux_sessionPanel.RefreshInterval = 125;
            this.ux_sessionPanel.SaveRequired = false;
            this.ux_sessionPanel.Size = new System.Drawing.Size(472, 293);
            this.ux_sessionPanel.TabIndex = 0;
            this.ux_sessionPanel.SessionUpdating += new System.EventHandler(this.SessionPanel_SessionUpdating);
            this.ux_sessionPanel.SessionNameChanged += new System.EventHandler(this.SessionPanel_SessionNameChanged);
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(472, 293);
            this.Controls.Add(this.ux_sessionPanel);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Name = "Session";
            this.Text = "Session";
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        protected override void OnClosing(CancelEventArgs e)
        {
            if (!this.ux_sessionPanel.CloseSession())
            {
                e.Cancel = true;
            }
        }
        #endregion
        public void CloseSession()
        {
            if (this.ux_sessionPanel.CloseSession())
            {
                base.Close();
            }
        }
        public bool SaveSession()
        {
            return this.ux_sessionPanel.SaveSession();
        }
        public bool SaveSession(string name)
        {
            return this.ux_sessionPanel.SaveSession(name);
        }
        public bool SaveSessionAs()
        {
            return this.ux_sessionPanel.SaveSessionAs();
        }
        public void StartModeling()
        {
            this.ux_sessionPanel.StartModeling();
        }
        public void StopModeling()
        {
            this.ux_sessionPanel.StopModeling();
        }
        void SessionPanel_SessionNameChanged(object sender, EventArgs e)
        {
            this.Text = this.ux_sessionPanel.Text;
        }
        void SessionPanel_SessionUpdating(object sender, EventArgs e)
        {
            this._parent.SetStatus(this, this.ux_sessionPanel.Status);
            this._parent.RefreshSession();
        }
        public void RefreshSession()
        {
            this.ux_sessionPanel.RefreshSession();
            this._parent.RefreshSession();
        }
        #endregion
        #region 
        public string SessionName { get { return this.ux_sessionPanel.SessionName; } }
        public string SessionPath { get { return this.ux_sessionPanel.SessionPath; } }
        public ICompliance Compliance { get { return this.ux_sessionPanel.Compliance; } set { this.ux_sessionPanel.Compliance = value; } }
        public Industry Data { get { return this.ux_sessionPanel.Data; } set { this.ux_sessionPanel.Data = value; } }
        public ModelingSettings Settings
        {
            get { return this.ux_sessionPanel.Settings; }
        }
        public bool Running { get { return this.ux_sessionPanel.Running; } }
        public string Status { get { return this.ux_sessionPanel.Status; } }
        public int RefreshInterval
        {
            get { return this.ux_sessionPanel.RefreshInterval; }
            set { this.ux_sessionPanel.RefreshInterval = value; }
        }
        public bool IsOpen { get { return this.ux_sessionPanel.IsOpen; } }
        public bool ReadOnly { get { return this.ux_sessionPanel.ReadOnly; } }
        public bool SaveRequired
        {
            get { return this.ux_sessionPanel.SaveRequired; }
            set { this.ux_sessionPanel.SaveRequired = value; }
        }
        #endregion
        #region 
        #region 
        SessionPanel ux_sessionPanel;
        #endregion
        Cafe2d _parent;
        #endregion
	}
}

