#region << Using Directives >>
using System;
using Volpe.Cafe.Generic;
#endregion
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class VCFuelValue : VCValue<FuelValue>, ICloneable
    {
        #region 
        public VCFuelValue() : base() { }
        public VCFuelValue(FuelValue initialValue) : base(initialValue, initialValue, initialValue, initialValue) { }
        public VCFuelValue(FuelValue ldv, FuelValue ldt12a, FuelValue ldt2b3, FuelValue mdt456) : base(ldv, ldt12a, ldt2b3, mdt456) { }
        #endregion
        #region 
        #region 
        public static VCFuelValue operator +(VCFuelValue value1, VCFuelValue value2)
        {
            VCFuelValue result = new VCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] + value2.Items[i];
            }
            return result;
        }
        public static VCFuelValue operator -(VCFuelValue value1, VCFuelValue value2)
        {
            VCFuelValue result = new VCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] - value2.Items[i];
            }
            return result;
        }
        public static VCFuelValue operator *(VCFuelValue value1, VCFuelValue value2)
        {
            VCFuelValue result = new VCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] * value2.Items[i];
            }
            return result;
        }
        public static VCFuelValue operator /(VCFuelValue value1, VCFuelValue value2)
        {
            VCFuelValue result = new VCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] / value2.Items[i];
            }
            return result;
        }
        public static VCFuelValue operator +(VCFuelValue value)
        {
            return VCFuelValue.Zero + value;
        }
        public static VCFuelValue operator -(VCFuelValue value)
        {
            return VCFuelValue.Zero - value;
        }
        public static VCFuelValue operator ++(VCFuelValue value)
        {
            return value + VCFuelValue.One;
        }
        public static VCFuelValue operator --(VCFuelValue value)
        {
            return value - VCFuelValue.One;
        }
        #endregion
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public new VCFuelValue Clone()
        {
            VCFuelValue value = new VCFuelValue();
            this.CopyTo(value);
            return value;
        }
        #endregion
        public string ToString(string format)
        {
            string s = string.Empty;
            for (int i = 0; i < this.Items.Length; i++)
            {
                if (i > 0) { s += ", "; }
                s += (Names[i] + "=" + this.Items[i].ToString(format));
            }
            return "{" + s + "}";
        }
        public string ToString(int digits)
        {
            string s = string.Empty;
            for (int i = 0; i < this.Items.Length; i++)
            {
                if (i > 0) { s += ", "; }
                s += (Names[i] + "=" + this.Items[i].ToString(digits));
            }
            return "{" + s + "}";
        }
        public FuelValue GetValue(VehicleClass vehClass)
        {
            return (vehClass == VehicleClass.All) ? this.Total : this[vehClass];
        }
        #endregion
        #region 
        public static VCFuelValue Zero { get { return new VCFuelValue(FuelValue.Zero); } }
        public static VCFuelValue One { get { return new VCFuelValue(FuelValue.One); } }
        public double this[VehicleClass vehClass, FuelType fuelType]
        {
            get { return this.Items[this.GetIndex(vehClass)][fuelType]; }
            set { this.Items[this.GetIndex(vehClass)][fuelType] = value; }
        }
        public FuelValue Total
        {
            get
            {
                FuelValue total = FuelValue.Zero;
                for (int i = 0; i < this.Items.Length; i++)
                {
                    total += this.Items[i];
                }
                return total;
            }
        }
        #endregion
    }
}

