using System;
namespace Volpe.Cafe
{
    [Serializable]
    public enum TechnologyOverride : int
    {
        None = 0,
        Used = 1,
        Skip = 2,
        Force = 3,
        Unused = 4
    }
    [Serializable]
    public enum Estimates : int
    {
        Low = 0,
        Average = 1,
        High = 2,
        VeryHigh = 3
    }
    [Serializable]
    public enum TechnologyType : int
    {
        Other = 0,
        Engine = 1,
        DieselEngine = 2,
        Transmission = 3,
        Electrification = 4,
        MR = 5,
        ROLL = 6,
        DLR = 7,
        Aerodynamics = 8
    }
    [Serializable]
    public enum TechnologyComplexity : int
    {
        None = 0,
        Low = 1,
        Medium = 2,
        High = 3
    }
    [Serializable]
    public enum LearningType : int
    {
        None   = 0,
        Volume = 1,
        Time   = 2,
        Slope  = 3,
        Table  = 4
    }
    [Serializable]
    public enum SynergyType : int
    {
        None = 0,
        Accounting = 1,
        Physical = 2
    }
    [Serializable]
    public enum VehicleClass : int
    {
        All = -1,
        None = 0,
        LDV = 1,
        LDT1 = 2,
        LDT2a = 3,
        LDT2b = 4,
        LDT3 = 5,
        MDT4 = 6,
        MDT5 = 7,
        MDT6 = 8,
        HDT7 = 9,
        HDT8 = 10,
        LDT12a = 101,
        LDT2b3 = 102,
        MDT456 = 103,
        HDT78 = 104
    }
    [Serializable]
    public enum VehicleType : int
    {
        None = 0,
        Domestic = 1,
        Imported = 2,
        PassengerAuto = 4,
        LightTruck = 8,
        HeavyLT = 16
    }
    [Serializable]
    public enum VehicleStyle : int
    {
        None = 0,
        Convertible = 1,
        Coupe = 2,
        Hatchback = 3,
        Sedan = 4,
        Wagon = 5,
        Minivan = 6,
        Van = 7,
        SportUtility = 8,
        Pickup = 9,
        ChassisCab = 10,
        Cutaway = 11
    }
    [Serializable]
    public enum HEVType : int
    {
        None = 0,
        MildHybrid = 1,
        StrongHybrid = 2,
        PlugInHybrid = 3,
        PureElectric = 4,
        FuelCell = 5
    }
    [Serializable]
    [Flags]
    public enum FuelType : int
    {
        None = 0,
        Gasoline = 1,
        Ethanol85 = 2,
        Diesel = 16,
        Biodiesel20 = 32,
        Electricity = 256,
        Hydrogen = 512,
        CNG = 1024,
        LNG = 2048,
        LPG = 4096,
        GasolineE85 = Gasoline | Ethanol85,
        GasolineElectric = Gasoline | Electricity,
        DieselB20 = Diesel | Biodiesel20,
        DieselElectric = Diesel | Electricity,
        All =
            Gasoline | Ethanol85 |
            Diesel | Biodiesel20 |
            Electricity | Hydrogen | CNG | LNG | LPG
    }
    [Serializable]
    public enum Pollutant : int
    {
        CO = 0,
        VOC = 1,
        NOx = 2,
        SO2 = 3,
        PM = 4,
        CO2 = 5,
        CH4 = 6,
        N2O = 7,
        Acetaldehyde = 8,
        Acrolein = 9,
        Benzene = 10,
        Butadiene = 11,
        Formaldehyde = 12,
        DPM10 = 13,
        MTBE = 14
    }
    [Serializable]
    public enum RegulatoryClass : int
    {
        All = -1,
        None = 0,
        PassengerCar = 1,
        LightTruck = 2,
        LightTruck2b3 = 3
    }
    [Serializable]
    public enum FCModLevel : int
    {
        Default = 0,
        Primary = 1,
        Secondary = 2
    }
    [Serializable]
    public enum OptimizationType : int
    {
        Default = 0,
        PassengerAuto = 1,
        LightTruck = 2
    }
    [Serializable]
    public enum OptimizationMode : int
    {
        MaximumNetBenefits = 1,
        ZeroNetBeneftis = 2,
        MaximumPrivateNetBenefits = 3
    }
    [Serializable]
    public enum FunctionalFitMode : int
    {
        None = 0,
        Weighted   = 1,
        Unweighted = 2,
        Lsq = 4,
        Mad = 8,
        TsLsq = 16,
        TsMad = 32,
        Lnr = 1024,
        WeightedLsq = Weighted | Lsq,
        UnweightedLsq = Unweighted | Lsq,
        WeightedTsLsq = Weighted | TsLsq,
        UnweightedTsLsq = Unweighted | TsLsq,
        WeightedMad = Weighted | Mad,
        UnweightedMad = Unweighted | Mad,
        WeightedTsMad = Weighted | TsMad,
        UnweightedTsMad = Unweighted | TsMad,
        WeightedLnr = Weighted | Lnr,
        UnweightedLnr = Unweighted | Lnr
    }
    [Serializable]
    public enum CalibrationMode : int
    {
        Default = Weighted | Unweighted | ByPercent,
        Weighted = 1,
        Unweighted = 2,
        ByPercent = 4,
        ByFpOrCw = 8,
        ByVehicleType = 16,
        WeightedByPct = Weighted | ByPercent,
        UnweightedByPct = Unweighted | ByPercent,
        WeightedByFpCw = Weighted | ByFpOrCw,
        UnweightedByFpCw = Unweighted | ByFpOrCw,
        WeightedByVehicleType = Unweighted | ByVehicleType
    }
    [Serializable]
    public enum EqualizationMode : int
    {
        None = 0,
        Cost = 1,
        Standard = 2,
        FuelEconomy = 3,
        FuelSavings = 4,
        CO2 = 5
    }
    [Serializable]
    [Obsolete("The use of Mobile6Class is obsolete.", false)]
    public enum Mobile6Class : int
    {
        None = 0,
        LDV = 1,
        LDT1 = 2,
        LDT2 = 3,
        HDV = 4
    }
    [Serializable]
    public enum SafetyClass : int
    {
        None = 0,
        PC = 1,
        LT = 2,
        CM = 3
    }
    [Serializable]
    public enum TechnologyClass : int
    {
        None = 0,
        SubcompactPC = 1,
        SubcompactPerfPC = 2,
        CompactPC = 3,
        CompactPerfPC = 4,
        MidsizePC = 5,
        MidsizePerfPC = 6,
        LargePC = 7,
        LargePerfPC = 8,
        MinivanLT = 9,
        SmallLT = 10,
        MidsizeLT = 11,
        LargeLT = 12,
        Truck2b3 = 13,
        Van2b3 = 14,
        Max = 14
    }
    [Serializable]
    public enum EngineSize : int
    {
        None = 0,
        Small = 1,
        Medium = 2,
        Large = 3
    }
    [Serializable]
    public enum ModelingApproach : int
    {
        LowCostFirst = 0,
        EconomicEfficiency = 1
    }
    [Serializable]
    public enum CreditAdjustmentMode : int
    {
        Variable = 0,
        Fixed = 1
    }
}

