using System;
namespace Volpe.Cafe.Model
{
    public sealed class FunctionInformation
    {
        #region 
        static int[] SupportedFunctions = { 1, 2, 3, 4, 5, 6, 7, 8, 99, 206, 207, 208 };
        static int[] CoefficientCount   = { 1, 4, 4, 3, 3, 4, 4, 8,   8,   8,   9 };
        static string[][] CoefficientNames =
            {
                new string[] {"A"},                                         
                new string[] {"A", "B", "C", "D"},                          
                new string[] {"A", "B", "C", "D"},                          
                new string[] {"A", "B", "C"},                               
                new string[] {"A", "B", "C"},                               
                new string[] {"A", "B", "C", "D"},                          
                new string[] {"A", "B", "C", "D"},                          
                new string[] {"A", "B", "C", "D", "E", "F", "G", "H"},      
                new string[] {"A", "B", "C", "D", "E", "F", "G", "H"},      
                new string[] {"A", "B", "C", "D", "E", "F", "G", "H"},      
                new string[] {"A", "B", "C", "D", "E", "F", "G", "H", "I"}  
            };
        static int[] FlatStandard    = { 1, 99 };
        static int[] Logistic        = { 2, 3 };
        static int[] Exponential     = { 4, 5 };
        static int[] Linear          = { 6, 7, 8, 206, 207, 208 };
        static int[] AreaBased       = { 2, 4, 6, 206 };
        static int[] WeightBased     = { 3, 5, 7, 207 };
        static int[] WorkFactorBased = {       8, 208 };
        #endregion
        #region 
        static int FindFunction(int fncType, params int[] values)
        {
            for (int i = 0; i < values.Length; i++)
            {
                if (fncType == values[i]) { return i; }
            }
            return -1;
        }
        static bool HasFunction(int fncType, params int[] values)
        {
            return (FindFunction(fncType, values) != -1);
        }
        public static bool IsSupportedFunction(int fncType)
        {
            return HasFunction(fncType, SupportedFunctions);
        }
        public static bool IsFlatStandard(int fncType)
        {
            return HasFunction(fncType, FlatStandard);
        }
        public static bool IsLogisticFunction(int fncType)
        {
            return HasFunction(fncType, Logistic);
        }
        public static bool IsExponentialFunction(int fncType)
        {
            return HasFunction(fncType, Exponential);
        }
        public static bool IsLinearFunction(int fncType)
        {
            return HasFunction(fncType, Linear);
        }
        public static bool IsAreaBasedFunction(int fncType)
        {
            return HasFunction(fncType, AreaBased);
        }
        public static bool IsWeightBasedFunction(int fncType)
        {
            return HasFunction(fncType, WeightBased);
        }
        public static bool IsWorkFactorBasedFunction(int fncType)
        {
            return HasFunction(fncType, WorkFactorBased);
        }
        public static int GetCoefficientCount(int fncType)
        {
            int fncIndex = FindFunction(fncType, SupportedFunctions);
            return (fncIndex == -1) ? -1 : CoefficientCount[fncIndex];
        }
        public static string[] GetCoefficientNames(int fncType)
        {
            int fncIndex = FindFunction(fncType, SupportedFunctions);
            return (fncIndex == -1) ? null : CoefficientNames[fncIndex];
        }
        #endregion
    }
}

