using System;
using Volpe.Cafe.IO;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Utils;
namespace Volpe.Cafe.MonteCarlo.Settings
{
    [Serializable]
    public class MonteCarloSettings : ISettings, ICloneable
    {
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        ISettings ISettings.Clone()
        {
            return this.Clone();
        }
        MonteCarloSettings Clone()
        {
            MonteCarloSettings value = new MonteCarloSettings();
            Clone(this, value);
            return value;
        }
        static void Clone(MonteCarloSettings src, MonteCarloSettings dst)
        {
            dst.TrialsFile         = src.TrialsFile;
            dst.GenerateMCLogs     = src.GenerateMCLogs;
            dst.MaxThreads         = src.MaxThreads;
            dst.FuelPriceStartYear = src.FuelPriceStartYear;
            dst.PriceShockAlpha    = src.PriceShockAlpha;
        }
        #endregion
        #region 
        void ISettings.SetDefaultSettings()
        {
            this.TrialsFile         = string.Empty;
            this.GenerateMCLogs     = true;
            this.MaxThreads         = -1;
            this.FuelPriceStartYear = 2015;
            this.PriceShockAlpha    = 1;
        }
        void ISettings.UpdateSettings(ISettings newSettings)
        {
            this.UpdateSettings((MonteCarloSettings)newSettings);
        }
        public void UpdateSettings(MonteCarloSettings newSettings)
        {
            Clone(newSettings, this);
        }
        public void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Monte-Carlo Settings ---" +
                "\n  TrialsFile="         + this.TrialsFile +
                "\n  GenerateMCLogs="     + this.GenerateMCLogs +
                "\n  MaxThreads="         + ((this.MaxThreads == -1) ? "Auto" : this.MaxThreads.ToString()) +
                "\n  FuelPriceStartYear=" + this.FuelPriceStartYear +
                "\n  PriceShockAlpha="    + this.PriceShockAlpha;
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #endregion
        #region 
        public string TrialsFile;
        public bool GenerateMCLogs;
        public int MaxThreads;
        public int FuelPriceStartYear;
        public double PriceShockAlpha;
        #endregion
    }
}

