#region << Using Directives >>
using System;
using Volpe.Cafe.Generic;
#endregion
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class RCFuelValue : RCValue<FuelValue>, ICloneable
    {
        #region 
        public RCFuelValue() : base() { }
        public RCFuelValue(FuelValue initialValue) : base(initialValue, initialValue, initialValue) { }
        public RCFuelValue(FuelValue passengerCar, FuelValue lightTruck, FuelValue lightTruck2b3) :
            base(passengerCar, lightTruck, lightTruck2b3) { }
        #endregion
        #region 
        #region 
        public static RCFuelValue operator +(RCFuelValue value1, RCFuelValue value2)
        {
            RCFuelValue result = new RCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] + value2.Items[i];
            }
            return result;
        }
        public static RCFuelValue operator -(RCFuelValue value1, RCFuelValue value2)
        {
            RCFuelValue result = new RCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] - value2.Items[i];
            }
            return result;
        }
        public static RCFuelValue operator *(RCFuelValue value1, RCFuelValue value2)
        {
            RCFuelValue result = new RCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] * value2.Items[i];
            }
            return result;
        }
        public static RCFuelValue operator /(RCFuelValue value1, RCFuelValue value2)
        {
            RCFuelValue result = new RCFuelValue();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] / value2.Items[i];
            }
            return result;
        }
        public static RCFuelValue operator +(RCFuelValue value)
        {
            return RCFuelValue.Zero + value;
        }
        public static RCFuelValue operator -(RCFuelValue value)
        {
            return RCFuelValue.Zero - value;
        }
        public static RCFuelValue operator ++(RCFuelValue value)
        {
            return value + RCFuelValue.One;
        }
        public static RCFuelValue operator --(RCFuelValue value)
        {
            return value - RCFuelValue.One;
        }
        #endregion
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public new RCFuelValue Clone()
        {
            RCFuelValue value = new RCFuelValue();
            this.CopyTo(value);
            return value;
        }
        #endregion
        public string ToString(string format)
        {
            string s = string.Empty;
            for (int i = 0; i < this.Items.Length; i++)
            {
                if (i > 0) { s += ", "; }
                s += (Names[i] + "=" + this.Items[i].ToString(format));
            }
            return "{" + s + "}";
        }
        public string ToString(int digits)
        {
            string s = string.Empty;
            for (int i = 0; i < this.Items.Length; i++)
            {
                if (i > 0) { s += ", "; }
                s += (Names[i] + "=" + this.Items[i].ToString(digits));
            }
            return "{" + s + "}";
        }
        public FuelValue GetValue(RegulatoryClass regClass)
        {
            return (regClass == RegulatoryClass.All) ? this.Total : this[regClass];
        }
        #endregion
        #region 
        public static RCFuelValue Zero { get { return new RCFuelValue(FuelValue.Zero); } }
        public static RCFuelValue One { get { return new RCFuelValue(FuelValue.One); } }
        public double this[RegulatoryClass regClass, FuelType fuelType]
        {
            get { return this.Items[this.GetIndex(regClass)][fuelType]; }
            set { this.Items[this.GetIndex(regClass)][fuelType] = value; }
        }
        public FuelValue Total
        {
            get
            {
                FuelValue total = FuelValue.Zero;
                for (int i = 0; i < this.Items.Length; i++)
                {
                    total += this.Items[i];
                }
                return total;
            }
        }
        #endregion
    }
}

