#region << Using Directives >>
using System;
using System.Collections.Generic;
using Volpe.Cafe.Data;
#endregion
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public sealed class TechnologySynergies
    {
        #region 
        public TechnologySynergies()
        {
            this._synergies = new List<TechnologySynergy>[(int)TechnologyClass.Max];
            for (int i = 0; i < this._synergies.Length; i++)
            {
                this._synergies[i] = new List<TechnologySynergy>();
            }
        }
        #endregion
        #region 
        internal TechnologySynergies Clone()
        {
            TechnologySynergies value = new TechnologySynergies();
            for (int i = 0; i < this._synergies.Length; i++)
            {
                for (int j = 0; j < this._synergies[i].Count; j++)
                {
                    value._synergies[i].Add(this._synergies[i][j].Clone());
                }
            }
            return value;
        }
        internal void AddSynergy(TechnologyClass techClass, EngineSize engSize, int techIndex, SynergyType type, double value)
        {
            if (value == 0) { return; }
            int tcIndex = (int)techClass - 1;
            int index   = this.IndexOf(tcIndex, engSize, techIndex, false);
            if (index != -1)    
            {   
                this._synergies[tcIndex].RemoveAt(index);
            }
            this._synergies[tcIndex].Add(new TechnologySynergy(techClass, engSize, techIndex, type, value));
        }
        int IndexOf(TechnologyClass techClass, EngineSize engSize, int techIndex, bool allowDefaultEng)
        {
            return this.IndexOf((int)techClass - 1, engSize, techIndex, allowDefaultEng);
        }
        int IndexOf(int techClass, EngineSize engSize, int techIndex, bool allowDefaultEng)
        {
            if (techClass < 0 || techClass >= (int)TechnologyClass.Max) { throw new ArgumentOutOfRangeException("techClass", ErrorStrings.TechClassNotValid); }
            int j = -1;
            for (int i = 0; i < this._synergies[techClass].Count; i++)
            {
                TechnologySynergy s = this._synergies[techClass][i];
                if (s.EngSize == engSize         && s.TechIndex == techIndex) { return i; }
                if (allowDefaultEng &&
                    s.EngSize == EngineSize.None && s.TechIndex == techIndex) { j = i; }
            }
            return j;
        }
        #endregion
        #region 
        public TechnologySynergy this[Vehicle veh, int techIndex]
        {
            get
            {
                return this[veh.TechnologyClass, veh.Engine.Description.EngineSize, techIndex];
            }
        }
        public TechnologySynergy this[TechnologyClass techClass, EngineSize engSize, int techIndex]
        {
            get
            {
                int tcIndex = (int)techClass - 1;
                int index   = this.IndexOf(tcIndex, engSize, techIndex, true);
                return (index == -1) ? TechnologySynergy.Empty : this._synergies[tcIndex][index];
            }
        }
        #endregion
        #region 
        List<TechnologySynergy>[] _synergies;   
        #endregion
    }
}

