using System;
using System.Text;
namespace Volpe.Cafe
{
    [Serializable]
    public sealed class TechnologyIndexes
    {
        #region 
        static TechnologyIndexes()
        {
            TechnologyCount = TechAbbr.Length;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < TechnologyCount; i++)
            {
                sb.Append(TechAbbr[i]);
                sb.Append(',');
            }
            TechAbbrCSV = sb.ToString(0, sb.Length - 1);
        }
        #endregion
        #region 
        public static int GetIndex(string abbr)
        {
            for (int i = 0; i < TechnologyCount ; i++)
            {
                if (TechAbbr[i] == abbr) { return i; }
            }
            return -1;
        }
        public static string GetAbbr(int index)
        {
            if ((index < 0) || (index >= TechnologyCount)) { return string.Empty; }
            return TechAbbr[index];
        }
        public static bool IsEngineLevel(int index)
        {
            return ContainsIndex(index, EngineLevel);
        }
        public static bool IsTransmissionLevel(int index)
        {
            return ContainsIndex(index, TransmissionLevel);
        }
        public static bool IsPlatformLevel(int index)
        {
            return ContainsIndex(index, PlatformLevel);
        }
        public static bool IsConversionToDiesel(int index)
        {
            return ContainsIndex(index, ConversionToDiesel);
        }
        public static bool IsConversionToCNG(int index)
        {
            return ContainsIndex(index, ConversionToCNG);
        }
        public static bool IsConversionToLNG(int index)
        {
            return ContainsIndex(index, ConversionToLNG);
        }
        public static bool IsConversionToLPG(int index)
        {
            return ContainsIndex(index, ConversionToLPG);
        }
        public static bool IsConversionToMHEV(int index)
        {
            return ContainsIndex(index, ConversionToMHEV);
        }
        public static bool IsConversionToSHEV(int index)
        {
            return ContainsIndex(index, ConversionToSHEV);
        }
        public static bool IsConversionToPHEV(int index)
        {
            return ContainsIndex(index, ConversionToPHEV);
        }
        public static bool IsConversionToEV(int index)
        {
            return ContainsIndex(index, ConversionToEV);
        }
        public static bool IsConversionToFCV(int index)
        {
            return ContainsIndex(index, ConversionToFCV);
        }
        public static bool IsMaterialSubstitution(int index)
        {
            return ContainsIndex(index, MaterialSubstitution);
        }
        public static bool IsConfigurationBased(int index)
        {
            return ContainsIndex(index, ConfigurationBased);
        }
        public static bool IsCylinderBased(int index)
        {
            return ContainsIndex(index, CylinderBased);
        }
        public static bool IsTiedToRedesign(int index)
        {
            return ContainsIndex(index, TiedToRedesign);
        }
        public static bool IsTiedToRefresh(int index)
        {
            return ContainsIndex(index, TiedToRefresh);
        }
        public static int[] GetSharedPhaseInTechs(int index)
        {
            switch (index)
            {
                case CCPS   : case ICP  :                       return SharedPhaseIn_VVT;
                case DVVLS  : case DVVLD: case CVVL : case VVA: return SharedPhaseIn_VVL;
                case DEACS  : case DEACD: case DEACO:           return SharedPhaseIn_DEAC;
                case SGDI   : case SGDIO:                       return SharedPhaseIn_SGDI;
                case SHEV1_2: case SHEV2:                       return SharedPhaseIn_SHEV2;
                default: return null;
            }
        }
        static bool ContainsIndex(int index, int[] list)
        {
            for (int i = 0; i < list.Length; i++)
            {
                if (list[i] == index) { return true; }
            }
            return false;
        }
        #endregion
        #region 
        #region 
        public static readonly int[] EngineLevel = new int[] { LUB1, EFR1, LUB2_EFR2, CCPS, DVVLS, DEACS, ICP, DCP, DVVLD, CVVL,
            DEACD, SGDI, DEACO, VVA, SGDIO, TRBDS1, SEGR, DWNSP, TRBDS2, CEGR1, CEGR2, MILLER, LGDI, CNG, LNG, LPG, DSL, DTURB,
            EFRD, DDOWN };
        public static readonly int[] TransmissionLevel = new int[] { MAN6, HETRANSM, IATC, NAUTO, DCT, A8SPD, HETRANS, SHFTOPT };
        public static readonly int[] PlatformLevel = new int[] { MR1, MR2, MR3, MR4, MR5, AERO1, AERO2 };
        static readonly int[] ConversionToDiesel   = new int[] { DSL, DTURB, EFRD, DDOWN };
        static readonly int[] ConversionToCNG      = new int[] { CNG };
        static readonly int[] ConversionToLNG      = new int[] { LNG };
        static readonly int[] ConversionToLPG      = new int[] { LPG };
        static readonly int[] ConversionToMHEV     = new int[] { MHEV, ISG };
        static readonly int[] ConversionToSHEV     = new int[] { SHEV1, SHEV1_2, SHEV2 };
        static readonly int[] ConversionToPHEV     = new int[] { PHEV1, PHEV2 };
        static readonly int[] ConversionToEV       = new int[] { EV1, EV2, EV3, EV4 };
        static readonly int[] ConversionToFCV      = new int[] { FCV };
        static readonly int[] MaterialSubstitution = new int[] { MR1, MR2, MR3, MR4, MR5 };
        static readonly int[] ConfigurationBased   = new int[] { CCPS, ICP, DCP, VVA };
        static readonly int[] CylinderBased        = new int[] { EFR1, LUB2_EFR2, DVVLS, DVVLD, CVVL, SGDI, SGDIO };
        static readonly int[] TiedToRedesign = new int[] {
            DVVLS, DVVLD, CVVL, VVA, SGDI, SGDIO, TRBDS1, SEGR, DWNSP, TRBDS2, CEGR1, CEGR2, MILLER, LGDI, CNG, LNG, LPG, DSL,
            DTURB, EFRD, DDOWN,
            MAN6, HETRANSM, NAUTO, DCT, A8SPD, HETRANS,
            MHEV, ISG, SHEV1, SHEV1_2, SHEV2, PHEV1, PHEV2, EV1, EV2, EV3, EV4, FCV, MR2, MR3, MR4, MR5, AERO2 };
        static readonly int[] TiedToRefresh  = new int[] { EFR1, LUB2_EFR2, CCPS, DEACS, ICP, DCP, DEACD, DEACO, IATC, SHFTOPT,
            EPS, IACC1, IACC2, MR1, ROLL1, ROLL2, ROLL3, LDB, SAX, AERO1 };
        #endregion
        #region 
        static readonly int[] SharedPhaseIn_VVT    = new int[] { CCPS, ICP };
        static readonly int[] SharedPhaseIn_VVL    = new int[] { DVVLS, DVVLD, CVVL, VVA };
        static readonly int[] SharedPhaseIn_DEAC   = new int[] { DEACS, DEACD, DEACO };
        static readonly int[] SharedPhaseIn_SGDI   = new int[] { SGDI, SGDIO };
        static readonly int[] SharedPhaseIn_SHEV2  = new int[] { SHEV1_2, SHEV2 };
        #endregion
        public static readonly TechnologyClass[] TechClasses = new TechnologyClass[] {
            TechnologyClass.SubcompactPC, TechnologyClass.SubcompactPerfPC, TechnologyClass.CompactPC, TechnologyClass.CompactPerfPC,
            TechnologyClass.MidsizePC   , TechnologyClass.MidsizePerfPC   , TechnologyClass.LargePC  , TechnologyClass.LargePerfPC  ,
            TechnologyClass.MinivanLT   , TechnologyClass.SmallLT         , TechnologyClass.MidsizeLT, TechnologyClass.LargeLT,
            TechnologyClass.Truck2b3    , TechnologyClass.Van2b3 };
        public static readonly string[] TechAbbr = new string[] {
            "LUB1" , "EFR1"    , "LUB2_EFR2", "CCPS" , "DVVLS"  , "DEACS" , "ICP"    , "DCP"    , "DVVLD" , "CVVL" ,
            "DEACD", "SGDI"    , "DEACO"    , "VVA"  , "SGDIO"  , "TRBDS1", "SEGR"   , "DWNSP"  , "TRBDS2", "CEGR1",
            "CEGR2", "MILLER"  , "LGDI"     , "CNG"  , "LNG"    , "LPG"   , "DSL"    , "DTURB"  , "EFRD"  , "DDOWN",
            "6MAN" , "HETRANSM", "IATC"     , "NAUTO", "DCT"    , "8SPD"  , "HETRANS", "SHFTOPT", "EPS"   , "IACC1",
            "IACC2", "MHEV"    , "ISG"      , "SHEV1", "SHEV1_2", "SHEV2" , "PHEV1"  , "PHEV2"  , "EV1"   , "EV2"  ,
            "EV3"  , "EV4"     , "FCV"      , "MR1"  , "MR2"    , "MR3"   , "MR4"    , "MR5"    , "ROLL1" , "ROLL2",
            "ROLL3", "LDB"     , "SAX"      , "AERO1", "AERO2" };
        public static readonly string TechAbbrCSV;
        public static readonly int TechnologyCount;
         public const int  LUB1         =  0;
         public const int  EFR1         =  1;
         public const int  LUB2_EFR2    =  2;
         public const int  CCPS         =  3;
         public const int  DVVLS        =  4;
         public const int  DEACS        =  5;
         public const int  ICP          =  6;
         public const int  DCP          =  7;
         public const int  DVVLD        =  8;
         public const int  CVVL         =  9;
         public const int  DEACD        = 10;
         public const int  SGDI         = 11;
         public const int  DEACO        = 12;
         public const int  VVA          = 13;
         public const int  SGDIO        = 14;
         public const int  TRBDS1       = 15;
         public const int  SEGR         = 16;
         public const int  DWNSP        = 17;
         public const int  TRBDS2       = 18;
         public const int  CEGR1        = 19;
         public const int  CEGR2        = 20;
         public const int  MILLER       = 21;
         public const int  LGDI         = 22;
         public const int  CNG          = 23;
         public const int  LNG          = 24;
         public const int  LPG          = 25;
         public const int  DSL          = 26;
         public const int  DTURB        = 27;
         public const int  EFRD         = 28;
         public const int  DDOWN        = 29;
         public const int  MAN6         = 30;
         public const int  HETRANSM     = 31;
         public const int  IATC         = 32;
         public const int  NAUTO        = 33;
         public const int  DCT          = 34;
         public const int  A8SPD        = 35;
         public const int  HETRANS      = 36;
         public const int  SHFTOPT      = 37;
         public const int  EPS          = 38;
         public const int  IACC1        = 39;
         public const int  IACC2        = 40;
         public const int  MHEV         = 41;
         public const int  ISG          = 42;
         public const int  SHEV1        = 43;
         public const int  SHEV1_2      = 44;
         public const int  SHEV2        = 45;
         public const int  PHEV1        = 46;
         public const int  PHEV2        = 47;
         public const int  EV1          = 48;
         public const int  EV2          = 49;
         public const int  EV3          = 50;
         public const int  EV4          = 51;
         public const int  FCV          = 52;
         public const int  MR1          = 53;
         public const int  MR2          = 54;
         public const int  MR3          = 55;
         public const int  MR4          = 56;
         public const int  MR5          = 57;
         public const int  ROLL1        = 58;
         public const int  ROLL2        = 59;
         public const int  ROLL3        = 60;
         public const int  LDB          = 61;
         public const int  SAX          = 62;
         public const int  AERO1        = 63;
         public const int  AERO2        = 64;
        #endregion
    }
}

