using System;
namespace Volpe.Cafe.UI
{
    public class PromptEventArgs : EventArgs
    {
        #region 
        public PromptEventArgs(string title, string message, PromptOption promptOption) : base()
        {
            this._title        = title;
            this._message      = message;
            this._promptOption = promptOption;
            this._promptResult = PromptResult.None;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return this._title + " - " + this._message;
        }
        #endregion
        #region 
        public string Title { get { return this._title; } }
        public string Message { get { return this._message; } }
        public PromptOption PromptOption { get { return this._promptOption; } }
        public PromptResult PromptResult { get { return this._promptResult; } set { this._promptResult = value; } }
        #endregion
        #region 
        string _title;
        string _message;
        PromptOption _promptOption;
        PromptResult _promptResult;
        #endregion
    }
}

