using System;
using System.Collections;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
namespace Volpe.Cafe.UI
{
    public class Messages
    {
        #region 
        private struct Message
        {
            public Message(string shortDescription, string longDescription, Color color, object key)
            {
                this.ShortDescription = shortDescription;
                this.LongDescription = longDescription;
                this.Color = color;
                this.Key = key;
            }
            public string ShortDescription;
            public string LongDescription;
            public Color Color;
            public object Key;
        }
        #endregion
        #region 
        public event EventHandler MessagesChanged;
        #endregion
        #region 
        public Messages()
        {
            this._list = new ArrayList();
        }
        #endregion
        #region 
        public void AddMessage(string shortDescription, string longDescription, Color color, object key)
        {
            this.RemoveMessage(key);
            this._list.Add(new Message(shortDescription, longDescription, color, key));
            this.OnMessagesChanged(EventArgs.Empty);
        }
        public void RemoveMessage(object key)
        {
            int index = this.FindMessage(key);
            while (index != -1)
            {
                this.RemoveMessage(index);
                index = this.FindMessage(key);
            }
        }
        public void RemoveMessage(int index)
        {
            if (index != -1)
            {   
                this._list.RemoveAt(index);
                this.OnMessagesChanged(EventArgs.Empty);
            }
        }
        public void ClearMessages()
        {
            this._list.Clear();
            this.OnMessagesChanged(EventArgs.Empty);
        }
        public int FindMessage(object key)
        {
            for (int i = 0; i < this._list.Count; i++)
            {
                if (((Message)this._list[i]).Key == key)
                {
                    return i;
                }
            }
            return -1;
        }
        public override string ToString()
        {
            StringBuilder sb = new System.Text.StringBuilder();
            for (int i = 0; i < this._list.Count; i++)
            {
                Message msg = (Message)this._list[i];
                sb.Append(msg.ShortDescription);
                sb.Append("\n");
            }
            return sb.ToString();
        }
        public string ToStringDetailed()
        {
            StringBuilder sb = new System.Text.StringBuilder();
            for (int i = 0; i < this._list.Count; i++)
            {
                Message msg = (Message)this._list[i];
                sb.Append(msg.ShortDescription);
                if (msg.LongDescription != null && msg.LongDescription != string.Empty)
                {
                    sb.Append("\n\n");
                    sb.Append(msg.LongDescription);
                    sb.Append("\n");
                }
                sb.Append("\n");
            }
            return sb.ToString();
        }
        protected void OnMessagesChanged(EventArgs e)
        {
            if (this.MessagesChanged != null)
            {
                this.MessagesChanged(this, e);
            }
        }
        #endregion
        #region 
        public bool HasMessages { get { return (this._list.Count > 0); } }
        #endregion
        #region 
        ArrayList _list;
        #endregion
    }
}

