#region << Using Directives >>
using System;
using System.Windows.Forms;
using Volpe.Cafe.Data;
using Volpe.Cafe.IO;
using Volpe.Cafe.IO.Reporting.CSV;
using Volpe.Cafe.IO.Reporting.XL;
using Volpe.Cafe.Settings;
using Volpe.Cafe.UI;
#endregion
namespace Volpe.Cafe.Model
{
    [ModelDescription("ICompliance", "Provides a standard interface on which to base each compliance model implementation.", 1.0F)]
    public interface ICompliance
    {
        #region 
        event PromptEventHandler Prompt;
        event ModelingEventHandler ModelingStarted;
        event ModelingEventHandler ModelingStopped;
        event ModelingEventHandler ModelingCompleted;
        event ModelingEventHandler ModelingChanged;
        event ModelingProgressEventHandler ScenarioStarted;
        event ModelingProgressEventHandler ScenarioCompleted;
        event ModelingProgressEventHandler ModelYearStarted;
        event ModelingProgressEventHandler ModelYearCompleted;
        event ModelingProgressEventHandler ManufacturerStarted;
        event ModelingProgressEventHandler ManufacturerCompleted;
        #endregion
        #region 
        ICompliance CreateNew();
        void Start(Industry data, ModelingSettings settings);
        void Abort();
        void Abort(bool abortWhenReady);
        Industry[] GetData(Scenario scen);
        Industry GetData(Scenario scen, ModelYear year);
        EffectsData GetEffectsData(Scenario scen, int year);
        #endregion
        #region 
        bool IsValid { get; }
        RequiredModelInputs RequiredModelInputs { get; }
        Industry Data { get; }
        Industry[] BaselineData { get; }
        Industry[] ScenarioData { get; }
        ModelingSettings Settings { get; }
        LogWriter LogWriter { get; }
        XlReportGenerator XlReportGenerator { get; }
        CsvReportGenerator CsvReportGenerator { get; }
        ModelingState State { get; }
        bool Running { get; }
        bool Stopped { get; }
        bool Completed { get; }
        bool StoppedOrCompleted { get; }
        IModelingProgress Progress { get; }
        DateTime StartTime { get; }
        DateTime StopTime { get; }
        long Runtime { get; }
        ModelYear[] ModelYears { get; }
        int MinYear { get; }
        int MaxYear { get; }
        int MinEffectsYear { get; }
        int MaxEffectsYear { get; }
        string LastErrorMessage { get; }
        string UserNotes { get; set; }
        string UserKeywords { get; set; }
        #endregion
    }
}

