using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public class InputSettings : ISettings, ICloneable
    {
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        ISettings ISettings.Clone()
        {
            return this.Clone();
        }
        InputSettings Clone()
        {
            InputSettings value = new InputSettings();
            Clone(this, value);
            return value;
        }
        static void Clone(InputSettings src, InputSettings dst)
        {
            dst.EncryptInput               = src.EncryptInput;
            dst.InputPassword              = src.InputPassword;
            dst.MarketDataFile             = src.MarketDataFile;
            dst.TechnologiesFile           = src.TechnologiesFile;
            dst.ParametersFile             = src.ParametersFile;
            dst.ScenariosFile              = src.ScenariosFile;
            dst.MarketDataTimestamp        = src.MarketDataTimestamp;
            dst.TechnologiesTimestamp      = src.TechnologiesTimestamp;
            dst.ParametersTimestamp        = src.ParametersTimestamp;
            dst.ScenariosTimestamp         = src.ScenariosTimestamp;
        }
        #endregion
        #region 
        void ISettings.SetDefaultSettings()
        {
            this.EncryptInput          = false;
            this.InputPassword         = string.Empty;
            this.MarketDataFile        = string.Empty;
            this.TechnologiesFile      = string.Empty;
            this.ParametersFile        = string.Empty;
            this.ScenariosFile         = string.Empty;
        }
        void ISettings.UpdateSettings(ISettings newSettings)
        {
            this.UpdateSettings((InputSettings)newSettings);
        }
        public void UpdateSettings(InputSettings newSettings)
        {
            Clone(newSettings, this);
        }
        void ISettings.WriteSummaryLog(LogWriter writer)
        {
            string format = "M/dd/yy H:mm:ss";
            if (writer.Summary == null) { return; }
            string outStr = "--- Input Settings ---" +
                "\n  EncryptInput="          + this.EncryptInput +
                "\n    InputPassword="       + this.MaskInputPassword('*') +
                "\n  MarketDataFile="        + this.MarketDataFile         + " (" + this.MarketDataTimestamp       .ToString(format) + ")" +
                "\n  TechnologiesFile="      + this.TechnologiesFile       + " (" + this.TechnologiesTimestamp     .ToString(format) + ")" +
                "\n  ParametersFile="        + this.ParametersFile         + " (" + this.ParametersTimestamp       .ToString(format) + ")" +
                "\n  ScenariosFile="         + this.ScenariosFile          + " (" + this.ScenariosTimestamp        .ToString(format) + ")";
            writer.Summary.WriteLine(outStr + "\n");
        }
        string MaskInputPassword(char pwMask)
        {
            return (this.InputPassword == null || this.InputPassword == string.Empty) ? "" : new string(pwMask, 8);
        }
        #endregion
        #endregion
        #region 
        public bool EncryptInput;
        public string InputPassword;
        public string MarketDataFile;
        public string TechnologiesFile;
        public string ParametersFile;
        public string ScenariosFile;
        public DateTime MarketDataTimestamp;
        public DateTime TechnologiesTimestamp;
        public DateTime ParametersTimestamp;
        public DateTime ScenariosTimestamp;
        #endregion
    }
}

