#region << Using Directives >>
using System;
#endregion
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public sealed class TechnologySynergy
    {
        #region 
        public TechnologySynergy(TechnologyClass techClass, EngineSize engSize, int techIndex, SynergyType type, double value)
        {
            this.TechClass = techClass;
            this.EngSize   = engSize;
            this.TechIndex = techIndex;
            this.Type      = type;
            this.Value     = value;
        }
        #endregion
        #region 
        static TechnologySynergy GetEmpty()
        {
            return new TechnologySynergy(TechnologyClass.None, EngineSize.None, -1, SynergyType.None, 0);
        }
        internal TechnologySynergy Clone()
        {
            return new TechnologySynergy(this.TechClass, this.EngSize, this.TechIndex, this.Type, this.Value);
        }
        #endregion
        #region 
        public TechnologyClass TechClass { get; private set; }
        public EngineSize EngSize { get; private set; }
        public int TechIndex { get; private set; }
        public SynergyType Type { get; private set; }
        public double Value { get; private set; }
        #endregion
        #region 
        public static readonly TechnologySynergy Empty = TechnologySynergy.GetEmpty();
        #endregion
    }
}

