#region << Using Directives >>
using System;
using Volpe.Cafe.IO.Reporting.CSV;
using Volpe.Cafe.Model;
using System.Collections.Generic;
using System.IO;
using Volpe.Cafe.Settings;
#endregion
namespace Volpe.Cafe.MonteCarlo.IO.Reporting
{
    [Serializable]
    public class CsvMonteCarloReportGenerator : CsvReportGenerator
    {
        #region 
        public CsvMonteCarloReportGenerator(ICompliance compliance) : base(compliance)
        {
            this.Compliance.ModelingCompleted += new ModelingEventHandler(this.Compliance_ModelingStoppedOrCompleted);
            this.Compliance.ModelingStopped   += new ModelingEventHandler(this.Compliance_ModelingStoppedOrCompleted);
        }
        #endregion
        #region 
        void Compliance_ModelingStoppedOrCompleted(object sender, ModelingEventArgs e)
        {
            foreach (Scenario scen in this.Compliance.Settings.Scenarios)
            {
                this.GenerateReportsForScenario(scen);
            }
            this.Compliance.ModelingCompleted -= new ModelingEventHandler(this.Compliance_ModelingStoppedOrCompleted);
            this.Compliance.ModelingStopped   -= new ModelingEventHandler(this.Compliance_ModelingStoppedOrCompleted);
        }
        protected override List<CsvReportingBase> OpenReports(int snIndex, string path)
        {
            if (!Directory.Exists(path)) { Directory.CreateDirectory(path); }
            List<CsvReportingBase> csvReports = new List<CsvReportingBase>(10);
            csvReports.Add(new CsvMonteCarloReport(path + "\\monte_carlo_report_sn" + snIndex + ".csv", false));
            return csvReports;
        }
        #endregion
        #region 
        #endregion
        #region 
        #endregion
    }
}

