#region << Using Directives >>
using System;
using Volpe.Cafe.Generic;
using Volpe.Cafe.Utils;
#endregion
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class EffectsValue : ICloneable
    {
        #region 
        EffectsValue(EffectsValue prototype)
        {
            this.Value1 = prototype.Value1.Clone();
            this.Value2 = prototype.Value2.Clone();
            this.AnnualValue1 = new VCFuelValue[Interaction.CY];
            for (int i = 0; i < prototype.AnnualValue1.Length; i++)
            {
                this.AnnualValue1[i] = prototype.AnnualValue1[i].Clone();
            }
        }
        public EffectsValue()
        {
            this.Value1 = new VCFuelValue();
            this.Value2 = new RCFuelValue();
            this.AnnualValue1 = new VCFuelValue[Interaction.CY];
            for (int i = 0; i < Interaction.CY; i++)
            {
                this.AnnualValue1[i] = new VCFuelValue();
            }
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public EffectsValue Clone()
        {
            return new EffectsValue(this);
        }
        #endregion
        public void Clear()
        {
            this.Value1.Clear();
            this.Value2.Clear();
            for (int i = 0; i < this.AnnualValue1.Length; i++)
            {
                this.AnnualValue1[i].Clear();
            }
        }
        public void AppendValue(double value, VehicleClass vehClass, FuelType fuelType, int age)
        {
            this.Value1           [vehClass, fuelType] += value;
            this.AnnualValue1[age][vehClass, fuelType] += value;
        }
        public void AppendValue(double value, VehicleClass vehClass, RegulatoryClass regClass, FuelType fuelType, int age)
        {
            this.Value1           [vehClass, fuelType] += value;
            this.Value2           [regClass, fuelType] += value;
            this.AnnualValue1[age][vehClass, fuelType] += value;
        }
        public void AppendValue(EffectsValue value)
        {
            this.AppendValues(value);
        }
        public void AppendValues(params EffectsValue[] values)
        {
            for (int i = 0; i < values.Length; i++)
            {
                this.Value1 += values[i].Value1;
                this.Value2 += values[i].Value2;
                for (int j = 0; j < this.AnnualValue1.Length; j++)
                {
                    this.AnnualValue1[j] += values[i].AnnualValue1[j];
                }
            }
        }
        public FuelValue GetValue(VehicleClass vehClass, RegulatoryClass regClass)
        {
            if (vehClass != VehicleClass   .None) { return this.Value1.GetValue(vehClass); }
            if (regClass != RegulatoryClass.None) { return this.Value2.GetValue(regClass); }
            return FuelValue.Zero;
        }
        public double GetValue(VehicleClass vehClass, RegulatoryClass regClass, FuelType fuelType)
        {
            return this.GetValue(vehClass, regClass)[fuelType];
        }
        public FuelValue GetAnnualValue(int age, VehicleClass vehClass, RegulatoryClass regClass)
        {
            if (vehClass != VehicleClass.None) { return this.AnnualValue1[age].GetValue(vehClass); }
            return FuelValue.Zero;
        }
        public double GetAnnualValue(int age, VehicleClass vehClass, RegulatoryClass regClass, FuelType fuelType)
        {
            return this.GetAnnualValue(age, vehClass, regClass)[fuelType];
        }
        #endregion
        #region 
        public VCFuelValue Value1 { get; private set; }
        public RCFuelValue Value2 { get; private set; }
        public VCFuelValue[] AnnualValue1 { get; private set; }
        #endregion
    }
}

