using System;
namespace Volpe.Cafe.Model
{
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Struct | AttributeTargets.Interface)]
    public class ModelDescriptionAttribute : Attribute
    {
        #region 
        public enum VersionType : int
        {
            None = 0,
            Alpha = 1,
            Beta = 2
        }
        #endregion
        #region 
        public ModelDescriptionAttribute() : this(null, null, 0.0F) {}
        public ModelDescriptionAttribute(string title, string description, float version) : this(title, description, version, VersionType.None) {}
        public ModelDescriptionAttribute(string title, string description, float version, VersionType verType)
        {
            this._title = title;
            this._description = description;
            this._version = version;
            this._verType = verType;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return this.FullTitle;
        }
        public string ToString(bool omitDescription)
        {
            return (this.FullTitle + ((omitDescription) ? " - " + this._description : ""));
        }
        public override bool IsDefaultAttribute()
        {
            return (this._verType == ModelDescriptionAttribute.VersionType.None && this._version == 0.0F &&
                (this._description == null || this._description == "") && (this._title == null || this._title == ""));
        }
        #endregion
        #region 
        public string Title { get { return this._title; } }
        public string FullTitle { get { return this._title + " (v." + this.VersionString + ")"; } }
        public string Description { get { return this._description; } }
        public string VersionString
        {
            get
            {
                return this._version.ToString("0.0#") +
                    ((this._verType == ModelDescriptionAttribute.VersionType.Alpha) ? "a" :
                    (this._verType == ModelDescriptionAttribute.VersionType.Beta) ? "b" : "");
            }
        }
        public float Version { get { return this._version; } }
        public ModelDescriptionAttribute.VersionType VerType { get { return this._verType; } }
        #endregion
        #region 
        string _title;
        string _description;
        float  _version;
        ModelDescriptionAttribute.VersionType _verType;
        #endregion
    }
}

