using System;
using Volpe.Cafe.IO;
using Volpe.Cafe.Utils;
using Volpe.XlLib;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public class OutputSettings : ISettings, ICloneable
    {
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        ISettings ISettings.Clone()
        {
            return this.Clone();
        }
        OutputSettings Clone()
        {
            OutputSettings value = new OutputSettings();
            Clone(this, value);
            return value;
        }
        static void Clone(OutputSettings src, OutputSettings dst)
        {
            dst.OutputPath            = src.OutputPath;
            dst.DisableLogWriter      = src.DisableLogWriter;
            dst.WriteLogFiles         = src.WriteLogFiles;
            dst.WriteExtendedLogFiles = src.WriteExtendedLogFiles;
            dst.GenerateCSVReports    = src.GenerateCSVReports;
            dst.GenerateXLReports     = src.GenerateXLReports;
        }
        #endregion
        #region 
        void ISettings.SetDefaultSettings()
        {
            this.OutputPath            = ApplicationInfo.DefaultOutputPath;
            this.DisableLogWriter      = false;
            this.WriteLogFiles         = true;
            this.WriteExtendedLogFiles = false;
            this.GenerateCSVReports    = true;
            this.GenerateXLReports     = true;
        }
        void ISettings.UpdateSettings(ISettings newSettings)
        {
            this.UpdateSettings((OutputSettings)newSettings);
        }
        public void UpdateSettings(OutputSettings newSettings)
        {
            Clone(newSettings, this);
        }
        void ISettings.WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Output Settings ---" +
                "\n  OutputPath="              + this.OutputPath            +
                "\n  DisableLogWriter="        + this.DisableLogWriter      +
                "\n  WriteLogFiles="           + this.WriteLogFiles         +
                "\n    WriteExtendedLogFiles=" + this.WriteExtendedLogFiles +
                "\n  GenerateCSVReports="      + this.GenerateCSVReports    +
                "\n  GenerateXLReports="       + this.GenerateXLReports;
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #endregion
        #region 
        public static readonly XlCryptoSettings DefaultWeakEncryption = XlCryptoSettings.OfficeXor;
        public static readonly XlCryptoSettings DefaultStrongEncryption = XlCryptoSettings.RC4_MsftRSASChannel;
        public string OutputPath;
        public bool DisableLogWriter;
        public bool WriteLogFiles;
        public bool WriteExtendedLogFiles;
        public bool GenerateCSVReports;
        public bool GenerateXLReports;
        #endregion
    }
}

