#region << Using Directives >>
using System;
#endregion
namespace Volpe.Cafe.Utils
{
    public static class SystemInfo
    {
        #region 
        static SystemInfo()
        {
            ProcessorCount = Environment.ProcessorCount;
            ProcessorArchitecture = Environment.GetEnvironmentVariable("PROCESSOR_ARCHITECTURE");
            ProcessorArchitecture_x86 = (ProcessorArchitecture == "x86" || ProcessorArchitecture == "X86");
            ProcessorArchitecture_x64 = (ProcessorArchitecture == "x64" || ProcessorArchitecture == "X64");
            MachineName = Environment.MachineName;
            OSVersion = Environment.OSVersion.ToString();
            CLRVersion = Environment.Version.ToString();
        }
        #endregion
        #region 
        public static readonly int ProcessorCount;
        public static readonly string ProcessorArchitecture;
        public static readonly bool ProcessorArchitecture_x86;
        public static readonly bool ProcessorArchitecture_x64;
        public static readonly string MachineName;
        public static readonly string OSVersion;
        public static readonly string CLRVersion;
        #endregion
    }
}

