using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.UI.Panels
{
	public class OutputPanel : CafeUserControl
	{
        #region 
        public OutputPanel()
        {
            this.InitializeComponent();
            this.PostInitialize();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_outputPathLabel = new System.Windows.Forms.Label();
            this.ux_outputPath = new System.Windows.Forms.TextBox();
            this.ux_outputPathBrowse = new System.Windows.Forms.Button();
            this.SuspendLayout();
            this.ux_outputPathLabel.AutoSize = true;
            this.ux_outputPathLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_outputPathLabel.Name = "ux_outputPathLabel";
            this.ux_outputPathLabel.Size = new System.Drawing.Size(305, 13);
            this.ux_outputPathLabel.TabIndex = 0;
            this.ux_outputPathLabel.Text = "Please specify where you would like to save the model outputs:";
            this.ux_outputPath.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_outputPath.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPath.Location = new System.Drawing.Point(11, 24);
            this.ux_outputPath.Name = "ux_outputPath";
            this.ux_outputPath.Size = new System.Drawing.Size(340, 20);
            this.ux_outputPath.TabIndex = 1;
            this.ux_outputPathBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_outputPathBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_outputPathBrowse.Location = new System.Drawing.Point(352, 24);
            this.ux_outputPathBrowse.Name = "ux_outputPathBrowse";
            this.ux_outputPathBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_outputPathBrowse.TabIndex = 2;
            this.ux_outputPathBrowse.Text = "Browse";
            this.Controls.Add(this.ux_outputPathBrowse);
            this.Controls.Add(this.ux_outputPath);
            this.Controls.Add(this.ux_outputPathLabel);
            this.MinimumSize = new System.Drawing.Size(440, 0);
            this.Name = "OutputPanel";
            this.Size = new System.Drawing.Size(440, 56);
            this.ResumeLayout(false);
            this.PerformLayout();
        }
        #endregion
        void PostInitialize()
        {
            this.InitializeTextBoxDragDrop(this.ux_outputPath);
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.ux_outputPath      .TextChanged    += new EventHandler(this.OutputPath_TextChanged);
            this.ux_outputPath      .EnabledChanged += new EventHandler(this.OutputPath_EnabledChanged);
            this.ux_outputPathBrowse.Click          += new EventHandler(this.OutputPathBrowse_Click);
            this.ux_outputPath.Text = "";
        }
        void OutputPath_TextChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (Directory.Exists(tb.Text))
            {
                bool outputPathChanged = !this.CompareDirectories(this._outputSettings.OutputPath, tb.Text);
                tb.ForeColor = (this._visualTracking && outputPathChanged) ? this._visualTrackingColor : Control.DefaultForeColor;
                tb.BackColor = Color.Empty;
                this._messages.RemoveMessage(tb);
            }
            else
            {
                if (tb.Text.Trim() == string.Empty)
                {
                    this._messages.AddMessage("Please select a location where you would like to save the model outputs.", null, Color.Red, tb);
                }
                else
                {
                    this._messages.AddMessage("The specified location for model outputs does not exist on disk.", null, Color.Red, tb);
                }
                tb.BackColor = Color.Honeydew;
                tb.ForeColor = Color.Red;
            }
        }
        void OutputPath_EnabledChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Enabled) { this.OutputPath_TextChanged(sender, e); }
            else            { this._messages.RemoveMessage(sender); tb.BackColor = Color.Empty; }
        }
        void OutputPathBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dlg = new FolderBrowserDialog();
            dlg.Description         = "Please select a location where you would like to save the model outputs:";
            dlg.SelectedPath        = this.ux_outputPath.Text;
            dlg.ShowNewFolderButton = true;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.ux_outputPath.Text = dlg.SelectedPath;
            }
        }
        bool CompareDirectories(string path1, string path2)
        {
            if (Directory.Exists(path1)) { path1 = Path.GetFullPath(path1.TrimEnd('\\')); }
            if (Directory.Exists(path2)) { path2 = Path.GetFullPath(path2.TrimEnd('\\')); }
            return (path1 == path2);
        }
        void InitializeTextBoxDragDrop(params TextBox[] values)
        {
            for (int i = 0; i < values.Length; i++)
            {
                values[i].AllowDrop = true;
                values[i].DragEnter += new DragEventHandler(this.OutputPanel_DragEnter);
                values[i].DragDrop  += new DragEventHandler(this.OutputPanel_DragDrop);
            }
        }
        void OutputPanel_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        void OutputPanel_DragDrop(object sender, DragEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            for (int i = 0; i < files.Length; i++)
            {
                if (Directory.Exists(files[i])) { tb.Text = files[i]; break; }
            }
        }
        public void SetInitialState(OutputSettings outputSettings)
        {
            this._outputSettings = outputSettings;
            this.ux_outputPath.Text = this._outputSettings.OutputPath;
            base.SaveChanges();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._outputSettings.OutputPath = this.ux_outputPath.Text;
                base.SaveChanges();
                this.PostSave();
            }
        }
        void PostSave()
        {
            if (this._visualTracking)
            {   
                this.ux_outputPath.ForeColor = Control.DefaultForeColor;
                this.ux_outputPath.BackColor = Color  .Empty;
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                if (!Directory.Exists(this.ux_outputPath.Text)) { return false; }
                return base.SettingsChanged ||
                    !this.CompareDirectories(this._outputSettings.OutputPath, this.ux_outputPath.Text);
            }
        }
        #endregion
        #region 
        #region 
        Label       ux_outputPathLabel;
        TextBox     ux_outputPath;
        Button      ux_outputPathBrowse;
        #endregion
        OutputSettings _outputSettings;
        #endregion
    }
}

