using System;
using Volpe.Cafe.Data;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Generic;
namespace Volpe.Cafe.Model
{
    [Serializable]
    public class ModelingProgress : IModelingProgress
    {
        #region 
        public ModelingProgress(Scenario scen, ModelYear year, Manufacturer mfr) : this(scen, year, mfr, null) { }
        public ModelingProgress(Scenario scen, ModelYear year, Manufacturer mfr, object additionalInfo) : this(null, scen, year, mfr, additionalInfo) { }
        public ModelingProgress(string progressString) : this(progressString, null) { }
        public ModelingProgress(string progressString, object additionalInfo) : this(progressString, null, null, null, additionalInfo) { }
        protected ModelingProgress(string progressString, Scenario scen, ModelYear year, Manufacturer mfr, object additionalInfo)
        {
            this._progressString = progressString;
            this._scen           = scen;
            this._year           = year;
            this._mfr            = mfr;
            this._additionalInfo = additionalInfo;
        }
        #endregion
        #region 
        public override string ToString()
        {
            if (this._progressString != null)
            {
                return this._progressString;
            }
            else if (this._scen == null)
            {
                return "No progress information available.";
            }
            else
            {   
                string mfrProgress = null;
                if (this._mfr != null)
                {
                    Manufacturer.CModelData mmd = this._mfr.ModelData;
                    mfrProgress = "\n    Standard: "   + mmd.Standard.ToString(4) +
                                  "\n    CAFE: "       + mmd.CAFE    .ToString(4) +
                                  "\n    Credits: "    + mmd.Credits .ToString(0) +
                                  "\n    Fines: "      + mmd.Fines   .ToString(0) +
                                  "\n    Tech Costs: " + mmd.TechCost.ToString(0);
                }
                return
                    "Scenario: "       + ((this._scen == null) ? "N/A" : this._scen.ToString()) +
                    "\nModel Year: "   + ((this._year == null) ? "N/A" : this._year.ToString()) +
                    "\nManufacturer: " + ((this._mfr  == null) ? "N/A" : this._mfr .Description.Name) + ((mfrProgress == null) ? "" : mfrProgress);
            }
        }
        #endregion
        #region 
        #region 
        public virtual string ProgressString { get { return this._progressString; } }
        public virtual Scenario Scenario { get { return this._scen; } }
        public virtual ModelYear ModelYear { get { return this._year; } }
        public virtual Manufacturer Manufacturer { get { return this._mfr; } }
        public virtual object AdditionalInfo { get { return this._additionalInfo; } set { this._additionalInfo = value; } }
        #endregion
        #endregion
        #region 
        protected string _progressString;
        protected Scenario _scen;
        protected ModelYear _year;
        protected Manufacturer _mfr;
        protected object _additionalInfo;
        #endregion
    }
}

