using System;

namespace Volpe.Cafe.IO
{
    /// <summary>
    /// Represents the type of the template workbook to use when generating reports.
    /// </summary>
    [Serializable]
    public enum TemplateType
    {
        /// <summary>Specifies that no template workbook should be used.</summary>
        None = 0,
        /// <summary>Specifies that a template workbook for Industry reporting should be used.</summary>
        IndustryReport = 3,
        /// <summary>Specifies that a template workbook for Manufacturers reporting should be used.</summary>
        ManufacturersReport = 4,
        /// <summary>Specifies that a template workbook for Vehicles reporting should be used.</summary>
        VehiclesReport = 5,
        /// <summary>Specifies that a template workbook for Environmental Assessment reporting should be used.</summary>
        EAReport = 6,
        /// <summary>Specifies that a template workbook for Scenario Summary reporting should be used.</summary>
        ScenarioSummaryReport = 7,

        /// <summary>Specifies that a template workbook for the EIS CAFE report should be used.</summary>
        EIS_CAFE = 8,
        /// <summary>Specifies that a template workbook for the EIS Gallons report should be used.</summary>
        EIS_Gallons = 9,
        /// <summary>Specifies that a template workbook for the EIS VMT report should be used.</summary>
        EIS_VMT = 10,
        /// <summary>Specifies that a template workbook for the EIS Emissions reports should be used.</summary>
        EIS_Emissions = 11
    }

}
