using System;

namespace Volpe.Cafe.IO
{
    /// <summary>
    /// The exception that is thrown when an error occurs while loading or parsing an input file.
    /// </summary>
    [Serializable]
    public sealed class InputException : IOException
    {

        #region /*** Constructors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="InputException"/> class, using the specified file name that was being
        /// processed when the exception occured.
        /// </summary>
        /// <param name="fileName">The name of the file that was being processed when the exception occured.</param>
        public InputException(string fileName) : this(fileName, string.Empty) { }
        /// <summary>
        /// Initializes a new instance of the <see cref="InputException"/> class, using the specified file name that was being
        /// processed when the exception occured, and the message describing the reason and/or nature of the exception.
        /// </summary>
        /// <param name="fileName">The name of the file that was being processed when the exception occured.</param>
        /// <param name="message">The error message that explains the reason and/or nature of the exception.</param>
        public InputException(string fileName, string message) : this(fileName, message, null) { }
        /// <summary>
        /// Initializes a new instance of the <see cref="InputException"/> class, using the specified file name that was being
        /// processed when the exception occured, the message describing the reason and/or nature of the exception, as well as a
        /// reference to the inner exception that is the cause of this exception.
        /// </summary>
        /// <param name="fileName">The name of the file that was being processed when the exception occured.</param>
        /// <param name="message">The error message that explains the reason and/or nature of the exception.</param>
        /// <param name="innerException">The exception that is the cause of the current exception.</param>
        public InputException(string fileName, string message, Exception innerException) : base(fileName, message, innerException, 1) { }

        #endregion

    }
}
