using System;

namespace Volpe.Cafe.Model
{
    /// <summary>
    /// Represents the method that will handle the <see cref="ICompliance.ModelingStarted"/>,
    /// <see cref="ICompliance.ModelingCompleted"/>, <see cref="ICompliance.ModelingStopped"/>, and
    /// <see cref="ICompliance.ModelingChanged"/> events of the <see cref="ICompliance"/> interface.
    /// </summary>
    /// <param name="sender">The object responsible for generating the event.</param>
    /// <param name="e">Event data to pass to the event.</param>
    [Serializable]
    public delegate void ModelingEventHandler(object sender, ModelingEventArgs e);

    /// <summary>
    /// Represents the method that will handle the <see cref="ICompliance.ScenarioStarted"/>,
    /// <see cref="ICompliance.ScenarioCompleted"/>, <see cref="ICompliance.ModelYearStarted"/>,
    /// <see cref="ICompliance.ModelYearCompleted"/>, <see cref="ICompliance.ManufacturerStarted"/>, and
    /// <see cref="ICompliance.ManufacturerCompleted"/> events of the <see cref="ICompliance"/> interface.
    /// </summary>
    /// <param name="sender">The object responsible for generating the event.</param>
    /// <param name="e">Event data to pass to the event.</param>
    [Serializable]
    public delegate void ModelingProgressEventHandler(object sender, ModelingProgressEventArgs e);

}
