#region << Using Directives >>
using System;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Drawing;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Threading;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Utils;
using Volpe.Cafe.UI.Properties;
#endregion

namespace Volpe.Cafe.UI
{
    /// <summary>
    /// Provides the main graphical user interface for the CAFE Model.
    /// </summary>
    public class Cafe2d : Form
    {

        #region /*** Constructors ***/

        static Cafe2d()
        {
            Cafe2d._cmpTypes = new ArrayList();
            Cafe2d._cmpTypes.Add(typeof(Compliance));
        }

        /// <summary>
        /// Initialzies a new instance of the Cafe2d class.
        /// </summary>
        public Cafe2d()
        {
            // set up the user interface
            this.InitializeComponent();
            this.Size = new Size(640, 480); // force form size (vs2008 compiler has anyoing resize bug)
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #endregion


        #region /*** Methods ***/

        #region /* Windows Form Designer generated code */

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Cafe2d));
            this.ux_mainMenu = new System.Windows.Forms.MainMenu(this.components);
            this.ux_fileMenu = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_NewSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_OpenSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CloseSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CloseAll = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveSessionAs = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveAll = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator1 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_StartModeling = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_StopModeling = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator3 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Exit = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_ModelingSettings = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_InputFileLocation = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_OutputLocation = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Separator1 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Realtime = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_High = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Normal = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Low = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Paused = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Refresh = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_SoftwareManual = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_ProgrammersReference = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_ShowNotice = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_ShowWarnings = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_Separator1 = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_About = new System.Windows.Forms.MenuItem();
            this.ux_statusBar = new System.Windows.Forms.StatusBar();
            this.ux_statusPanel = new System.Windows.Forms.StatusBarPanel();
            this.ux_versionPanel = new System.Windows.Forms.StatusBarPanel();
            this.ux_toolbar = new System.Windows.Forms.Panel();
            this.ux_toolbar_StopModeling = new Volpe.Cafe.UI.ToolbarButton();
            this.ux_toolbar_StartModeling = new Volpe.Cafe.UI.ToolbarButton();
            this.ux_toolbar_ModelingSettings = new Volpe.Cafe.UI.ToolbarButton();
            this.ux_toolbar_SaveSession = new Volpe.Cafe.UI.ToolbarButton();
            this.ux_toolbar_OpenSession = new Volpe.Cafe.UI.ToolbarButton();
            this.ux_toolbar_NewSession = new Volpe.Cafe.UI.ToolbarButton();
            this.ux_welcomeLabel = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.ux_statusPanel)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.ux_versionPanel)).BeginInit();
            this.ux_toolbar.SuspendLayout();
            this.SuspendLayout();
            // 
            // ux_mainMenu
            // 
            this.ux_mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.ux_fileMenu,
            this.ux_viewMenu,
            this.ux_helpMenu});
            // 
            // ux_fileMenu
            // 
            this.ux_fileMenu.Index = 0;
            this.ux_fileMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.ux_fileMenu_NewSession,
            this.ux_fileMenu_OpenSession,
            this.ux_fileMenu_CloseSession,
            this.ux_fileMenu_CloseAll,
            this.ux_fileMenu_Separator0,
            this.ux_fileMenu_SaveSession,
            this.ux_fileMenu_SaveSessionAs,
            this.ux_fileMenu_SaveAll,
            this.ux_fileMenu_Separator1,
            this.ux_fileMenu_StartModeling,
            this.ux_fileMenu_StopModeling,
            this.ux_fileMenu_Separator3,
            this.ux_fileMenu_Exit});
            this.ux_fileMenu.Text = "&File";
            // 
            // ux_fileMenu_NewSession
            // 
            this.ux_fileMenu_NewSession.Index = 0;
            this.ux_fileMenu_NewSession.Shortcut = System.Windows.Forms.Shortcut.CtrlN;
            this.ux_fileMenu_NewSession.Text = "&New Session";
            this.ux_fileMenu_NewSession.Click += new System.EventHandler(this.FileMenu_NewSession_Click);
            // 
            // ux_fileMenu_OpenSession
            // 
            this.ux_fileMenu_OpenSession.Index = 1;
            this.ux_fileMenu_OpenSession.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
            this.ux_fileMenu_OpenSession.Text = "&Open Session";
            this.ux_fileMenu_OpenSession.Click += new System.EventHandler(this.FileMenu_OpenSession_Click);
            // 
            // ux_fileMenu_CloseSession
            // 
            this.ux_fileMenu_CloseSession.Index = 2;
            this.ux_fileMenu_CloseSession.Shortcut = System.Windows.Forms.Shortcut.CtrlF4;
            this.ux_fileMenu_CloseSession.Text = "&Close Session";
            this.ux_fileMenu_CloseSession.Click += new System.EventHandler(this.FileMenu_CloseSession_Click);
            // 
            // ux_fileMenu_CloseAll
            // 
            this.ux_fileMenu_CloseAll.Index = 3;
            this.ux_fileMenu_CloseAll.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftF4;
            this.ux_fileMenu_CloseAll.Text = "Clos&e All";
            this.ux_fileMenu_CloseAll.Click += new System.EventHandler(this.FileMenu_CloseAll_Click);
            // 
            // ux_fileMenu_Separator0
            // 
            this.ux_fileMenu_Separator0.Index = 4;
            this.ux_fileMenu_Separator0.Text = "-";
            // 
            // ux_fileMenu_SaveSession
            // 
            this.ux_fileMenu_SaveSession.Index = 5;
            this.ux_fileMenu_SaveSession.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
            this.ux_fileMenu_SaveSession.Text = "&Save Session";
            this.ux_fileMenu_SaveSession.Click += new System.EventHandler(this.FileMenu_SaveSession_Click);
            // 
            // ux_fileMenu_SaveSessionAs
            // 
            this.ux_fileMenu_SaveSessionAs.Index = 6;
            this.ux_fileMenu_SaveSessionAs.Text = "Save Session &As...";
            this.ux_fileMenu_SaveSessionAs.Click += new System.EventHandler(this.FileMenu_SaveSessionAs_Click);
            // 
            // ux_fileMenu_SaveAll
            // 
            this.ux_fileMenu_SaveAll.Index = 7;
            this.ux_fileMenu_SaveAll.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftS;
            this.ux_fileMenu_SaveAll.Text = "Save A&ll";
            this.ux_fileMenu_SaveAll.Click += new System.EventHandler(this.FileMenu_SaveAll_Click);
            // 
            // ux_fileMenu_Separator1
            // 
            this.ux_fileMenu_Separator1.Index = 8;
            this.ux_fileMenu_Separator1.Text = "-";
            // 
            // ux_fileMenu_StartModeling
            // 
            this.ux_fileMenu_StartModeling.Index = 9;
            this.ux_fileMenu_StartModeling.Shortcut = System.Windows.Forms.Shortcut.CtrlM;
            this.ux_fileMenu_StartModeling.Text = "Start &Modeling";
            this.ux_fileMenu_StartModeling.Click += new System.EventHandler(this.FileMenu_StartModeling_Click);
            // 
            // ux_fileMenu_StopModeling
            // 
            this.ux_fileMenu_StopModeling.Index = 10;
            this.ux_fileMenu_StopModeling.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftM;
            this.ux_fileMenu_StopModeling.Text = "Stop Modeling";
            this.ux_fileMenu_StopModeling.Click += new System.EventHandler(this.FileMenu_StopModeling_Click);
            // 
            // ux_fileMenu_Separator3
            // 
            this.ux_fileMenu_Separator3.Index = 11;
            this.ux_fileMenu_Separator3.Text = "-";
            // 
            // ux_fileMenu_Exit
            // 
            this.ux_fileMenu_Exit.Index = 12;
            this.ux_fileMenu_Exit.Shortcut = System.Windows.Forms.Shortcut.AltF4;
            this.ux_fileMenu_Exit.Text = "E&xit";
            this.ux_fileMenu_Exit.Click += new System.EventHandler(this.FileMenu_Exit_Click);
            // 
            // ux_viewMenu
            // 
            this.ux_viewMenu.Index = 1;
            this.ux_viewMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.ux_viewMenu_ModelingSettings,
            this.ux_viewMenu_Separator0,
            this.ux_viewMenu_InputFileLocation,
            this.ux_viewMenu_OutputLocation,
            this.ux_viewMenu_Separator1,
            this.ux_viewMenu_UpdateSpeed,
            this.ux_viewMenu_Refresh});
            this.ux_viewMenu.Text = "&View";
            // 
            // ux_viewMenu_ModelingSettings
            // 
            this.ux_viewMenu_ModelingSettings.Index = 0;
            this.ux_viewMenu_ModelingSettings.Shortcut = System.Windows.Forms.Shortcut.CtrlT;
            this.ux_viewMenu_ModelingSettings.Text = "Modeling Se&ttings";
            this.ux_viewMenu_ModelingSettings.Click += new System.EventHandler(this.ViewMenu_ModelingSettings_Click);
            // 
            // ux_viewMenu_Separator0
            // 
            this.ux_viewMenu_Separator0.Index = 1;
            this.ux_viewMenu_Separator0.Text = "-";
            // 
            // ux_viewMenu_InputFileLocation
            // 
            this.ux_viewMenu_InputFileLocation.Index = 2;
            this.ux_viewMenu_InputFileLocation.Text = "&Input File Location(s)";
            this.ux_viewMenu_InputFileLocation.Click += new System.EventHandler(this.ViewMenu_InputFileLocation_Click);
            // 
            // ux_viewMenu_OutputLocation
            // 
            this.ux_viewMenu_OutputLocation.Index = 3;
            this.ux_viewMenu_OutputLocation.Text = "&Output Location";
            this.ux_viewMenu_OutputLocation.Click += new System.EventHandler(this.ViewMenu_OutputLocation_Click);
            // 
            // ux_viewMenu_Separator1
            // 
            this.ux_viewMenu_Separator1.Index = 4;
            this.ux_viewMenu_Separator1.Text = "-";
            // 
            // ux_viewMenu_UpdateSpeed
            // 
            this.ux_viewMenu_UpdateSpeed.Index = 5;
            this.ux_viewMenu_UpdateSpeed.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.ux_viewMenu_UpdateSpeed_Realtime,
            this.ux_viewMenu_UpdateSpeed_High,
            this.ux_viewMenu_UpdateSpeed_Normal,
            this.ux_viewMenu_UpdateSpeed_Low,
            this.ux_viewMenu_UpdateSpeed_Separator0,
            this.ux_viewMenu_UpdateSpeed_Paused});
            this.ux_viewMenu_UpdateSpeed.Text = "&Update Speed";
            // 
            // ux_viewMenu_UpdateSpeed_Realtime
            // 
            this.ux_viewMenu_UpdateSpeed_Realtime.Index = 0;
            this.ux_viewMenu_UpdateSpeed_Realtime.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Realtime.Text = "&Realtime";
            this.ux_viewMenu_UpdateSpeed_Realtime.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Realtime_Click);
            // 
            // ux_viewMenu_UpdateSpeed_High
            // 
            this.ux_viewMenu_UpdateSpeed_High.Index = 1;
            this.ux_viewMenu_UpdateSpeed_High.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_High.Text = "&High";
            this.ux_viewMenu_UpdateSpeed_High.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_High_Click);
            // 
            // ux_viewMenu_UpdateSpeed_Normal
            // 
            this.ux_viewMenu_UpdateSpeed_Normal.Index = 2;
            this.ux_viewMenu_UpdateSpeed_Normal.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Normal.Text = "&Normal";
            this.ux_viewMenu_UpdateSpeed_Normal.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Normal_Click);
            // 
            // ux_viewMenu_UpdateSpeed_Low
            // 
            this.ux_viewMenu_UpdateSpeed_Low.Index = 3;
            this.ux_viewMenu_UpdateSpeed_Low.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Low.Text = "&Low";
            this.ux_viewMenu_UpdateSpeed_Low.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Low_Click);
            // 
            // ux_viewMenu_UpdateSpeed_Separator0
            // 
            this.ux_viewMenu_UpdateSpeed_Separator0.Index = 4;
            this.ux_viewMenu_UpdateSpeed_Separator0.Text = "-";
            // 
            // ux_viewMenu_UpdateSpeed_Paused
            // 
            this.ux_viewMenu_UpdateSpeed_Paused.Index = 5;
            this.ux_viewMenu_UpdateSpeed_Paused.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Paused.Text = "&Paused";
            this.ux_viewMenu_UpdateSpeed_Paused.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Paused_Click);
            // 
            // ux_viewMenu_Refresh
            // 
            this.ux_viewMenu_Refresh.Index = 6;
            this.ux_viewMenu_Refresh.Shortcut = System.Windows.Forms.Shortcut.F5;
            this.ux_viewMenu_Refresh.Text = "&Refresh";
            this.ux_viewMenu_Refresh.Click += new System.EventHandler(this.ViewMenu_Refresh_Click);
            // 
            // ux_helpMenu
            // 
            this.ux_helpMenu.Index = 2;
            this.ux_helpMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.ux_helpMenu_SoftwareManual,
            this.ux_helpMenu_ProgrammersReference,
            this.ux_helpMenu_Separator0,
            this.ux_helpMenu_ShowNotice,
            this.ux_helpMenu_ShowWarnings,
            this.ux_helpMenu_Separator1,
            this.ux_helpMenu_About});
            this.ux_helpMenu.Text = "&Help";
            // 
            // ux_helpMenu_SoftwareManual
            // 
            this.ux_helpMenu_SoftwareManual.Index = 0;
            this.ux_helpMenu_SoftwareManual.Shortcut = System.Windows.Forms.Shortcut.F1;
            this.ux_helpMenu_SoftwareManual.Text = "&CAFE Model Software Manual";
            this.ux_helpMenu_SoftwareManual.Click += new System.EventHandler(this.HelpMenu_SoftwareManual_Click);
            // 
            // ux_helpMenu_ProgrammersReference
            // 
            this.ux_helpMenu_ProgrammersReference.Index = 1;
            this.ux_helpMenu_ProgrammersReference.Shortcut = System.Windows.Forms.Shortcut.F2;
            this.ux_helpMenu_ProgrammersReference.Text = "&CAFE Model Programmer\'s Reference";
            this.ux_helpMenu_ProgrammersReference.Click += new System.EventHandler(this.HelpMenu_ProgrammersReference_Click);
            // 
            // ux_helpMenu_Separator0
            // 
            this.ux_helpMenu_Separator0.Index = 2;
            this.ux_helpMenu_Separator0.Text = "-";
            // 
            // ux_helpMenu_ShowNotice
            // 
            this.ux_helpMenu_ShowNotice.Index = 3;
            this.ux_helpMenu_ShowNotice.Text = "Show &Notice Screen";
            this.ux_helpMenu_ShowNotice.Click += new System.EventHandler(this.HelpMenu_ShowNotice_Click);
            // 
            // ux_helpMenu_ShowWarnings
            // 
            this.ux_helpMenu_ShowWarnings.Index = 4;
            this.ux_helpMenu_ShowWarnings.Text = "Show &Warnings Screen";
            this.ux_helpMenu_ShowWarnings.Click += new System.EventHandler(this.HelpMenu_ShowWarnings_Click);
            // 
            // ux_helpMenu_Separator1
            // 
            this.ux_helpMenu_Separator1.Index = 5;
            this.ux_helpMenu_Separator1.Text = "-";
            // 
            // ux_helpMenu_About
            // 
            this.ux_helpMenu_About.Index = 6;
            this.ux_helpMenu_About.Shortcut = System.Windows.Forms.Shortcut.F12;
            this.ux_helpMenu_About.Text = "&About CAFE Model";
            this.ux_helpMenu_About.Click += new System.EventHandler(this.HelpMenu_About_Click);
            // 
            // ux_statusBar
            // 
            this.ux_statusBar.Location = new System.Drawing.Point(0, 399);
            this.ux_statusBar.Name = "ux_statusBar";
            this.ux_statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
            this.ux_statusPanel,
            this.ux_versionPanel});
            this.ux_statusBar.ShowPanels = true;
            this.ux_statusBar.Size = new System.Drawing.Size(624, 22);
            this.ux_statusBar.TabIndex = 1;
            // 
            // ux_statusPanel
            // 
            this.ux_statusPanel.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
            this.ux_statusPanel.Name = "ux_statusPanel";
            this.ux_statusPanel.Text = "Ready";
            this.ux_statusPanel.Width = 597;
            // 
            // ux_versionPanel
            // 
            this.ux_versionPanel.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
            this.ux_versionPanel.Name = "ux_versionPanel";
            this.ux_versionPanel.Width = 10;
            // 
            // ux_toolbar
            // 
            this.ux_toolbar.Controls.Add(this.ux_toolbar_StopModeling);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_StartModeling);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_ModelingSettings);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_SaveSession);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_OpenSession);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_NewSession);
            this.ux_toolbar.Dock = System.Windows.Forms.DockStyle.Top;
            this.ux_toolbar.Location = new System.Drawing.Point(0, 0);
            this.ux_toolbar.Name = "ux_toolbar";
            this.ux_toolbar.Size = new System.Drawing.Size(624, 32);
            this.ux_toolbar.TabIndex = 3;
            // 
            // ux_toolbar_StopModeling
            // 
            this.ux_toolbar_StopModeling.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StopModeling.BigImage")));
            this.ux_toolbar_StopModeling.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StopModeling.Image")));
            this.ux_toolbar_StopModeling.Location = new System.Drawing.Point(124, 4);
            this.ux_toolbar_StopModeling.Name = "ux_toolbar_StopModeling";
            this.ux_toolbar_StopModeling.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_StopModeling.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StopModeling.SmallImage")));
            this.ux_toolbar_StopModeling.TabIndex = 6;
            this.ux_toolbar_StopModeling.Click += new System.EventHandler(this.Toolbar_StopModeling_Click);
            // 
            // ux_toolbar_StartModeling
            // 
            this.ux_toolbar_StartModeling.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StartModeling.BigImage")));
            this.ux_toolbar_StartModeling.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StartModeling.Image")));
            this.ux_toolbar_StartModeling.Location = new System.Drawing.Point(100, 4);
            this.ux_toolbar_StartModeling.Name = "ux_toolbar_StartModeling";
            this.ux_toolbar_StartModeling.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_StartModeling.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StartModeling.SmallImage")));
            this.ux_toolbar_StartModeling.TabIndex = 5;
            this.ux_toolbar_StartModeling.Click += new System.EventHandler(this.Toolbar_StartModeling_Click);
            // 
            // ux_toolbar_ModelingSettings
            // 
            this.ux_toolbar_ModelingSettings.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_ModelingSettings.BigImage")));
            this.ux_toolbar_ModelingSettings.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_ModelingSettings.Image")));
            this.ux_toolbar_ModelingSettings.Location = new System.Drawing.Point(76, 4);
            this.ux_toolbar_ModelingSettings.Name = "ux_toolbar_ModelingSettings";
            this.ux_toolbar_ModelingSettings.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_ModelingSettings.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_ModelingSettings.SmallImage")));
            this.ux_toolbar_ModelingSettings.TabIndex = 4;
            this.ux_toolbar_ModelingSettings.Click += new System.EventHandler(this.Toolbar_ModelingSettings_Click);
            // 
            // ux_toolbar_SaveSession
            // 
            this.ux_toolbar_SaveSession.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_SaveSession.BigImage")));
            this.ux_toolbar_SaveSession.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_SaveSession.Image")));
            this.ux_toolbar_SaveSession.Location = new System.Drawing.Point(52, 4);
            this.ux_toolbar_SaveSession.Name = "ux_toolbar_SaveSession";
            this.ux_toolbar_SaveSession.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_SaveSession.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_SaveSession.SmallImage")));
            this.ux_toolbar_SaveSession.TabIndex = 2;
            this.ux_toolbar_SaveSession.Click += new System.EventHandler(this.Toolbar_SaveSession_Click);
            // 
            // ux_toolbar_OpenSession
            // 
            this.ux_toolbar_OpenSession.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_OpenSession.BigImage")));
            this.ux_toolbar_OpenSession.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_OpenSession.Image")));
            this.ux_toolbar_OpenSession.Location = new System.Drawing.Point(28, 4);
            this.ux_toolbar_OpenSession.Name = "ux_toolbar_OpenSession";
            this.ux_toolbar_OpenSession.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_OpenSession.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_OpenSession.SmallImage")));
            this.ux_toolbar_OpenSession.TabIndex = 1;
            this.ux_toolbar_OpenSession.Click += new System.EventHandler(this.Toolbar_OpenSession_Click);
            // 
            // ux_toolbar_NewSession
            // 
            this.ux_toolbar_NewSession.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_NewSession.BigImage")));
            this.ux_toolbar_NewSession.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_NewSession.Image")));
            this.ux_toolbar_NewSession.Location = new System.Drawing.Point(4, 4);
            this.ux_toolbar_NewSession.Name = "ux_toolbar_NewSession";
            this.ux_toolbar_NewSession.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_NewSession.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_NewSession.SmallImage")));
            this.ux_toolbar_NewSession.TabIndex = 0;
            this.ux_toolbar_NewSession.Click += new System.EventHandler(this.Toolbar_NewSession_Click);
            // 
            // ux_welcomeLabel
            // 
            this.ux_welcomeLabel.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.ux_welcomeLabel.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_welcomeLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.ux_welcomeLabel.Location = new System.Drawing.Point(0, 32);
            this.ux_welcomeLabel.Name = "ux_welcomeLabel";
            this.ux_welcomeLabel.Padding = new System.Windows.Forms.Padding(64);
            this.ux_welcomeLabel.Size = new System.Drawing.Size(624, 367);
            this.ux_welcomeLabel.TabIndex = 0;
            this.ux_welcomeLabel.Text = "To begin using the model, please create a New Session, or Open an existing one.";
            this.ux_welcomeLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // Cafe2d
            // 
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.None;
            this.ClientSize = new System.Drawing.Size(624, 421);
            this.Controls.Add(this.ux_welcomeLabel);
            this.Controls.Add(this.ux_toolbar);
            this.Controls.Add(this.ux_statusBar);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.IsMdiContainer = true;
            this.Menu = this.ux_mainMenu;
            this.Name = "Cafe2d";
            this.Text = "CAFE Model";
            this.Load += new System.EventHandler(this.Cafe2d_Load);
            ((System.ComponentModel.ISupportInitialize)(this.ux_statusPanel)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.ux_versionPanel)).EndInit();
            this.ux_toolbar.ResumeLayout(false);
            this.ResumeLayout(false);

        }

        #endregion

        #region /* << Overriden WndProc and various Windows Message handlers >> */

        /// <summary>
        /// Processes Windows messages.
        /// </summary>
        /// <param name="m">The <see cref="Message"/> to process.</param>
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == (int)Win32.Messages.WM_CLOSE)
            {
                this.WndProc_WM_CLOSE(ref m);
            }
            else { base.WndProc(ref m); }
        }

        private void WndProc_WM_CLOSE(ref Message m)
        {
            this.FileMenu_CloseAll_Click(this, EventArgs.Empty);
            if (this.MdiChildren.Length == 0) { base.WndProc(ref m); }
            //this.WindowState = FormWindowState.Minimized;
        }

        #endregion

        #region /* Main form event handlers */

        private void Cafe2d_Load(object sender, System.EventArgs e)
        {
            this.KeyDown += new KeyEventHandler(this.Cafe2d_KeyDown);
            this.MdiChildActivate += new EventHandler(this.Cafe2d_MdiChildActivate);

            // add after select and after click event handlers for each main-menu and standard toolbar item
            this.AddMenuItemEventHandlers(this.ux_mainMenu.MenuItems);
            this.AddToolbarEventHandlers(this.ux_toolbar);

            // add support for dragging and dropping if settings allow
            this.EnableDragDrop();

            // refresh ui
            this.RefreshSession();

            // add version and timestampe
            string exePath = Application.ExecutablePath;
            FileInfo fi = new FileInfo(exePath);
            this.ux_versionPanel.Text = fi.LastWriteTime.ToString("M/dd/yy H:mm:ss");

            this.Show();
            Application.DoEvents();
        }

        private void Cafe2d_KeyDown(object sender, KeyEventArgs e)
        {
//            if (e.Control && e.KeyCode == Keys.F10)
//            {
//                this.ToolsMenu_Customize_Click(sender, e);
//            }
        }

        private void Cafe2d_MdiChildActivate(object sender, EventArgs e)
        {
            // set an active session
            this._activeSession = (Session)this.ActiveMdiChild;
            // update the status
            this.SetStatus((this._activeSession == null) ? "Ready" : this._activeSession.Status);
            // update the "update-speed" menu item
            if (this._activeSession != null)
            {
                int refInt = this._activeSession.RefreshInterval;
                this.ViewMenu_UpdateSpeed_SetChecked(
                    refInt == Cafe2d.RefreshIntervalRealtime,
                    refInt == Cafe2d.RefreshIntervalHigh,
                    refInt == Cafe2d.RefreshIntervalNormal,
                    refInt == Cafe2d.RefreshIntervalLow,
                    refInt == Cafe2d.RefreshIntervalPaused);
            }
            // refresh session
            this.RefreshSession();
        }

        private void Control_AfterSelect(object sender, EventArgs e)
        {
            int sessionCount = this.Sessions.Length;
            string message =
                //
                // ====================
                // file menu
                //
                (sender == this.ux_fileMenu_NewSession ||
                 sender == this.ux_toolbar_NewSession)       ? "Creates a new CAFE Model Session and displays the Modeling Settings window to the user." :
                (sender == this.ux_fileMenu_OpenSession ||
                 sender == this.ux_toolbar_OpenSession)      ? "Opens an existing CAFE Model Session." :
                (sender == this.ux_fileMenu_CloseSession)    ? "Closes the active CAFE Model Session." :
                (sender == this.ux_fileMenu_CloseAll)        ? "Closes all opened CAFE Model Session." :
                // ----------
                (sender == this.ux_fileMenu_SaveSession ||
                 sender == this.ux_toolbar_SaveSession)      ? "Saves the active CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveSessionAs)   ? "Displays the Save As dialog for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveAll)         ? "Saves all opened CAFE Model Session." :
                // ----------
                (sender == this.ux_fileMenu_StartModeling ||
                 sender == this.ux_toolbar_StartModeling)    ? "Begins the modeling process for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_StopModeling ||
                 sender == this.ux_toolbar_StopModeling)     ? "Suspends the modeling process of the active CAFE Model Session." :
                // ----------
                (sender == this.ux_fileMenu_Exit)            ? (sessionCount == 0) ? "Exits the CAFE Model." : "Closes " +
                                                              ((sessionCount == 1) ? "the active CAFE Model Session" :
                                                                                     "all opened CAFE Model Sessions") + " and exits the model." :
                //
                // ====================
                // view menu
                //
                (sender == this.ux_viewMenu_ModelingSettings ||
                 sender == this.ux_toolbar_ModelingSettings)      ? "Displays the Modeling Settings window, where all modeling options and settings can be configured." :
                // ----------
                (sender == this.ux_viewMenu_InputFileLocation)    ? "Browses the location of the input data files used to make this Session." :
                (sender == this.ux_viewMenu_OutputLocation)       ? "Browses the location where the output files and reports of the Session are written to." :
                // ----------
                (sender == this.ux_viewMenu_UpdateSpeed)          ? "Selects how often to refresh the Session when it is running." :
                (sender == this.ux_viewMenu_UpdateSpeed_Realtime) ? "Refreshes the Session eight times per second." :
                (sender == this.ux_viewMenu_UpdateSpeed_High)     ? "Refreshes the Session twice per second." :
                (sender == this.ux_viewMenu_UpdateSpeed_Normal)   ? "Refreshes the Session every two seconds." :
                (sender == this.ux_viewMenu_UpdateSpeed_Low)      ? "Refreshes the Session every four seconds." :
                (sender == this.ux_viewMenu_UpdateSpeed_Paused)   ? "Does not automatically refresh the Session." :
                (sender == this.ux_viewMenu_Refresh)              ? "Forces the Session to refresh now, regardless of the Update Speed setting." :
                //
                // ====================
                // help menu
                //
                (sender == this.ux_helpMenu_SoftwareManual      ) ? "Displays the CAFE Model Software Manual, describing the GUI and the runtime features available within the modeling system." :
                (sender == this.ux_helpMenu_ProgrammersReference) ? "Displays the CAFE Model Programmer's Reference, containing the class library documentation of the modeling system." :
                // ----------
                (sender == this.ux_helpMenu_About               ) ? "Displays product information about the CAFE Model." :
                // ----------
                (sender == this.ux_helpMenu_ShowNotice          ) ? "Displays the CAFE Model Notice screen." :
                (sender == this.ux_helpMenu_ShowWarnings        ) ? "Displays the CAFE Model Warnings screen." :
                //
                // ====================
                // default selection, or not applicable
                //
                null;

            if (message != null && message.Length > 0 &&
                (((sender is Control) && !((Control)sender).Enabled) ||
                 ((sender is MenuItem) && !((MenuItem)sender).Enabled)))
            {
                message = "When enabled, " + (char)(message[0] + 32) + message.Remove(0, 1);
            }
            this.ux_statusBar.Text = message;
            this.ux_statusBar.ShowPanels = (message == null);
        }

        private void Control_AfterClick(object sender, EventArgs e)
        {
            this.ux_statusBar.Text = null;
            this.ux_statusBar.ShowPanels = true;
        }

        private void Control_AfterMouseClick(object sender, MouseEventArgs e)
        {
            this.Control_AfterClick(sender, e);
        }

        private void Cafe2d_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }

        private void Cafe2d_DragDrop(object sender, DragEventArgs e)
        {
            // parse drag-dropped items ...
            string[] paths = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            paths = this.GetDrapDropFiles(paths, 1);    // convert to flat list

            // determine file-type by extension -- load only *.cmsd files
            for (int i = 0; i < paths.Length; i++)
            {
                string ext = Path.GetExtension(paths[i]).Trim().ToUpper();
                if (ext == ".CMSD")
                {   // *.cmsd file found -- try to load session
                    this.OpenSession(paths[i], false);
                }
            }
        }

        private string[] GetDrapDropFiles(string[] paths, int recurseDepth)
        {
            //
            // Converts drag-droped files and directories to a flat file-list
            //
            ArrayList files = new ArrayList(16);
            for (int i = 0, pathsCount = paths.Length; i < pathsCount; i++)
            {
                if (Directory.Exists(paths[i]) && recurseDepth > 0)
                {   // path is a directory -- recurse
                    files.AddRange(this.GetDrapDropFiles(Directory.GetFiles(paths[i]), recurseDepth - 1));
                }
                else if (File.Exists(paths[i]))
                {   // path is a file -- add it
                    files.Add(paths[i]);
                }
            }
            return (string[])files.ToArray(typeof(string));
        }

        #endregion

        #region /* File menu event handlers */

        private void FileMenu_NewSession_Click(object sender, System.EventArgs e)
        {
            this.NewSession(false, null);
        }

        private void FileMenu_OpenSession_Click(object sender, System.EventArgs e)
        {
            this.OpenSession(null, false);
        }

        private void FileMenu_CloseSession_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.CloseSession();
        }

        private void FileMenu_CloseAll_Click(object sender, System.EventArgs e)
        {
            Form[] sessions = this.MdiChildren;
            this._cancelCloseAll = false;

            // iterate through each of the sessions and close them
            for (int i = sessions.Length - 1; i >= 0; i--)
            {
                if (this._cancelCloseAll) { break; }
                // close the session
                sessions[i].Activate();
                ((Session)sessions[i]).CloseSession();
                // cancel the close operation for the rest of the children if the current was not closed/disposed
                if (!sessions[i].IsDisposed) { this._cancelCloseAll = true; }
            }
        }

        private void FileMenu_SaveSession_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.SaveSession();
        }

        private void FileMenu_SaveSessionAs_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            this.ActiveSession.SaveSessionAs();
            this.EnableDragDrop();
        }

        private void FileMenu_SaveAll_Click(object sender, System.EventArgs e)
        {
            // save active session index (if one exists)
            int activeSessionIndex = this.ActiveSessionIndex;

            Form[] sessions = this.MdiChildren;
            this._cancelSave = false;

            // itterate through each of the sessions and save them
            for (int i = 0; i < sessions.Length; i++)
            {
                // if user requested to cancel saving, exit loop ...
                if (this._cancelSave) { break; }

                // save the session
                sessions[i].Activate();
                this._cancelSave = !((Session)sessions[i]).SaveSession();
            }

            // restore active session index (if there was one)
            this.ActiveSessionIndex = activeSessionIndex;
        }

        private void FileMenu_StartModeling_Click(object sender, System.EventArgs e)
        {
            // start the modeling process
            this.ActiveSession.StartModeling();
        }

        private void FileMenu_StopModeling_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.StopModeling();
        }

        private void FileMenu_Exit_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }

        #endregion

        #region /* View menu event handlers */

        void ViewMenu_ModelingSettings_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            // get the active session and display the model settings
            Session session = this.ActiveSession;
            ManageModelingSettings mms = new ManageModelingSettings(session);
            mms.ShowDialog();
            //
            this.RefreshSession();
            this.EnableDragDrop();
        }

        private void ViewMenu_InputFileLocation_Click(object sender, System.EventArgs e)
        {
            InputSettings settings = this.ActiveSession.Settings.InputSettings;
            string[] paths = new string[] {
                                              settings.MarketDataFile,
                                              settings.TechnologiesFile,
                                              settings.ParametersFile,
                                              settings.ScenariosFile
                                          };
            StringCollection uniquePaths = new StringCollection();

            // determine unique paths
            for (int i = 0; i < paths.Length; i++)
            {
                if (paths[i] != "")
                {
                    string path = Path.GetDirectoryName(paths[i]);
                    if (!uniquePaths.Contains(path))
                    {
                        uniquePaths.Add(path);
                    }
                }
            }

            // open the locations
            this.ExplorePaths(uniquePaths);
        }

        private void ViewMenu_OutputLocation_Click(object sender, System.EventArgs e)
        {
            this.ExplorePaths(this.ActiveSession.Settings.OutputSettings.OutputPath);
        }

        private void ViewMenu_UpdateSpeed_Realtime_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalRealtime;
            this.ViewMenu_UpdateSpeed_SetChecked(true, false, false, false, false);
        }

        private void ViewMenu_UpdateSpeed_High_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalHigh;
            this.ViewMenu_UpdateSpeed_SetChecked(false, true, false, false, false);
        }

        private void ViewMenu_UpdateSpeed_Normal_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalNormal;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, true, false, false);
        }

        private void ViewMenu_UpdateSpeed_Low_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalLow;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, false, true, false);
        }

        private void ViewMenu_UpdateSpeed_Paused_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalPaused;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, false, false, true);
        }

        private void ViewMenu_UpdateSpeed_SetChecked(bool realtime, bool high, bool normal, bool low, bool paused)
        {
            this.ux_viewMenu_UpdateSpeed_Realtime.Checked = realtime;
            this.ux_viewMenu_UpdateSpeed_High    .Checked = high;
            this.ux_viewMenu_UpdateSpeed_Normal  .Checked = normal;
            this.ux_viewMenu_UpdateSpeed_Low     .Checked = low;
            this.ux_viewMenu_UpdateSpeed_Paused  .Checked = paused;
        }

        private void ViewMenu_Refresh_Click(object sender, System.EventArgs e)
        {
            // refresh UI elements
            //
            // fire ProcessMouseLeave() method on all Label-Buttons in the toolbar
            Control.ControlCollection toolbarControls = this.ux_toolbar.Controls;
            int toolbarControlCount = toolbarControls.Count;
            for (int i = 0; i < toolbarControlCount; i++)
            {
                if (toolbarControls[i] is ToolbarButton)
                {
                    ((ToolbarButton)toolbarControls[i]).Refresh();
                }
            }
            // update the status bar
            this.Control_AfterClick(this, EventArgs.Empty);

            // refresh the session
            if (this._activeSession != null)
            {
                this._activeSession.RefreshSession();
            }
        }

        #endregion

        #region /* Help menu event handlers */

        void HelpMenu_SoftwareManual_Click(object sender, System.EventArgs e)
        {
            string path = ApplicationInfo.UserResourcesPath + "\\Software Manual\\v." + ApplicationInfo.ApplicationVersion;
            if (!Directory.Exists(path)) { Directory.CreateDirectory(path); }

            //---------------------------------------------------------------------------
            // generate html manual before displaying it
            //
            string resourceBase = "Volpe.Cafe.UI.Resources.Software_Manual.";
            if (!File.Exists(path + "\\CAFE Model Software Manual.htm"))
            {
                using (Stream stream = Program.GetAssemblyResource(resourceBase + "CAFE Model Software Manual.htm"))
                {
                    byte[] buffer = new byte[stream.Length];
                    stream.Read(buffer, 0, (int)stream.Length);
                    //
                    using (FileStream fs = new FileStream(path + "\\CAFE Model Software Manual.htm", FileMode.Create, FileAccess.Write, FileShare.None))
                    {
                        fs.Write(buffer, 0, buffer.Length);
                    }
                }
            }
            //
            const int imageCount = 20;
            resourceBase += "images.";
            if (!Directory.Exists(path + "\\images")) { Directory.CreateDirectory(path + "\\images"); }
            for (int i = 0; i < imageCount; i++)
            {
                string imageName = "image" + (i + 1).ToString("000") + ".png";
                string imagePath = path + "\\images\\" + imageName;
                if (!File.Exists(imagePath))
                {
                    using (Stream stream = Program.GetAssemblyResource(resourceBase + imageName))
                    {
                        byte[] buffer = new byte[stream.Length];
                        stream.Read(buffer, 0, (int)stream.Length);
                        //
                        using (FileStream fs = new FileStream(imagePath, FileMode.Create, FileAccess.Write, FileShare.None))
                        {
                            fs.Write(buffer, 0, buffer.Length);
                        }
                    }
                }
            }

            //---------------------------------------------------------------------------
            // open html manual in default browser first
            // if that fails, retry using internet explorer, in case default browser is
            // blocked by group policy
            //
            try { Process.Start(path + "\\CAFE Model Software Manual.htm"); }
            catch
            {
                try { Process.Start("iexplore", path + "\\CAFE Model Software Manual.htm"); }
                catch (Exception ex)
                {
                    MessageBox.Show("Could not open web browser.\n\n" + ex.Message, "CAFE Model Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }
        void HelpMenu_ProgrammersReference_Click(object sender, System.EventArgs e)
        {
            string path = ApplicationInfo.UserResourcesPath + "\\Programmer's Reference\\v." + ApplicationInfo.ApplicationVersion;
            if (!Directory.Exists(path)) { Directory.CreateDirectory(path); }
            //
            // generate chm file before displaying it
            string file = path + "\\CAFE Model Programmer's Reference.chm";
            using (Stream stream = Program.GetAssemblyResource("Volpe.Cafe.UI.Resources.Programmer_s_Reference.CAFE Model Programmer's Reference.chm"))
            {
                if (File.Exists(file) && (new FileInfo(file)).Length != stream.Length)
                {   // previous file exists, but size does not match -- delete and regenerate new version
                    File.Delete(file);
                }
                if (!File.Exists(file))
                {
                    byte[] buffer = new byte[stream.Length];
                    stream.Read(buffer, 0, (int)stream.Length);
                    using (FileStream fs = new FileStream(file, FileMode.Create, FileAccess.Write, FileShare.None))
                    {
                        fs.Write(buffer, 0, buffer.Length);
                    }
                }
            }
            // open chm file
            try
            {
                Process.Start(file);
            }
            catch (Exception ex)
            {
                MessageBox.Show("Could not display CAFE model Programmer's Reference.\n\n" + ex.Message,
                    "CAFE Model Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        void HelpMenu_ShowNotice_Click(object sender, EventArgs e)
        {
            Program.ShowNoticeScreen();
        }
        void HelpMenu_ShowWarnings_Click(object sender, EventArgs e)
        {
            Program.ShowWarningsScreen(false);
        }
        void HelpMenu_About_Click(object sender, System.EventArgs e)
        {
            Program.ShowAboutScreen();
        }

        #endregion

        #region /* Toolbar event handlers */

        private void Toolbar_NewSession_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_NewSession_Click(sender, e);
        }

        private void Toolbar_OpenSession_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_OpenSession_Click(sender, e);
        }

        private void Toolbar_SaveSession_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_SaveSession_Click(sender, e);
        }

        private void Toolbar_ModelingSettings_Click(object sender, System.EventArgs e)
        {
            this.ViewMenu_ModelingSettings_Click(sender, e);
        }

        private void Toolbar_StartModeling_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_StartModeling_Click(sender, e);
        }

        private void Toolbar_StopModeling_Click(object sender, System.EventArgs e)
        {
            if (this._activeSession.Running)
            {
                // if the session is running, stop it
                this.FileMenu_StopModeling_Click(sender, e);
            }
        }

        #endregion

        #region /* Helper methods */

        /// <summary>
        /// Disables drag-and-drop on the Cafe2d UI, if it is enabled.
        /// </summary>
        private void DisableDragDrop()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EmptyEventHandler(this.DisableDragDrop));
            }
            else
            {
                this.AllowDrop  = false;
                this.DragEnter -= new DragEventHandler(this.Cafe2d_DragEnter);
                this.DragDrop  -= new DragEventHandler(this.Cafe2d_DragDrop);
            }
        }

        /// <summary>
        /// Enables drag-and-drop on the Cafe2d UI, if settings permit and it is disabled.
        /// </summary>
        private void EnableDragDrop()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EmptyEventHandler(this.EnableDragDrop));
            }
            else
            {
                this.AllowDrop  = true;
                this.DragEnter += new DragEventHandler(this.Cafe2d_DragEnter);
                this.DragDrop  += new DragEventHandler(this.Cafe2d_DragDrop);
            }
        }

        private void NewSession(bool parseCustFiles, string[] files)
        {
            Session session = new Session(this);
            session.RefreshInterval = Cafe2d.RefreshIntervalNormal;    // set the default refresh interval
            session.MdiParent = this;
            session.Show();         // display the new session
            session.RefreshSession();
            this.ViewMenu_ModelingSettings_Click(this, EventArgs.Empty);

//            this.DisableDragDrop();
//            bool nswCreated = false;
//            if (this._newSesWizard == null)
//            {
//                this._newSesWizard = new NewSessionWizard(this);
//                nswCreated = true;
//            }
//            if (parseCustFiles) { this._newSesWizard.ParseFiles(files); }
//            if (!nswCreated) { this._newSesWizard.Focus(); return; }    // focus the NSW window and return
//
//            if (this._newSesWizard.ShowDialog() == DialogResult.OK)
//            {
//                Session2d s2d = this._newSesWizard.Session;
//                s2d.RefreshInterval = Cafe2d.RefreshIntervalNormal;    // set the default refresh interval
//                s2d.MdiParent = this;
//                s2d.Show();         // display the new session
//                if (this._newSesWizard.SaveSession) { s2d.SaveSession(); }
//            }
//            // clear the wizard
//            this._newSesWizard = null;
//            this.RefreshSession();
//            this.EnableDragDrop();
        }

        /// <summary>
        /// Opens a new session with the specified filename, or prompts a user to select a file if filename is null.
        /// </summary>
        /// <param name="filename">The name of the file to load, or null to display the OpenFileDialog.</param>
        /// <param name="silent">true, to silently accept all prompts; false, otherwise.</param>
        /// <returns>true, if the session was opened; false, otherwise.</returns>
        public bool OpenSession(string filename, bool silent)
        {
            this.DisableDragDrop();
            bool opened = false;

            if (filename == null || filename == "")
            {   // prompt for session file to open
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "All Files (*.*)|*.*|CAFE Model Session Data (*.cmsd)|*.cmsd";
                dlg.FilterIndex = 2;
                dlg.Title = "Please select the session file you would like to open:";
                if (dlg.ShowDialog() == DialogResult.OK) { filename = dlg.FileName; }
                else                                     { filename = null; }
            }

            if (filename != null)
            {   // initialize a new session ...
                try
                {
                    Session session = new Session(this, filename);
                    if (session.IsOpen)
                    {
                        session.MdiParent = this;
                        session.Show();
                        session.RefreshSession();
                        opened = true;
                    }
                    else
                    {
                        session.Close();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "CAFE Model Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }

            this.EnableDragDrop();
            return opened;
        }

        private void SetStatus(string message)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new StringMessageEventHandler(this.SetStatus), new object[] {message});
            }
            else
            {
                this.ux_statusPanel.Text = message;
            }
        }
        internal void SetStatus(Session child, string message)
        {
            if (this._activeSession != null && child == this._activeSession)
            {
                this.SetStatus(message);
            }
        }

        private void ExplorePaths(params string[] paths)
        {
            for (int i = 0; i < paths.Length; i++)
            {
                Process.Start("explorer", "/e," + paths[i]);
            }
        }

        private void ExplorePaths(ICollection paths)
        {
            string[] array = new string[paths.Count];
            paths.CopyTo(array, 0);
            this.ExplorePaths(array);
        }

        private void AddMenuItemEventHandlers(Menu.MenuItemCollection items)
        {
            for (int i = 0, count = items.Count; i < count; i++)
            {
                items[i].Select += new EventHandler(this.Control_AfterSelect);
                items[i].Click  += new EventHandler(this.Control_AfterClick);
                this.AddMenuItemEventHandlers(items[i].MenuItems);
            }
        }

        private void AddToolbarEventHandlers(Panel toolbar)
        {
            Control.ControlCollection items = toolbar.Controls;
            for (int i = 0, count = items.Count; i < count; i++)
            {
                if (items[i] is ToolbarButton)
                {
                    items[i].MouseEnter += new EventHandler(this.Control_AfterSelect);
                    items[i].MouseLeave += new EventHandler(this.Control_AfterClick);
                    items[i].MouseUp    += new MouseEventHandler(this.Control_AfterMouseClick);
                }
            }
        }

        #endregion

        /// <summary>
        /// Refreshes the Cafe2d user interface based on the current state of the sessions.
        /// </summary>
        internal void RefreshSession()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EmptyEventHandler(this.RefreshSession));
            }
            else
            {
                // enable or disable toolbars and menus based on whether there are any open sessions,
                // any active sessions, and whether the active session is running
                bool anyOpen = (this.Sessions.Length > 0);
                bool twoOrMoreOpen = (this.Sessions.Length > 1);
                bool anyActive = this.SessionsActive();
                bool running = (this._activeSession == null) ? false : this._activeSession.Running;
                bool canStart = (this._activeSession == null) ? false :
                    (this._activeSession.Compliance != null && !this._activeSession.Compliance.Running);
                bool saveReq = (this._activeSession == null) ? false : this._activeSession.SaveRequired;

                bool or   = anyOpen &&  running;
                bool onr  = anyOpen && !running;
                bool onra = anyOpen && !anyActive;

                // welcome label
                this.ux_welcomeLabel.Visible = !anyOpen;

                // file menu
                this.ux_fileMenu_CloseSession               .Enabled =  onr;
                this.ux_fileMenu_CloseAll                   .Enabled =  onra;
                this.ux_fileMenu_SaveSession                .Enabled = (onr && saveReq);
                this.ux_fileMenu_SaveSessionAs              .Enabled =  onr;
                this.ux_fileMenu_SaveAll                    .Enabled =  onra;
                this.ux_fileMenu_StartModeling              .Enabled = (onr && canStart);
                this.ux_fileMenu_StopModeling               .Enabled =  or;
                this.ux_fileMenu_Exit                       .Enabled = !anyActive;
                // view menu
                this.ux_viewMenu_ModelingSettings           .Enabled =  anyOpen;
                this.ux_viewMenu_InputFileLocation          .Enabled =  anyOpen;
                this.ux_viewMenu_OutputLocation             .Enabled =  anyOpen;
                this.ux_viewMenu_UpdateSpeed                .Enabled =  anyOpen;
                this.ux_viewMenu_Refresh                    .Enabled =  anyOpen;
                // toolbar
                this.ux_toolbar_SaveSession                 .Enabled = (onr && saveReq);
                this.ux_toolbar_ModelingSettings            .Enabled =  anyOpen;
                this.ux_toolbar_StartModeling               .Enabled = (onr && canStart);
                this.ux_toolbar_StopModeling                .Enabled =  or;
            }
        }

        /**
         * <summary>
         * Determines if any of the sessions are currently active, that is whether they are running/reporting or not.
         * </summary>
         */
        private bool SessionsActive()
        {
            Session[] sessions = this.Sessions;
            for (int i = 0; i < sessions.Length; i++)
            {
                if (!sessions[i].IsDisposed && sessions[i].Running)
                {
                    return true;
                }
            }
            return false;
        }

        #endregion


        #region /*** Properties ***/

        #region /* Static properties */

        /// <summary>Gets a list of types describing compliance models from dynamically loaded assemblies available to the
        ///   modeling system.</summary>
        public static Type[] ComplianceTypes
        {
            get
            {
                Type[] types = new Type[Cafe2d._cmpTypes.Count];
                for (int i = 0; i < types.Length; i++)
                {
                    types[i] = (Type)Cafe2d._cmpTypes[i];
                }
                return types;
            }
        }

        #endregion

        /// <summary>Gets an array of currently openned sessions, ignoring any disposed or disposing sessions.</summary>
        public Session[] Sessions
        {
            get
            {
                // get mdi children and count of non-disposed(ing) children
                Form[] children = this.MdiChildren;
                int childCount = children.Length;
                bool[] liveChildren = new bool[childCount];
                int liveCount = 0;
                for (int i = 0; i < childCount; i++)
                {
                    liveChildren[i] = !(children[i].Disposing || children[i].IsDisposed);
                    if (liveChildren[i]) { liveCount++; }
                }
                // create array of non-disposed sessions
                Session[] sessions = new Session[liveCount];
                for (int i = 0, j = 0; i < childCount; i++)
                {
                    if (liveChildren[i]) { sessions[j++] = (Session)children[i]; }
                }
                return sessions;
            }
        }

        /// <summary>Gets the active session -- the session that has focus and is currently being viewed by the user.  If there
        ///   are no active sessions, a new one will be created.</summary>
        public Session ActiveSession
        {
            get
            {
                if (this._activeSession == null)
                {
                    this.FileMenu_NewSession_Click(this, EventArgs.Empty);
                }
                return this._activeSession;
            }
        }

        /// <summary>Gets or sets the index of the child form that is the active session.  During a get operation, if there are
        ///   no active sessions, the return value is -1.  During a set operation, if the index is invalid, the set operation has
        ///   no effect.</summary>
        private int ActiveSessionIndex
        {
            get
            {
                Form child = this.ActiveMdiChild;
                for (int i = 0; i < this.MdiChildren.Length; i++)
                {
                    if (this.MdiChildren[i] == child)
                    {
                        return i;
                    }
                }
                return -1;
            }
            set
            {
                if (value >= 0 && value < this.MdiChildren.Length)
                {
                    this.MdiChildren[value].Activate();
                }
            }
        }

        #endregion


        #region /*** Variables ***/

        #region /* UI Variables */

        Label ux_welcomeLabel;
        //
        MainMenu ux_mainMenu;
        MenuItem ux_fileMenu;
        MenuItem ux_viewMenu;
        MenuItem ux_helpMenu;
        MenuItem ux_fileMenu_NewSession;
        MenuItem ux_fileMenu_OpenSession;
        MenuItem ux_fileMenu_CloseSession;
        MenuItem ux_fileMenu_CloseAll;
        MenuItem ux_fileMenu_SaveSession;
        MenuItem ux_fileMenu_SaveSessionAs;
        MenuItem ux_fileMenu_Separator0;
        MenuItem ux_fileMenu_Separator1;
        MenuItem ux_fileMenu_StartModeling;
        MenuItem ux_fileMenu_StopModeling;
        MenuItem ux_fileMenu_Separator3;
        MenuItem ux_fileMenu_Exit;
        MenuItem ux_fileMenu_SaveAll;
        MenuItem ux_viewMenu_Separator0;
        MenuItem ux_viewMenu_InputFileLocation;
        MenuItem ux_viewMenu_OutputLocation;
        MenuItem ux_viewMenu_Separator1;
        MenuItem ux_viewMenu_UpdateSpeed;
        MenuItem ux_viewMenu_UpdateSpeed_Realtime;
        MenuItem ux_viewMenu_UpdateSpeed_High;
        MenuItem ux_viewMenu_UpdateSpeed_Normal;
        MenuItem ux_viewMenu_UpdateSpeed_Low;
        MenuItem ux_viewMenu_UpdateSpeed_Separator0;
        MenuItem ux_viewMenu_UpdateSpeed_Paused;
        MenuItem ux_viewMenu_Refresh;
        MenuItem ux_viewMenu_ModelingSettings;
        MenuItem ux_helpMenu_SoftwareManual;
        MenuItem ux_helpMenu_ProgrammersReference;
        MenuItem ux_helpMenu_Separator0;
        MenuItem ux_helpMenu_About;
        MenuItem ux_helpMenu_Separator1;
        MenuItem ux_helpMenu_ShowNotice;
        MenuItem ux_helpMenu_ShowWarnings;
        StatusBar ux_statusBar;
        StatusBarPanel ux_statusPanel;
        StatusBarPanel ux_versionPanel;
        //
        Panel ux_toolbar;
        ToolbarButton ux_toolbar_StopModeling;
        ToolbarButton ux_toolbar_StartModeling;
        ToolbarButton ux_toolbar_ModelingSettings;
        ToolbarButton ux_toolbar_SaveSession;
        ToolbarButton ux_toolbar_OpenSession;
        ToolbarButton ux_toolbar_NewSession;

        /// <summary>
        /// Requied designer variable.
        /// </summary>
        System.ComponentModel.IContainer components = null;

        #endregion

        // shared paths
        static ArrayList  _cmpTypes;        // compliance types loaded from assembiles

        const int RefreshIntervalRealtime = 125;
        const int RefreshIntervalHigh     = 500;
        const int RefreshIntervalNormal   = 2000;
        const int RefreshIntervalLow      = 4000;
        const int RefreshIntervalPaused   = -1;

        Session _activeSession;

        // control variables -- used in assisting gui events
        bool _cancelSave;
        bool _cancelCloseAll;

        #endregion

    }
}
