﻿#region << Using Directives >>
using System;
using System.Collections.Generic;
using Volpe.Cafe.Utils;
#endregion

namespace Volpe.Cafe.Settings
{
    /// <summary>
    /// Provides a table of technology cost or fuel consumption adjustment factors for all technology classes.
    /// </summary>
    [Serializable]
    public sealed class TechnologyAdjFactors
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="TechnologyAdjFactors"/> class.
        /// </summary>
        internal TechnologyAdjFactors(double defaultValue)
        {
            this._defaultValue = defaultValue;
            this._values       = new Dictionary<ulong, double[]>();
        }

        #endregion

        #region /*** Methods ***/

        internal TechnologyAdjFactors Clone()
        {
            TechnologyAdjFactors taf = new TechnologyAdjFactors(this._defaultValue);
            //
            foreach (var item in this._values)
            {
                taf._values.Add(item.Key, item.Value.CloneArray());
            }
            //
            return taf;
        }
        internal void Add(ulong key, double[] values)
        {
            this._values.Add(key, values);
        }

        #endregion

        #region /*** Properties ***/

        /// <summary>
        /// Gets the adjustment factor associated with the specified key, for the specified technology class.
        /// </summary>
        /// <param name="key">The key for which to obtain the adjustment value.</param>
        /// <param name="techClass">The technology class for which to obtain the adjustment value.</param>
        /// <returns>The adjustment factor associated with the specified key and technology class. If an adjustment factor for the
        ///   specified key does not exist, a default value will be returned.</returns>
        public double this[ulong key, int techClass]
        {
            get
            {
                double[] d;
                return (this._values.TryGetValue(key, out d)) ? d[techClass] : this._defaultValue;
            }
        }

        #endregion

        #region /*** Variables ***/

        double                      _defaultValue; // the value to return if key is not found
        Dictionary<ulong, double[]> _values;

        #endregion

    }
}
