﻿#region << Using Directives >>
using System;
using Volpe.Cafe.Utils;
#endregion

namespace Volpe.Cafe.Settings
{
    /// <summary>
    /// Provides costs relating to a single vehicle technology, for one CAFE technology class.
    /// </summary>
    [Serializable]
    public class TechnologyCosts
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="TechnologyCosts"/> class.
        /// </summary>
        internal TechnologyCosts() { }

        #endregion

        #region /*** Methods ***/

        /// <summary>
        /// Creates a new object that is a copy of the current <see cref="TechnologyCosts"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="TechnologyCosts"/>.</returns>
        internal TechnologyCosts Clone()
        {
            TechnologyCosts tc = new TechnologyCosts();
            //
            tc.CostTable            = this.CostTable           .CloneArray();
            tc.MaintenanceCostTable = this.MaintenanceCostTable.CloneArray();
            tc.RepairCostTable      = this.RepairCostTable     .CloneArray();
            tc.StrandedCapital      = this.StrandedCapital     .CloneArray();
            //
            return tc;
        }

        #endregion

        #region /*** Variables ***/

        /// <summary>Provides a table of learned out cost estimates for the current technology.</summary>
        public double[] CostTable;
        /// <summary>Provides a table of learned out maintenance cost estimates for the current technology.</summary>
        public double[] MaintenanceCostTable;
        /// <summary>Provides a table of learned out repair cost estimates for the current technology.</summary>
        public double[] RepairCostTable;

        /// <summary>Provides a list of stranded capital costs for the current technology.</summary>
        public double[] StrandedCapital;

        #endregion

    }
}
