﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Utils
{
    /// <summary>
    /// Provides extension methods for cloning arrays.
    /// </summary>
    [Serializable]
    public static class ArrayExtension
    {

        #region /*** Methods ***/

        #region /* Generic array cloning */

        /// <summary>
        /// Creates a shallow copy of a one-dimensional array of type T.
        /// </summary>
        /// <typeparam name="T">The type of the elements of the array.</typeparam>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional array of type T.</returns>
        public static T[] CloneArray<T>(this T[] array)
        {
            return (T[])array.Clone();
        }
        /// <summary>
        /// Creates a deep copy of a one-dimensional array of type T by executing the specified cloneT delegate on each member of the array.
        /// </summary>
        /// <typeparam name="T">The type of the elements of the array.</typeparam>
        /// <param name="array">The array to clone.</param>
        /// <param name="cloneT">Encapsulates a method that will handle cloning for each element of the array.</param>
        /// <returns>A deep copy of a one-dimensional array of type T.</returns>
        public static T[] CloneArray<T>(this T[] array, Func<T, T> cloneT)
        {
            T[] newArray = new T[array.Length];
            for (int i = 0; i < array.Length; i++)
            {
                newArray[i] = cloneT(array[i]);
            }
            return newArray;
        }

        #endregion

        #region /* Boolean/Char/String array cloning */

        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Boolean"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Boolean"/> array.</returns>
        public static bool[] CloneArray(this bool[] array)
        {
            return (bool[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Char"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Char"/> array.</returns>
        public static char[] CloneArray(this char[] array)
        {
            return (char[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="String"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="String"/> array.</returns>
        public static string[] CloneArray(this string[] array)
        {
            return (string[])array.Clone();
        }

        #endregion

        #region /* Integer array cloning */

        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="SByte"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="SByte"/> array.</returns>
        public static sbyte[] CloneArray(this sbyte[] array)
        {
            return (sbyte[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Byte"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Byte"/> array.</returns>
        public static byte[] CloneArray(this byte[] array)
        {
            return (byte[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Int16"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Int16"/> array.</returns>
        public static short[] CloneArray(this short[] array)
        {
            return (short[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="UInt16"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="UInt16"/> array.</returns>
        public static ushort[] CloneArray(this ushort[] array)
        {
            return (ushort[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Int32"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Int32"/> array.</returns>
        public static int[] CloneArray(this int[] array)
        {
            return (int[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="UInt32"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="UInt32"/> array.</returns>
        public static uint[] CloneArray(this uint[] array)
        {
            return (uint[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Int64"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Int64"/> array.</returns>
        public static long[] CloneArray(this long[] array)
        {
            return (long[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="UInt64"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="UInt64"/> array.</returns>
        public static ulong[] CloneArray(this ulong[] array)
        {
            return (ulong[])array.Clone();
        }

        #endregion

        #region /* Floating-point array cloning */

        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Single"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Single"/> array.</returns>
        public static float[] CloneArray(this float[] array)
        {
            return (float[])array.Clone();
        }
        /// <summary>
        /// Creates a shallow copy of a one-dimensional <see cref="Double"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a one-dimensional <see cref="Double"/> array.</returns>
        public static double[] CloneArray(this double[] array)
        {
            return (double[])array.Clone();
        }

        /// <summary>
        /// Creates a shallow copy of a two-dimensional jagged <see cref="Double"/> array.
        /// </summary>
        /// <param name="array">The array to clone.</param>
        /// <returns>A shallow copy of a two-dimensional jagged <see cref="Double"/> array.</returns>
        public static double[][] CloneArray(this double[][] array)
        {
            double[][] newArray = new double[array.Length][];
            for (int i = 0; i < array.Length; i++)
            {
                newArray[i] = array[i].CloneArray();
            }
            return newArray;
        }

        #endregion

        #endregion

    }
}
