﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.IO.Reporting.CSV
{
    /// <summary>
    /// Provides a base class for generating Comma Separated Value (CSV) reports.
    /// </summary>
    [Serializable]
    public abstract class CsvReportingBase : DelimitedReportingBase
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="CsvReportingBase"/> class.
        /// </summary>
        /// <param name="path">The output path for the report.</param>
        /// <param name="append">Determines whether data is to be appended to the file.  If the file exists and append is false,
        ///   the file is overwritten. If the file exists and append is true, the data is appended to the file. Otherwise, a new
        ///   file is created.</param>
        public CsvReportingBase(string path, bool append) : base(path, append, ',') { }

        #endregion

    }
}
