#region << Using Directives >>
using System;
using System.ComponentModel;
using System.IO;
using System.IO.Compression;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Utils;
using Volpe.Cafe.UI.Panels;
#endregion

namespace Volpe.Cafe.UI
{
	/// <summary>
	/// Provides a graphical user interface (GUI) for a single session of the CAFE Model.
	/// </summary>
	public class Session : Form
	{

        #region /*** Constructors ***/

        /// <summary>
        /// Initializes a new empty CAFE Model session.
        /// </summary>
        /// <param name="parent">The main form of the application, which is the MDI parent of this session window.</param>
        public Session(Cafe2d parent)
        {
            this.InitializeComponent();
            this._parent = parent;
            this.ux_sessionPanel.CreateNewSession();
        }
        /// <summary>
        /// Initializes a new CAFE Model session located at the specified path.
        /// </summary>
        /// <param name="parent">The main form of the application, which is the MDI parent of this session window.</param>
        /// <param name="path">The path of the session to load.  This value may be null.</param>
        public Session(Cafe2d parent, string path)
        {
            this.InitializeComponent();
            this._parent = parent;
            this.ux_sessionPanel.OpenSession(path);
        }
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        #endregion

        #region /*** Methods ***/

        #region /* Windows Form Designer generated code */

        void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Session));
            this.ux_sessionPanel = new Volpe.Cafe.UI.Panels.SessionPanel();
            this.SuspendLayout();
            // 
            // ux_sessionPanel
            // 
            this.ux_sessionPanel.Compliance = null;
            this.ux_sessionPanel.Data = null;
            this.ux_sessionPanel.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_sessionPanel.Location = new System.Drawing.Point(0, 0);
            this.ux_sessionPanel.Name = "ux_sessionPanel";
            this.ux_sessionPanel.RefreshInterval = 125;
            this.ux_sessionPanel.SaveRequired = false;
            this.ux_sessionPanel.Size = new System.Drawing.Size(472, 293);
            this.ux_sessionPanel.TabIndex = 0;
            this.ux_sessionPanel.SessionUpdating += new System.EventHandler(this.SessionPanel_SessionUpdating);
            this.ux_sessionPanel.SessionNameChanged += new System.EventHandler(this.SessionPanel_SessionNameChanged);
            // 
            // Session
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(472, 293);
            this.Controls.Add(this.ux_sessionPanel);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Name = "Session";
            this.Text = "Session";
            this.ResumeLayout(false);

        }

        #endregion

        #region /* Overriden Methods */

        /// <summary>
        /// Raises the <see cref="Form.Closing"/> event.
        /// </summary>
        /// <param name="e">Event data to pass to the event.</param>
        protected override void OnClosing(CancelEventArgs e)
        {
            if (!this.ux_sessionPanel.CloseSession())
            {
                e.Cancel = true;
            }
        }

        #endregion

        /// <summary>
        /// Closes the session window.
        /// </summary>
        public void CloseSession()
        {
            if (this.ux_sessionPanel.CloseSession())
            {
                base.Close();
            }
        }

        /// <summary>
        /// Saves the session to disk.  If the session has not been previously saved, a <see cref="SaveFileDialog"/> will be
        /// displayed.
        /// </summary>
        /// <returns>true, if the session was saved; false, otherwise.</returns>
        public bool SaveSession()
        {
            return this.ux_sessionPanel.SaveSession();
        }
        /// <summary>
        /// Saves the session to disk, using the specified session name.  If the session has not been previously saved, a
        /// <see cref="SaveFileDialog"/> will be displayed.
        /// </summary>
        /// <param name="name">The name to assign to the session.</param>
        /// <returns>true, if the session was saved; false, otherwise.</returns>
        public bool SaveSession(string name)
        {
            return this.ux_sessionPanel.SaveSession(name);
        }
        /// <summary>
        /// Displays a <see cref="SaveFileDialog"/> to the user, and saves the the session to the specified file on disk.
        /// </summary>
        /// <returns>true, if the session was saved; false, otherwise.</returns>
        public bool SaveSessionAs()
        {
            return this.ux_sessionPanel.SaveSessionAs();
        }

        /// <summary>
        /// Starts the compliance modeling process for the current session.
        /// </summary>
        public void StartModeling()
        {
            this.ux_sessionPanel.StartModeling();
        }
        /// <summary>
        /// Stops the compliance modeling process for the current session.
        /// </summary>
        public void StopModeling()
        {
            this.ux_sessionPanel.StopModeling();
        }

        // ----- event handlers from the session-panel -----
        void SessionPanel_SessionNameChanged(object sender, EventArgs e)
        {
            this.Text = this.ux_sessionPanel.Text;
        }
        void SessionPanel_SessionUpdating(object sender, EventArgs e)
        {
            this._parent.SetStatus(this, this.ux_sessionPanel.Status);
            this._parent.RefreshSession();
        }

        // ----- support methods -----
        /// <summary>
        /// Refreshes the session progress and status information.
        /// </summary>
        public void RefreshSession()
        {
            this.ux_sessionPanel.RefreshSession();
            this._parent.RefreshSession();
        }

        #endregion

        #region /*** Properties ***/

        /// <summary>Gets the name of the session.</summary>
        public string SessionName { get { return this.ux_sessionPanel.SessionName; } }
        /// <summary>Gets the location of the session file, where the session data was loaded from or can be saved to.</summary>
        public string SessionPath { get { return this.ux_sessionPanel.SessionPath; } }

        /// <summary>Gets or sets the compliance model implementation that will be used during the modeling process.</summary>
        /// <remarks>Selecting a different compliance model implementation will force the current session to restart.</remarks>
        public ICompliance Compliance { get { return this.ux_sessionPanel.Compliance; } set { this.ux_sessionPanel.Compliance = value; } }
        /// <summary>Gets or sets the modeling data associated with the current session.</summary>
        public Industry Data { get { return this.ux_sessionPanel.Data; } set { this.ux_sessionPanel.Data = value; } }
        /// <summary>Gets or sets the modeling settings associated with the current session.</summary>
        public ModelingSettings Settings
        {
            get { return this.ux_sessionPanel.Settings; }
            //set { this.ux_sessionPanel.Settings = value; }
        }

        /// <summary>Gets whether the session is currently executing the compliance model simulation.</summary>
        public bool Running { get { return this.ux_sessionPanel.Running; } }

        /// <summary>Gets the status of the session, which should be displayed in the parent form's status bar.</summary>
        public string Status { get { return this.ux_sessionPanel.Status; } }
        /// <summary>Gets or set how frequently, in milliseconds, the session refreshes itself based on the latest progress
        ///   information of the compliance model.  Use -1 to pause refreshing; otherwise, the refresh interval will be converted
        ///   to be a minimum <see cref="SessionPanel.MinRefreshInterval"/> or a multiple of
        ///   <see cref="SessionPanel.MinRefreshInterval"/>.</summary>
        public int RefreshInterval
        {
            get { return this.ux_sessionPanel.RefreshInterval; }
            set { this.ux_sessionPanel.RefreshInterval = value; }
        }

        /// <summary>Gets whether the session is open.</summary>
        public bool IsOpen { get { return this.ux_sessionPanel.IsOpen; } }
        /// <summary>Gets whether the session was open as read-only.</summary>
        public bool ReadOnly { get { return this.ux_sessionPanel.ReadOnly; } }
        /// <summary>Gets or sets whether the session needs to be saved.</summary>
        public bool SaveRequired
        {
            get { return this.ux_sessionPanel.SaveRequired; }
            set { this.ux_sessionPanel.SaveRequired = value; }
        }

        #endregion

        #region /*** Variables ***/

        #region /* UI Variables */

        SessionPanel ux_sessionPanel;

        #endregion

        Cafe2d _parent;

        #endregion

	}
}
