﻿#region << Using Directives >>
using System;
using Volpe.Cafe.IO;
#endregion

namespace Volpe.Cafe.Settings
{
    /// <summary>
    /// Provides an interface for implementing objects containing runtime-assigned modeling settings.
    /// </summary>
    public interface ISettings : ICloneable
    {

        #region /*** Methods ***/

        /// <summary>
        /// Sets the initial state for the <see cref="ISettings"/> object to the default values.
        /// </summary>
        void SetDefaultSettings();

        /// <summary>
        /// Updates this <see cref="ISettings"/> object with values from the specified new settings.
        /// </summary>
        /// <param name="newSettings">An <see cref="ISettings"/> object containing new runtime settings for this instance.</param>
        void UpdateSettings(ISettings newSettings);

        /// <summary>
        /// Writes settings data to the summary.txt log file.
        /// </summary>
        void WriteSummaryLog(LogWriter writer);

        /// <summary>
        /// Creates a new object that is a copy of the current <see cref="ISettings"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="ISettings"/>.</returns>
        new ISettings Clone();

        #endregion


        #region /*** Properties ***/
        #endregion

    }
}
