﻿#region << Using Directives >>
using System;
using System.IO;
using System.Reflection;
using System.Windows.Forms;
#endregion

namespace Volpe.Cafe.Utils
{
    /// <summary>
    /// Provides basic information about the current version of the CAFE Model.
    /// </summary>
    public static class ApplicationInfo
    {

        #region /*** Constructors ***/

        static ApplicationInfo()
        {
            Assembly exeAssembly = Assembly.GetExecutingAssembly();
            ApplicationVersion = exeAssembly.GetName().Version.ToString();
            ApplicationTimestamp = (new FileInfo(exeAssembly.GetFiles()[0].Name)).LastWriteTime.ToString("M/dd/yy H:mm:ss");

            ApplicationPath    = Application.StartupPath;
            UserResourcesPath  = Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData) + "\\Volpe Center\\CAFE Model";
            LogPath            = UserResourcesPath + "\\logs";
            DefaultOutputPath  = UserResourcesPath + "\\output";
            SettingsFilePath   = UserResourcesPath + "\\settings.bin";
            RecentListFilePath = UserResourcesPath + "\\recent.list";

            // create directories
            if (!Directory.Exists(LogPath          )) { Directory.CreateDirectory(LogPath          ); }
            if (!Directory.Exists(DefaultOutputPath)) { Directory.CreateDirectory(DefaultOutputPath); }
        }

        #endregion


        #region /*** Variables ***/

        /// <summary>Specifies the version of the executable for the application.</summary>
        public static readonly string ApplicationVersion;
        /// <summary>Specifies the date and time the executable for the application was built.</summary>
        public static readonly string ApplicationTimestamp;

        /// <summary>Specifies the path for the executable file that started the application, not including the executable name.</summary>
        public static readonly string ApplicationPath;
        /// <summary>Specifies the path where additional user-specific application resources are located.</summary>
        public static readonly string UserResourcesPath;
        /// <summary>Specifies the path where the model log files are stored.</summary>
        public static readonly string LogPath;
        /// <summary>Specifies the default path where the output files are stored.</summary>
        public static readonly string DefaultOutputPath;
        /// <summary>Specifies the location of the settings.bin file.</summary>
        public static readonly string SettingsFilePath;
        /// <summary>Specifies the location of the recent.list file.</summary>
        public static readonly string RecentListFilePath;

        #endregion

    }
}
