using System;

namespace Volpe.Cafe.UI
{
    /// <summary>
    /// Specifies the data file type of the input file.
    /// </summary>
    public enum DataFileType : int
    {
        /// <summary>
        /// Specifies that the data file type is the market-data file.
        /// </summary>
        MarketData = 0,

        /// <summary>
        /// Specifies that the data file type is the technologies file.
        /// </summary>
        Technologies = 1,

        /// <summary>
        /// Specifies that the data file type is the parameters file.
        /// </summary>
        Parameters = 2,

        /// <summary>
        /// Specifies that the data file type is the tailpipe emission rates file.
        /// </summary>
        TailpipeEmissions = 3,

        /// <summary>
        /// Specifies that the data file type is the scenarios file.
        /// </summary>
        Scenarios = 4,

        /// <summary>
        /// Specifies that the data file type unknown, does not exist, or is not applicable.
        /// </summary>
        None = -1
    }
}
