using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Utils;
using Volpe.Cafe.Model;

namespace Volpe.Cafe.UI.Panels
{
    /// <summary>
    /// Provides a panel for configuring operating modes for the compliance model.
    /// </summary>
    public class OpModesPanel : CafeUserControl
    {

        #region /*** Constructors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="OpModesPanel"/> class.
        /// </summary>
        public OpModesPanel()
        {
            this.InitializeComponent();
            this.PostInitialize();
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        #endregion


        #region /*** Methods ***/

        #region /* Designer generated code */

        void InitializeComponent()
        {
            this.ux_fleetAnalysis = new System.Windows.Forms.CheckBox();
            this.ux_consumerBenefitsScale = new System.Windows.Forms.TextBox();
            this.ux_scaleConsumerBenefits = new System.Windows.Forms.CheckBox();
            this.ux_co2PriceEstimatesGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_co2PriceVeryHigh = new System.Windows.Forms.RadioButton();
            this.ux_co2PriceHigh = new System.Windows.Forms.RadioButton();
            this.ux_co2PriceAverage = new System.Windows.Forms.RadioButton();
            this.ux_co2PriceLow = new System.Windows.Forms.RadioButton();
            this.ux_fuelPriceEstimatesGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_fuelPriceHigh = new System.Windows.Forms.RadioButton();
            this.ux_fuelPriceAverage = new System.Windows.Forms.RadioButton();
            this.ux_fuelPriceLow = new System.Windows.Forms.RadioButton();
            this.ux_allowCreditTrading = new System.Windows.Forms.CheckBox();
            this.ux_co2PriceEstimatesGroupBox.SuspendLayout();
            this.ux_fuelPriceEstimatesGroupBox.SuspendLayout();
            this.SuspendLayout();
            // 
            // ux_fleetAnalysis
            // 
            this.ux_fleetAnalysis.AutoSize = true;
            this.ux_fleetAnalysis.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_fleetAnalysis.Location = new System.Drawing.Point(12, 116);
            this.ux_fleetAnalysis.Name = "ux_fleetAnalysis";
            this.ux_fleetAnalysis.Size = new System.Drawing.Size(187, 17);
            this.ux_fleetAnalysis.TabIndex = 9;
            this.ux_fleetAnalysis.Text = "Perform Fleet Analysis Calculations";
            // 
            // ux_consumerBenefitsScale
            // 
            this.ux_consumerBenefitsScale.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_consumerBenefitsScale.Enabled = false;
            this.ux_consumerBenefitsScale.Location = new System.Drawing.Point(236, 136);
            this.ux_consumerBenefitsScale.MaxLength = 3;
            this.ux_consumerBenefitsScale.Multiline = true;
            this.ux_consumerBenefitsScale.Name = "ux_consumerBenefitsScale";
            this.ux_consumerBenefitsScale.Size = new System.Drawing.Size(56, 18);
            this.ux_consumerBenefitsScale.TabIndex = 11;
            this.ux_consumerBenefitsScale.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // ux_scaleConsumerBenefits
            // 
            this.ux_scaleConsumerBenefits.AutoSize = true;
            this.ux_scaleConsumerBenefits.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_scaleConsumerBenefits.Location = new System.Drawing.Point(12, 136);
            this.ux_scaleConsumerBenefits.Name = "ux_scaleConsumerBenefits";
            this.ux_scaleConsumerBenefits.Size = new System.Drawing.Size(225, 17);
            this.ux_scaleConsumerBenefits.TabIndex = 10;
            this.ux_scaleConsumerBenefits.Text = "Scale Consumer Benefits (default is 100%):";
            // 
            // ux_co2PriceEstimatesGroupBox
            // 
            this.ux_co2PriceEstimatesGroupBox.Controls.Add(this.ux_co2PriceVeryHigh);
            this.ux_co2PriceEstimatesGroupBox.Controls.Add(this.ux_co2PriceHigh);
            this.ux_co2PriceEstimatesGroupBox.Controls.Add(this.ux_co2PriceAverage);
            this.ux_co2PriceEstimatesGroupBox.Controls.Add(this.ux_co2PriceLow);
            this.ux_co2PriceEstimatesGroupBox.Location = new System.Drawing.Point(8, 48);
            this.ux_co2PriceEstimatesGroupBox.Name = "ux_co2PriceEstimatesGroupBox";
            this.ux_co2PriceEstimatesGroupBox.Size = new System.Drawing.Size(248, 40);
            this.ux_co2PriceEstimatesGroupBox.TabIndex = 13;
            this.ux_co2PriceEstimatesGroupBox.TabStop = false;
            this.ux_co2PriceEstimatesGroupBox.Text = "CO2 Price Estimates";
            // 
            // ux_co2PriceVeryHigh
            // 
            this.ux_co2PriceVeryHigh.AutoSize = true;
            this.ux_co2PriceVeryHigh.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_co2PriceVeryHigh.Location = new System.Drawing.Point(168, 16);
            this.ux_co2PriceVeryHigh.Name = "ux_co2PriceVeryHigh";
            this.ux_co2PriceVeryHigh.Size = new System.Drawing.Size(70, 17);
            this.ux_co2PriceVeryHigh.TabIndex = 3;
            this.ux_co2PriceVeryHigh.Text = "Very High";
            // 
            // ux_co2PriceHigh
            // 
            this.ux_co2PriceHigh.AutoSize = true;
            this.ux_co2PriceHigh.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_co2PriceHigh.Location = new System.Drawing.Point(120, 16);
            this.ux_co2PriceHigh.Name = "ux_co2PriceHigh";
            this.ux_co2PriceHigh.Size = new System.Drawing.Size(46, 17);
            this.ux_co2PriceHigh.TabIndex = 2;
            this.ux_co2PriceHigh.Text = "High";
            // 
            // ux_co2PriceAverage
            // 
            this.ux_co2PriceAverage.AutoSize = true;
            this.ux_co2PriceAverage.Checked = true;
            this.ux_co2PriceAverage.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_co2PriceAverage.Location = new System.Drawing.Point(56, 16);
            this.ux_co2PriceAverage.Name = "ux_co2PriceAverage";
            this.ux_co2PriceAverage.Size = new System.Drawing.Size(64, 17);
            this.ux_co2PriceAverage.TabIndex = 1;
            this.ux_co2PriceAverage.TabStop = true;
            this.ux_co2PriceAverage.Text = "Average";
            // 
            // ux_co2PriceLow
            // 
            this.ux_co2PriceLow.AutoSize = true;
            this.ux_co2PriceLow.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_co2PriceLow.Location = new System.Drawing.Point(8, 16);
            this.ux_co2PriceLow.Name = "ux_co2PriceLow";
            this.ux_co2PriceLow.Size = new System.Drawing.Size(44, 17);
            this.ux_co2PriceLow.TabIndex = 0;
            this.ux_co2PriceLow.Text = "Low";
            // 
            // ux_fuelPriceEstimatesGroupBox
            // 
            this.ux_fuelPriceEstimatesGroupBox.Controls.Add(this.ux_fuelPriceHigh);
            this.ux_fuelPriceEstimatesGroupBox.Controls.Add(this.ux_fuelPriceAverage);
            this.ux_fuelPriceEstimatesGroupBox.Controls.Add(this.ux_fuelPriceLow);
            this.ux_fuelPriceEstimatesGroupBox.Location = new System.Drawing.Point(8, 8);
            this.ux_fuelPriceEstimatesGroupBox.Name = "ux_fuelPriceEstimatesGroupBox";
            this.ux_fuelPriceEstimatesGroupBox.Size = new System.Drawing.Size(176, 40);
            this.ux_fuelPriceEstimatesGroupBox.TabIndex = 12;
            this.ux_fuelPriceEstimatesGroupBox.TabStop = false;
            this.ux_fuelPriceEstimatesGroupBox.Text = "Fuel Price Estimates";
            // 
            // ux_fuelPriceHigh
            // 
            this.ux_fuelPriceHigh.AutoSize = true;
            this.ux_fuelPriceHigh.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_fuelPriceHigh.Location = new System.Drawing.Point(120, 16);
            this.ux_fuelPriceHigh.Name = "ux_fuelPriceHigh";
            this.ux_fuelPriceHigh.Size = new System.Drawing.Size(46, 17);
            this.ux_fuelPriceHigh.TabIndex = 2;
            this.ux_fuelPriceHigh.Text = "High";
            // 
            // ux_fuelPriceAverage
            // 
            this.ux_fuelPriceAverage.AutoSize = true;
            this.ux_fuelPriceAverage.Checked = true;
            this.ux_fuelPriceAverage.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_fuelPriceAverage.Location = new System.Drawing.Point(56, 16);
            this.ux_fuelPriceAverage.Name = "ux_fuelPriceAverage";
            this.ux_fuelPriceAverage.Size = new System.Drawing.Size(64, 17);
            this.ux_fuelPriceAverage.TabIndex = 1;
            this.ux_fuelPriceAverage.TabStop = true;
            this.ux_fuelPriceAverage.Text = "Average";
            // 
            // ux_fuelPriceLow
            // 
            this.ux_fuelPriceLow.AutoSize = true;
            this.ux_fuelPriceLow.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_fuelPriceLow.Location = new System.Drawing.Point(8, 16);
            this.ux_fuelPriceLow.Name = "ux_fuelPriceLow";
            this.ux_fuelPriceLow.Size = new System.Drawing.Size(44, 17);
            this.ux_fuelPriceLow.TabIndex = 0;
            this.ux_fuelPriceLow.Text = "Low";
            // 
            // ux_allowCreditTrading
            // 
            this.ux_allowCreditTrading.AutoSize = true;
            this.ux_allowCreditTrading.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_allowCreditTrading.Location = new System.Drawing.Point(12, 96);
            this.ux_allowCreditTrading.Name = "ux_allowCreditTrading";
            this.ux_allowCreditTrading.Size = new System.Drawing.Size(118, 17);
            this.ux_allowCreditTrading.TabIndex = 7;
            this.ux_allowCreditTrading.Text = "Allow Credit Trading";
            // 
            // OpModesPanel
            // 
            this.Controls.Add(this.ux_consumerBenefitsScale);
            this.Controls.Add(this.ux_fleetAnalysis);
            this.Controls.Add(this.ux_scaleConsumerBenefits);
            this.Controls.Add(this.ux_fuelPriceEstimatesGroupBox);
            this.Controls.Add(this.ux_co2PriceEstimatesGroupBox);
            this.Controls.Add(this.ux_allowCreditTrading);
            this.MinimumSize = new System.Drawing.Size(440, 0);
            this.Name = "OpModesPanel";
            this.Size = new System.Drawing.Size(440, 170);
            this.ux_co2PriceEstimatesGroupBox.ResumeLayout(false);
            this.ux_co2PriceEstimatesGroupBox.PerformLayout();
            this.ux_fuelPriceEstimatesGroupBox.ResumeLayout(false);
            this.ux_fuelPriceEstimatesGroupBox.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        #endregion

        void PostInitialize()
        {
            // initialize check-changes
            this.AutoInitializeCheckChangesDetector(this.Controls);
            // add event handlers for certain controls
            this.ux_scaleConsumerBenefits.CheckedChanged += new EventHandler(this.ScaleConsumerBenefits_CheckedChanged);
        }
        void ScaleConsumerBenefits_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_consumerBenefitsScale.Enabled = this.ux_scaleConsumerBenefits.Checked;
        }

        /// <summary>
        /// Sets up the initial states of the controls for the <see cref="OpModesPanel"/> instance based on the specified
        /// operating modes.
        /// </summary>
        /// <param name="operatingModes">The operating modes settings for the modeling system.</param>
        /// <param name="minYear">The minimum model year available for modeling.</param>
        /// <param name="maxYear">The maximum model year available for modeling.</param>
        public void SetInitialState(OperatingModes operatingModes, int minYear, int maxYear)
        {
            // copy op modes
            this._operatingModes = operatingModes;

            // set initial states
            this.ux_allowCreditTrading               .Checked =  operatingModes.AllowCreditTrading;
            this.ux_fleetAnalysis                    .Checked =  operatingModes.FleetAnalysis;
            if      (operatingModes.FuelPriceEstimates == Estimates.Low     ) { this.ux_fuelPriceLow    .Checked = true; }
            else if (operatingModes.FuelPriceEstimates == Estimates.High    ) { this.ux_fuelPriceHigh   .Checked = true; }
            else                                                              { this.ux_fuelPriceAverage.Checked = true; }
            if      (operatingModes.CO2Estimates       == Estimates.Low     ) { this.ux_co2PriceLow     .Checked = true; }
            else if (operatingModes.CO2Estimates       == Estimates.High    ) { this.ux_co2PriceHigh    .Checked = true; }
            else if (operatingModes.CO2Estimates       == Estimates.VeryHigh) { this.ux_co2PriceVeryHigh.Checked = true; }
            else                                                              { this.ux_co2PriceAverage .Checked = true; }
            this.ux_scaleConsumerBenefits            .Checked = (operatingModes.ConsumerBenefitsScale != 1);
            this.ux_consumerBenefitsScale            .Text    = (operatingModes.ConsumerBenefitsScale * 100).ToString("0");

            // register numeric text controls
            this.RegisterNumericTextControl(this.ux_consumerBenefitsScale, 100, 1, 100,
                "The Consumer Benefits Scale should be between {MIN} and {MAX}.", true, "0");

            // call save in base to reset changes
            base.SaveChanges();
        }

        /// <summary>
        /// Commits the most recently made changes to the internal <see cref="OperatingModes"/> structure.
        /// </summary>
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   // some settings chaged -- continue with save
                this._operatingModes.AllowCreditTrading    = this.ux_allowCreditTrading.Checked;
                this._operatingModes.FleetAnalysis         = this.ux_fleetAnalysis .Checked;
                this._operatingModes.FuelPriceEstimates    = (this.ux_fuelPriceLow .Checked   ) ? Estimates.Low  :
                                                             (this.ux_fuelPriceHigh.Checked   ) ? Estimates.High :
                                                                                                  Estimates.Average;
                this._operatingModes.CO2Estimates          = (this.ux_co2PriceLow.Checked     ) ? Estimates.Low      :
                                                             (this.ux_co2PriceHigh.Checked    ) ? Estimates.High     :
                                                             (this.ux_co2PriceVeryHigh.Checked) ? Estimates.VeryHigh :
                                                                                                  Estimates.Average;
                this._operatingModes.ConsumerBenefitsScale = (!this.ux_scaleConsumerBenefits.Checked) ? 1 :
                                                              Interaction.GetDouble(this.ux_consumerBenefitsScale.Text) / 100;
                //
                base.SaveChanges();
            }
        }

        #endregion


        #region /*** Variables ***/

        #region /* UI Variables */

        // compliance settings
        CheckBox ux_allowCreditTrading;
        CheckBox    ux_fleetAnalysis;
        GroupBox    ux_fuelPriceEstimatesGroupBox;
        RadioButton ux_fuelPriceLow;
        RadioButton ux_fuelPriceAverage;
        RadioButton ux_fuelPriceHigh;
        GroupBox    ux_co2PriceEstimatesGroupBox;
        RadioButton ux_co2PriceLow;
        RadioButton ux_co2PriceAverage;
        RadioButton ux_co2PriceHigh;
        RadioButton ux_co2PriceVeryHigh;
        CheckBox    ux_scaleConsumerBenefits;
        TextBox     ux_consumerBenefitsScale;
        // technology settings
        // supplemental settings

        #endregion


        /// <summary>Represents the operating modes settings for the modeling system.</summary>
        OperatingModes _operatingModes;

        #endregion

    }
}
