using System;
using Volpe.Cafe.Data;
using Volpe.Cafe.Settings;

namespace Volpe.Cafe.Model
{
    /// <summary>
    /// Provides a standard interface containing modeling progress information.
    /// </summary>
    public interface IModelingProgress
    {

        #region /*** Properties ***/

        /// <summary>Gets the progress string to display in the UI.  This value may be null.</summary>
        string ProgressString { get; }
        /// <summary>Gets the scenario currently being analyzed by the modeling system.  This value may be null.</summary>
        Scenario Scenario { get; }
        /// <summary>Gets the model year currently being analyzed by the modeling system.  This value may be null.</summary>
        ModelYear ModelYear { get; }
        /// <summary>Gets the manufacturer currently being analyzed by the modeling system.  This value may be null.</summary>
        Manufacturer Manufacturer { get; }
        /// <summary>Gets or sets additional modeling progress information associated with the <see cref="IModelingProgress"/>
        ///   implementation.  This value may be null.</summary>
        object AdditionalInfo { get; set; }

        #endregion

    }
}
