using System;
using Volpe.Cafe.Data;

namespace Volpe.Cafe.Model
{
    /// <summary>
    /// Contains event data for when a modeling session starts or stops.
    /// </summary>
    [Serializable]
    public class ModelingEventArgs : EventArgs
    {

        #region /*** Constructors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="ModelingEventArgs"/> class using the specified parameters.
        /// </summary>
        /// <param name="state">The state of the modeling process for the session responsible for generating this event.</param>
        public ModelingEventArgs(ModelingState state) : base()
        {
            this._state = state;
        }

        #endregion


        #region /*** Methods ***/

        /// <summary>
        /// Returns the string representation of this <see cref="ModelingEventArgs"/> instance.
        /// </summary>
        /// <returns>The string representation of the <see cref="ModelingEventArgs"/> instance.</returns>
        public override string ToString()
        {
            return "State=" + this._state;
        }

        #endregion


        #region /*** Properties ***/

        /// <summary>Gets the state of the modeling process for the session responsible for generating this event.</summary>
        public ModelingState State { get { return this._state; } }

        #endregion


        #region /*** Variables ***/

        ModelingState _state;

        #endregion

    }
}
