﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe
{
    /// <summary>
    /// Provides infromation for the various known vehicle technology classes.
    /// </summary>
    [Serializable]
    public sealed class TechnologyClasses
    {

        #region /*** Variables ***/

        /// <summary>Represent an array of available technology classes.</summary>
        public static readonly string[] ClassNames = new string[] {
            "SmallCar",
            "MedCar",
            "SmallSUV",
            "MedSUV",
            "Pickup",
            "Van2b3",
            "Truck2b3"
        };
        /// <summary>Represent an array of available engine technology classes.</summary>
        public static readonly string[] EngineClassNames = new string[] {
            "2C1B",
            "3C1B",
            "4C1B",
            "4C2B",
            "5C1B",
            "6C1B",
            "6C1B_ohv",
            "6C2B",
            "6C2B_ohv",
            "8C2B",
            "8C2B_ohv",
            "10C2B",
            "10C2B_ohv",
            "12C2B",
            "12C4B",
            "16C4B"
        };

        /// <summary>Specifies the total number of available technology classes.</summary>
        public static readonly int ClassCount = ClassNames.Length;
        /// <summary>Specifies the total number of available engine technology classes.</summary>
        public static readonly int EngineClassCount = EngineClassNames.Length;

        #endregion

    }
}
