using System;

namespace Volpe.Cafe.UI
{
    /// <summary>
    /// Specifies the prompt options that the user can select in a prompt.
    /// </summary>
    public enum PromptOption : int
    {
        /// <summary>Specifies that no prompt options should be displayed to the user.</summary>
        None = 0,
        /// <summary>Specifies that only the OK prompt should be displayed.</summary>
        Ok = 1,
        /// <summary>Specifies that the OK/Cancel prompts should be displayed.</summary>
        OkCancel = 2,
        /// <summary>Specifies that the Yes/No prompts should be displayed.</summary>
        YesNo = 3,
        /// <summary>Specifies that the Yes/No/Cancel prompts should be displayed.</summary>
        YesNoCancel = 4
    }

    /// <summary>
    /// Specifies the prompt option that the user has selected after the prompt has been closed.
    /// </summary>
    public enum PromptResult : int
    {
        /// <summary>Specifies that the user did not select a prompt option.</summary>
        /// <remarks>This prompt result can occur if a prompt event was generated, but was not displayed to the user.</remarks>
        None = 0,
        /// <summary>Specifies that the user has selected the OK prompt option.</summary>
        /// <remarks>This prompt result can occur if, for example, the user clicks the OK button in a message dialog box.</remarks>
        Ok = 1,
        /// <summary>Specifies that the user has selected the Cancel prompt option.</summary>
        /// <remarks>This prompt result can occur if, for example, the user clicks the Cancel button in a message dialog box.</remarks>
        Cancel = 2,
        /// <summary>Specifies that the user has selected the Yes prompt option.</summary>
        /// <remarks>This prompt result can occur if, for example, the user clicks the Yes button in a message dialog box.</remarks>
        Yes = 3,
        /// <summary>Specifies that the user has selected the No prompt option.</summary>
        /// <remarks>This prompt result can occur if, for example, the user clicks the No button in a message dialog box.</remarks>
        No = 4
    }

}
