using System;

namespace Volpe.Cafe.UI
{
    /// <summary>
    /// Contains event data for generated prompt messages.
    /// </summary>
    public class PromptEventArgs : EventArgs
    {

        #region /*** Constructors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="PromptEventArgs"/> class, using the specified message title, message
        /// body, and the prompt options the user can select.
        /// </summary>
        /// <param name="title">The message title of the prompt.</param>
        /// <param name="message">The message body of the prompt.</param>
        /// <param name="promptOption">The prompt options the user can select.</param>
        public PromptEventArgs(string title, string message, PromptOption promptOption) : base()
        {
            this._title        = title;
            this._message      = message;
            this._promptOption = promptOption;
            this._promptResult = PromptResult.None;
        }

        #endregion


        #region /*** Methods ***/

        /// <summary>
        /// Returns the string representation of this <see cref="PromptEventArgs"/> instance.
        /// </summary>
        /// <returns>The string representation of the <see cref="PromptEventArgs"/> instance.</returns>
        public override string ToString()
        {
            return this._title + " - " + this._message;
        }

        #endregion


        #region /*** Properties ***/

        /// <summary>Gets the message title of the prompt.</summary>
        public string Title { get { return this._title; } }
        /// <summary>Gets the actual messages of the prompt.</summary>
        public string Message { get { return this._message; } }
        /// <summary>Gets the prompt options the user can select.</summary>
        public PromptOption PromptOption { get { return this._promptOption; } }
        /// <summary>Gets or sets the user response to a message prompt.</summary>
        public PromptResult PromptResult { get { return this._promptResult; } set { this._promptResult = value; } }

        #endregion


        #region /*** Variables ***/

        string _title;
        string _message;
        PromptOption _promptOption;
        PromptResult _promptResult;

        #endregion

    }
}
