#region << Using Directives >>
using System;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Drawing;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Threading;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
using Volpe.Cafe.Model.MonteCarlo;
using Volpe.Cafe.Model.Optimization;
using Volpe.Cafe.Settings;
#endregion
namespace Volpe.Cafe.Ui
{
    public class Cafe2d : System.Windows.Forms.Form
    {
        #region 
        public static Cafe2d CreateInstance()
        {
            if (Cafe2d._instance == null)
            {
                Cafe2d._startupPath = Application.StartupPath;
                Cafe2d._dataPath = Path.GetDirectoryName(Cafe2d._startupPath) + "\\data";
                if (!Directory.Exists(Cafe2d._dataPath))
                {
                    Cafe2d._dataPath = "";
                }
                Cafe2d._outputPath = Path.GetDirectoryName(Cafe2d._startupPath) + "\\output";
                if (!Directory.Exists(Cafe2d._outputPath))
                {
                    Directory.CreateDirectory(Cafe2d._outputPath);
                }
                Cafe2d._themesPath = Path.GetDirectoryName(Cafe2d._startupPath) + "\\themes";
                if (!Directory.Exists(Cafe2d._themesPath))
                {
                    Cafe2d._themesPath = "";
                }
                Cafe2d._assemblies = new ArrayList();
                Cafe2d._cmpTypes   = new ArrayList();
                Cafe2d._cmpTypes.Add(typeof(Compliance));
                Cafe2d._cmpTypes.Add(typeof(MaxTechCompliance));
                Cafe2d._cmpTypes.Add(typeof(Optimization));
                Cafe2d._cmpTypes.Add(typeof(MonteCarlo));
                Cafe2d._instance = new Cafe2d();
            }
            return Cafe2d._instance;
        }
        private static void ParseAssembly(Assembly assembly)
        {
            Type[] types = assembly.GetTypes();
            string IComplianceType_FullName = typeof(ICompliance).FullName;
            for (int i = 0; i < types.Length; i++)
            {
                Type[] interfaces = types[i].GetInterfaces();
                bool isCompliance = false;
                ModelDescriptionAttribute attr = (ModelDescriptionAttribute)Attribute.GetCustomAttribute(types[i],
                    typeof(ModelDescriptionAttribute));
                if (!types[i].IsAbstract && attr != null)
                {   
                    for (int j = 0; j < interfaces.Length; j++)
                    {
                        if (interfaces[j].FullName == IComplianceType_FullName)
                        {
                            isCompliance = true;
                            break;      
                        }
                    }
                }
                if (isCompliance) { Cafe2d._cmpTypes.Add(types[i]); }
            }
        }
        protected Cafe2d()
        {
            this.InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Cafe2d));
            this.ux_mainMenu = new System.Windows.Forms.MainMenu();
            this.ux_fileMenu = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_NewSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_OpenSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CloseSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CloseAll = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveSessionAs = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveAll = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator1 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_StartModeling = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_StopModeling = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_GenerateReports = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CancelReports = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator3 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Exit = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_InputFileLocation = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_OutputLocation = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Separator1 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Realtime = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_High = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Normal = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Low = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Paused = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Refresh = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_ModelingSettings = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_About = new System.Windows.Forms.MenuItem();
            this.ux_statusBar = new System.Windows.Forms.StatusBar();
            this.ux_statusPanel = new System.Windows.Forms.StatusBarPanel();
            this.ux_versionPanel = new System.Windows.Forms.StatusBarPanel();
            this.ux_toolbar = new System.Windows.Forms.Panel();
            this.ux_toolbar_StopModeling = new Volpe.Cafe.Ui.ToolbarButton();
            this.ux_toolbar_StartModeling = new Volpe.Cafe.Ui.ToolbarButton();
            this.ux_toolbar_ModelingSettings = new Volpe.Cafe.Ui.ToolbarButton();
            this.ux_toolbar_SaveSession = new Volpe.Cafe.Ui.ToolbarButton();
            this.ux_toolbar_OpenSession = new Volpe.Cafe.Ui.ToolbarButton();
            this.ux_toolbar_NewSession = new Volpe.Cafe.Ui.ToolbarButton();
            ((System.ComponentModel.ISupportInitialize)(this.ux_statusPanel)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.ux_versionPanel)).BeginInit();
            this.ux_toolbar.SuspendLayout();
            this.SuspendLayout();
            this.ux_mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_fileMenu,
                                                                                        this.ux_viewMenu,
                                                                                        this.ux_helpMenu});
            this.ux_fileMenu.Index = 0;
            this.ux_fileMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_fileMenu_NewSession,
                                                                                        this.ux_fileMenu_OpenSession,
                                                                                        this.ux_fileMenu_CloseSession,
                                                                                        this.ux_fileMenu_CloseAll,
                                                                                        this.ux_fileMenu_Separator0,
                                                                                        this.ux_fileMenu_SaveSession,
                                                                                        this.ux_fileMenu_SaveSessionAs,
                                                                                        this.ux_fileMenu_SaveAll,
                                                                                        this.ux_fileMenu_Separator1,
                                                                                        this.ux_fileMenu_StartModeling,
                                                                                        this.ux_fileMenu_StopModeling,
                                                                                        this.ux_fileMenu_GenerateReports,
                                                                                        this.ux_fileMenu_CancelReports,
                                                                                        this.ux_fileMenu_Separator3,
                                                                                        this.ux_fileMenu_Exit});
            this.ux_fileMenu.Text = "&File";
            this.ux_fileMenu_NewSession.Index = 0;
            this.ux_fileMenu_NewSession.Shortcut = System.Windows.Forms.Shortcut.CtrlN;
            this.ux_fileMenu_NewSession.Text = "&New Session";
            this.ux_fileMenu_NewSession.Click += new System.EventHandler(this.FileMenu_NewSession_Click);
            this.ux_fileMenu_OpenSession.Index = 1;
            this.ux_fileMenu_OpenSession.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
            this.ux_fileMenu_OpenSession.Text = "&Open Session";
            this.ux_fileMenu_OpenSession.Click += new System.EventHandler(this.FileMenu_OpenSession_Click);
            this.ux_fileMenu_CloseSession.Index = 2;
            this.ux_fileMenu_CloseSession.Shortcut = System.Windows.Forms.Shortcut.CtrlF4;
            this.ux_fileMenu_CloseSession.Text = "&Close Session";
            this.ux_fileMenu_CloseSession.Click += new System.EventHandler(this.FileMenu_CloseSession_Click);
            this.ux_fileMenu_CloseAll.Index = 3;
            this.ux_fileMenu_CloseAll.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftF4;
            this.ux_fileMenu_CloseAll.Text = "Clos&e All";
            this.ux_fileMenu_CloseAll.Click += new System.EventHandler(this.FileMenu_CloseAll_Click);
            this.ux_fileMenu_Separator0.Index = 4;
            this.ux_fileMenu_Separator0.Text = "-";
            this.ux_fileMenu_SaveSession.Index = 5;
            this.ux_fileMenu_SaveSession.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
            this.ux_fileMenu_SaveSession.Text = "&Save Session";
            this.ux_fileMenu_SaveSession.Click += new System.EventHandler(this.FileMenu_SaveSession_Click);
            this.ux_fileMenu_SaveSessionAs.Index = 6;
            this.ux_fileMenu_SaveSessionAs.Text = "Save Session &As...";
            this.ux_fileMenu_SaveSessionAs.Click += new System.EventHandler(this.FileMenu_SaveSessionAs_Click);
            this.ux_fileMenu_SaveAll.Index = 7;
            this.ux_fileMenu_SaveAll.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftS;
            this.ux_fileMenu_SaveAll.Text = "Save A&ll";
            this.ux_fileMenu_SaveAll.Click += new System.EventHandler(this.FileMenu_SaveAll_Click);
            this.ux_fileMenu_Separator1.Index = 8;
            this.ux_fileMenu_Separator1.Text = "-";
            this.ux_fileMenu_StartModeling.Index = 9;
            this.ux_fileMenu_StartModeling.Shortcut = System.Windows.Forms.Shortcut.CtrlM;
            this.ux_fileMenu_StartModeling.Text = "Start &Modeling";
            this.ux_fileMenu_StartModeling.Click += new System.EventHandler(this.FileMenu_StartModeling_Click);
            this.ux_fileMenu_StopModeling.Index = 10;
            this.ux_fileMenu_StopModeling.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftM;
            this.ux_fileMenu_StopModeling.Text = "Stop Modeling";
            this.ux_fileMenu_StopModeling.Click += new System.EventHandler(this.FileMenu_StopModeling_Click);
            this.ux_fileMenu_GenerateReports.Index = 11;
            this.ux_fileMenu_GenerateReports.Shortcut = System.Windows.Forms.Shortcut.CtrlR;
            this.ux_fileMenu_GenerateReports.Text = "Generate &Reports";
            this.ux_fileMenu_GenerateReports.Click += new System.EventHandler(this.FileMenu_GenerateReports_Click);
            this.ux_fileMenu_CancelReports.Index = 12;
            this.ux_fileMenu_CancelReports.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftR;
            this.ux_fileMenu_CancelReports.Text = "Cancel Reports";
            this.ux_fileMenu_CancelReports.Click += new System.EventHandler(this.FileMenu_CancelReports_Click);
            this.ux_fileMenu_Separator3.Index = 13;
            this.ux_fileMenu_Separator3.Text = "-";
            this.ux_fileMenu_Exit.Index = 14;
            this.ux_fileMenu_Exit.Shortcut = System.Windows.Forms.Shortcut.AltF4;
            this.ux_fileMenu_Exit.Text = "E&xit";
            this.ux_fileMenu_Exit.Click += new System.EventHandler(this.FileMenu_Exit_Click);
            this.ux_viewMenu.Index = 1;
            this.ux_viewMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_toolsMenu_ModelingSettings,
                                                                                        this.ux_viewMenu_Separator0,
                                                                                        this.ux_viewMenu_InputFileLocation,
                                                                                        this.ux_viewMenu_OutputLocation,
                                                                                        this.ux_viewMenu_Separator1,
                                                                                        this.ux_viewMenu_UpdateSpeed,
                                                                                        this.ux_viewMenu_Refresh});
            this.ux_viewMenu.Text = "&View";
            this.ux_viewMenu_Separator0.Index = 1;
            this.ux_viewMenu_Separator0.Text = "-";
            this.ux_viewMenu_InputFileLocation.Index = 2;
            this.ux_viewMenu_InputFileLocation.Text = "&Input File Location(s)";
            this.ux_viewMenu_InputFileLocation.Click += new System.EventHandler(this.ViewMenu_InputFileLocation_Click);
            this.ux_viewMenu_OutputLocation.Index = 3;
            this.ux_viewMenu_OutputLocation.Text = "&Output Location";
            this.ux_viewMenu_OutputLocation.Click += new System.EventHandler(this.ViewMenu_OutputLocation_Click);
            this.ux_viewMenu_Separator1.Index = 4;
            this.ux_viewMenu_Separator1.Text = "-";
            this.ux_viewMenu_UpdateSpeed.Index = 5;
            this.ux_viewMenu_UpdateSpeed.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                                    this.ux_viewMenu_UpdateSpeed_Realtime,
                                                                                                    this.ux_viewMenu_UpdateSpeed_High,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Normal,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Low,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Separator0,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Paused});
            this.ux_viewMenu_UpdateSpeed.Text = "&Update Speed";
            this.ux_viewMenu_UpdateSpeed_Realtime.Index = 0;
            this.ux_viewMenu_UpdateSpeed_Realtime.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Realtime.Text = "&Realtime";
            this.ux_viewMenu_UpdateSpeed_Realtime.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Realtime_Click);
            this.ux_viewMenu_UpdateSpeed_High.Index = 1;
            this.ux_viewMenu_UpdateSpeed_High.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_High.Text = "&High";
            this.ux_viewMenu_UpdateSpeed_High.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_High_Click);
            this.ux_viewMenu_UpdateSpeed_Normal.Index = 2;
            this.ux_viewMenu_UpdateSpeed_Normal.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Normal.Text = "&Normal";
            this.ux_viewMenu_UpdateSpeed_Normal.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Normal_Click);
            this.ux_viewMenu_UpdateSpeed_Low.Index = 3;
            this.ux_viewMenu_UpdateSpeed_Low.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Low.Text = "&Low";
            this.ux_viewMenu_UpdateSpeed_Low.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Low_Click);
            this.ux_viewMenu_UpdateSpeed_Separator0.Index = 4;
            this.ux_viewMenu_UpdateSpeed_Separator0.Text = "-";
            this.ux_viewMenu_UpdateSpeed_Paused.Index = 5;
            this.ux_viewMenu_UpdateSpeed_Paused.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Paused.Text = "&Paused";
            this.ux_viewMenu_UpdateSpeed_Paused.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Paused_Click);
            this.ux_viewMenu_Refresh.Index = 6;
            this.ux_viewMenu_Refresh.Shortcut = System.Windows.Forms.Shortcut.F5;
            this.ux_viewMenu_Refresh.Text = "&Refresh";
            this.ux_viewMenu_Refresh.Click += new System.EventHandler(this.ViewMenu_Refresh_Click);
            this.ux_toolsMenu_ModelingSettings.Index = 0;
            this.ux_toolsMenu_ModelingSettings.Shortcut = System.Windows.Forms.Shortcut.CtrlT;
            this.ux_toolsMenu_ModelingSettings.Text = "Modeling Se&ttings";
            this.ux_toolsMenu_ModelingSettings.Click += new System.EventHandler(this.ToolsMenu_ModelingSettings_Click);
            this.ux_helpMenu.Index = 2;
            this.ux_helpMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_helpMenu_About});
            this.ux_helpMenu.Text = "&Help";
            this.ux_helpMenu_About.Index = 0;
            this.ux_helpMenu_About.Shortcut = System.Windows.Forms.Shortcut.F12;
            this.ux_helpMenu_About.Text = "&About CAFE Model";
            this.ux_helpMenu_About.Click += new System.EventHandler(this.HelpMenu_About_Click);
            this.ux_statusBar.Location = new System.Drawing.Point(0, 411);
            this.ux_statusBar.Name = "ux_statusBar";
            this.ux_statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
                                                                                            this.ux_statusPanel,
                                                                                            this.ux_versionPanel});
            this.ux_statusBar.ShowPanels = true;
            this.ux_statusBar.Size = new System.Drawing.Size(568, 22);
            this.ux_statusBar.TabIndex = 1;
            this.ux_statusPanel.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
            this.ux_statusPanel.Text = "Ready";
            this.ux_statusPanel.Width = 542;
            this.ux_versionPanel.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
            this.ux_versionPanel.Width = 10;
            this.ux_toolbar.Controls.Add(this.ux_toolbar_StopModeling);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_StartModeling);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_ModelingSettings);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_SaveSession);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_OpenSession);
            this.ux_toolbar.Controls.Add(this.ux_toolbar_NewSession);
            this.ux_toolbar.Dock = System.Windows.Forms.DockStyle.Top;
            this.ux_toolbar.Location = new System.Drawing.Point(0, 0);
            this.ux_toolbar.Name = "ux_toolbar";
            this.ux_toolbar.Size = new System.Drawing.Size(568, 32);
            this.ux_toolbar.TabIndex = 3;
            this.ux_toolbar_StopModeling.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StopModeling.BigImage")));
            this.ux_toolbar_StopModeling.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StopModeling.Image")));
            this.ux_toolbar_StopModeling.Location = new System.Drawing.Point(128, 4);
            this.ux_toolbar_StopModeling.Name = "ux_toolbar_StopModeling";
            this.ux_toolbar_StopModeling.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_StopModeling.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StopModeling.SmallImage")));
            this.ux_toolbar_StopModeling.TabIndex = 6;
            this.ux_toolbar_StopModeling.Click += new System.EventHandler(this.Toolbar_StopModeling_Click);
            this.ux_toolbar_StartModeling.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StartModeling.BigImage")));
            this.ux_toolbar_StartModeling.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StartModeling.Image")));
            this.ux_toolbar_StartModeling.Location = new System.Drawing.Point(104, 4);
            this.ux_toolbar_StartModeling.Name = "ux_toolbar_StartModeling";
            this.ux_toolbar_StartModeling.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_StartModeling.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_StartModeling.SmallImage")));
            this.ux_toolbar_StartModeling.TabIndex = 5;
            this.ux_toolbar_StartModeling.Click += new System.EventHandler(this.Toolbar_StartModeling_Click);
            this.ux_toolbar_ModelingSettings.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_ModelingSettings.BigImage")));
            this.ux_toolbar_ModelingSettings.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_ModelingSettings.Image")));
            this.ux_toolbar_ModelingSettings.Location = new System.Drawing.Point(80, 4);
            this.ux_toolbar_ModelingSettings.Name = "ux_toolbar_ModelingSettings";
            this.ux_toolbar_ModelingSettings.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_ModelingSettings.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_ModelingSettings.SmallImage")));
            this.ux_toolbar_ModelingSettings.TabIndex = 4;
            this.ux_toolbar_ModelingSettings.Click += new System.EventHandler(this.Toolbar_ModelingSettings_Click);
            this.ux_toolbar_SaveSession.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_SaveSession.BigImage")));
            this.ux_toolbar_SaveSession.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_SaveSession.Image")));
            this.ux_toolbar_SaveSession.Location = new System.Drawing.Point(52, 4);
            this.ux_toolbar_SaveSession.Name = "ux_toolbar_SaveSession";
            this.ux_toolbar_SaveSession.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_SaveSession.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_SaveSession.SmallImage")));
            this.ux_toolbar_SaveSession.TabIndex = 2;
            this.ux_toolbar_SaveSession.Click += new System.EventHandler(this.Toolbar_SaveSession_Click);
            this.ux_toolbar_OpenSession.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_OpenSession.BigImage")));
            this.ux_toolbar_OpenSession.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_OpenSession.Image")));
            this.ux_toolbar_OpenSession.Location = new System.Drawing.Point(28, 4);
            this.ux_toolbar_OpenSession.Name = "ux_toolbar_OpenSession";
            this.ux_toolbar_OpenSession.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_OpenSession.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_OpenSession.SmallImage")));
            this.ux_toolbar_OpenSession.TabIndex = 1;
            this.ux_toolbar_OpenSession.Click += new System.EventHandler(this.Toolbar_OpenSession_Click);
            this.ux_toolbar_NewSession.BigImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_NewSession.BigImage")));
            this.ux_toolbar_NewSession.Image = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_NewSession.Image")));
            this.ux_toolbar_NewSession.Location = new System.Drawing.Point(4, 4);
            this.ux_toolbar_NewSession.Name = "ux_toolbar_NewSession";
            this.ux_toolbar_NewSession.Size = new System.Drawing.Size(24, 24);
            this.ux_toolbar_NewSession.SmallImage = ((System.Drawing.Image)(resources.GetObject("ux_toolbar_NewSession.SmallImage")));
            this.ux_toolbar_NewSession.TabIndex = 0;
            this.ux_toolbar_NewSession.Click += new System.EventHandler(this.Toolbar_NewSession_Click);
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(568, 433);
            this.Controls.Add(this.ux_toolbar);
            this.Controls.Add(this.ux_statusBar);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.IsMdiContainer = true;
            this.Menu = this.ux_mainMenu;
            this.Name = "Cafe2d";
            this.Text = "CAFE Model";
            this.Load += new System.EventHandler(this.Cafe2d_Load);
            ((System.ComponentModel.ISupportInitialize)(this.ux_statusPanel)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.ux_versionPanel)).EndInit();
            this.ux_toolbar.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == (int)Win32.Messages.WM_CLOSE)
            {
                this.WndProc_WM_CLOSE(ref m);
            }
            else { base.WndProc(ref m); }
        }
        private void WndProc_WM_CLOSE(ref Message m)
        {
            this.FileMenu_CloseAll_Click(this, EventArgs.Empty);
            if (this.MdiChildren.Length == 0) { base.WndProc(ref m); }
        }
        #endregion
        #region 
        private static Assembly Cafe2d_AssemblyResolve(object sender, ResolveEventArgs args)
        {
            for (int i = 0; i < Cafe2d._assemblies.Count; i++)
            {
                Assembly assembly = (Assembly)Cafe2d._assemblies[i];
                if (args.Name == assembly.FullName) { return assembly; }
            }
            return null;
        }
        private void Cafe2d_Load(object sender, System.EventArgs e)
        {
            this.KeyDown += new KeyEventHandler(this.Cafe2d_KeyDown);
            this.MdiChildActivate += new EventHandler(this.Cafe2d_MdiChildActivate);
            this.AddMenuItemEventHandlers(this.ux_mainMenu.MenuItems);
            this.AddToolbarEventHandlers(this.ux_toolbar);
            this.EnableDragDrop();
            this.RefreshSession();
            string exePath = Application.ExecutablePath;
            FileInfo fi = new FileInfo(exePath);
            this.ux_versionPanel.Text = fi.LastWriteTime.ToString("M/dd/yy H:mm:ss");
            this.Show();
            Application.DoEvents();
            if (this._args.HasArgs)
            {
                bool opened = false;
                if (this._args.Open) { opened = this.OpenSession(this._args.OpenPath, this._args.OpenNoPrompt); }
                if (opened)
                {   
                    Session session = this.ActiveSession;
                    ModelingSettings settings = session.Settings;
                    if (this._args.Params_FuelPriceEstimates)
                    {
                        settings.ParametersOverrides.OverrideFuelPriceEstimates = true;
                        settings.ParametersOverrides.FuelPriceEstimates         = this._args.Params_FuelPriceEstimatesValue;
                    }
                    if (this._args.Params_CO2Estimates)
                    {
                        settings.ParametersOverrides.OverrideCO2Estimates = true;
                        settings.ParametersOverrides.CO2Estimates         = this._args.Params_CO2EstimatesValue;
                    }
                    if (this._args.Params_ReboundEffect)
                    {
                        settings.ParametersOverrides.OverrideReboundEffect = true;
                        settings.ParametersOverrides.ReboundEffect         = this._args.Params_ReboundEffectValue;
                    }
                    if (this._args.Params_DiscountRate)
                    {
                        settings.ParametersOverrides.OverrideDiscountRate = true;
                        settings.ParametersOverrides.DiscountRate         = this._args.Params_DiscountRateValue;
                    }
                    if (this._args.Params_VehicleTravelTimeValue)
                    {
                        settings.ParametersOverrides.OverrideVehicleTravelTimeValue = true;
                        settings.ParametersOverrides.VehicleTravelTimeValue         = this._args.Params_VehicleTravelTimeValueValue;
                    }
                    if (this._args.Params_MilitarySecurity)
                    {
                        settings.ParametersOverrides.OverrideMilitarySecurity = true;
                        settings.ParametersOverrides.MilitarySecurity         = this._args.Params_MilitarySecurityValue;
                    }
                    if (this._args.Params_ConsumerBenefits)
                    {
                        settings.ParametersOverrides.ScaleConsumerBenefits = true;
                        settings.ParametersOverrides.ConsumerBenefits      = this._args.Params_ConsumerBenefitsValue;
                    }
                    if ( this._args.Save                     ) { session.SaveSession(this._args.SaveName); }
                    if ( this._args.Close ||  this._args.Exit) { session.Close(); }
                    if (!this._args.Close && !this._args.Exit &&
                        this._args.AutoStartModel            ) { session.StartModeling(); }
                }
                if (this._args.Exit) { this.Close(); return; }
            } 
        }
        private void Cafe2d_KeyDown(object sender, KeyEventArgs e)
        {
        }
        private void Cafe2d_MdiChildActivate(object sender, EventArgs e)
        {
            this._activeSession = (Session)this.ActiveMdiChild;
            this.SetStatus((this._activeSession == null) ? "Ready" : this._activeSession.Status);
            if (this._activeSession != null)
            {
                int refInt = this._activeSession.RefreshInterval;
                this.ViewMenu_UpdateSpeed_SetChecked(
                    refInt == Cafe2d.RefreshIntervalRealtime,
                    refInt == Cafe2d.RefreshIntervalHigh,
                    refInt == Cafe2d.RefreshIntervalNormal,
                    refInt == Cafe2d.RefreshIntervalLow,
                    refInt == Cafe2d.RefreshIntervalPaused);
            }
            this.RefreshSession();
        }
        private void Control_AfterSelect(object sender, EventArgs e)
        {
            int sessionCount = this.Sessions.Length;
            string message =
                (sender == this.ux_fileMenu_NewSession ||
                 sender == this.ux_toolbar_NewSession)       ? "Creates a new CAFE Model Session and displays the Modeling Settings window to the user." :
                (sender == this.ux_fileMenu_OpenSession ||
                 sender == this.ux_toolbar_OpenSession)      ? "Opens an existing CAFE Model Session." :
                (sender == this.ux_fileMenu_CloseSession)    ? "Closes the active CAFE Model Session." :
                (sender == this.ux_fileMenu_CloseAll)        ? "Closes all opened CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveSession ||
                 sender == this.ux_toolbar_SaveSession)      ? "Saves the active CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveSessionAs)   ? "Displays the Save As dialog for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveAll)         ? "Saves all opened CAFE Model Session." :
                (sender == this.ux_fileMenu_StartModeling ||
                 sender == this.ux_toolbar_StartModeling)    ? "Begins the modeling process for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_StopModeling ||
                 sender == this.ux_toolbar_StopModeling)     ? "Suspends the modeling process of the active CAFE Model Session." :
                (sender == this.ux_fileMenu_GenerateReports) ? "Generates modeling reports for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_CancelReports)   ? "Cancels the generating of modeling reports for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_Exit)            ? (sessionCount == 0) ? "Exits the CAFE Model." : "Closes " +
                                                              ((sessionCount == 1) ? "the active CAFE Model Session" :
                                                                                     "all opened CAFE Model Sessions") + " and exits the model." :
                (sender == this.ux_toolsMenu_ModelingSettings ||
                 sender == this.ux_toolbar_ModelingSettings)      ? "Displays the Modeling Settings window, where all modeling options and settings can be configured." :
                (sender == this.ux_viewMenu_InputFileLocation)    ? "Browses the location of the input data files used to make this Session." :
                (sender == this.ux_viewMenu_OutputLocation)       ? "Browses the location where the output files and reports of the Session are written to." :
                (sender == this.ux_viewMenu_UpdateSpeed)          ? "Selects how often to refresh the Session when it is running." :
                (sender == this.ux_viewMenu_UpdateSpeed_Realtime) ? "Refreshes the Session eight times per second." :
                (sender == this.ux_viewMenu_UpdateSpeed_High)     ? "Refreshes the Session twice per second." :
                (sender == this.ux_viewMenu_UpdateSpeed_Normal)   ? "Refreshes the Session every two seconds." :
                (sender == this.ux_viewMenu_UpdateSpeed_Low)      ? "Refreshes the Session every four seconds." :
                (sender == this.ux_viewMenu_UpdateSpeed_Paused)   ? "Does not automatically refresh the Session." :
                (sender == this.ux_viewMenu_Refresh)              ? "Forces the Session to refresh now, regardless of the Update Speed setting." :
                (sender == this.ux_helpMenu_About)        ? "Displays product information about the CAFE Model." :
                null;
            if (message != null && message.Length > 0 &&
                (((sender is Control) && !((Control)sender).Enabled) ||
                 ((sender is MenuItem) && !((MenuItem)sender).Enabled)))
            {
                message = "When enabled, " + (char)(message[0] + 32) + message.Remove(0, 1);
            }
            this.ux_statusBar.Text = message;
            this.ux_statusBar.ShowPanels = (message == null);
        }
        private void Control_AfterClick(object sender, EventArgs e)
        {
            this.ux_statusBar.Text = null;
            this.ux_statusBar.ShowPanels = true;
        }
        private void Control_AfterMouseClick(object sender, MouseEventArgs e)
        {
            this.Control_AfterClick(sender, e);
        }
        private void Cafe2d_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        private void Cafe2d_DragDrop(object sender, DragEventArgs e)
        {
            string[] paths = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            paths = this.GetDrapDropFiles(paths, 1);    
            for (int i = 0; i < paths.Length; i++)
            {
                string ext = Path.GetExtension(paths[i]).Trim().ToUpper();
                if (ext == ".CMSD")
                {   
                    this.OpenSession(paths[i], false);
                }
            }
        }
        private string[] GetDrapDropFiles(string[] paths, int recurseDepth)
        {
            ArrayList files = new ArrayList(16);
            for (int i = 0, pathsCount = paths.Length; i < pathsCount; i++)
            {
                if (Directory.Exists(paths[i]) && recurseDepth > 0)
                {   
                    files.AddRange(this.GetDrapDropFiles(Directory.GetFiles(paths[i]), recurseDepth - 1));
                }
                else if (File.Exists(paths[i]))
                {   
                    files.Add(paths[i]);
                }
            }
            return (string[])files.ToArray(typeof(string));
        }
        #endregion
        #region 
        private void FileMenu_NewSession_Click(object sender, System.EventArgs e)
        {
            this.NewSession(false, null);
        }
        private void FileMenu_OpenSession_Click(object sender, System.EventArgs e)
        {
            this.OpenSession(null, false);
        }
        private void FileMenu_CloseSession_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.CloseSession();
        }
        private void FileMenu_CloseAll_Click(object sender, System.EventArgs e)
        {
            Form[] sessions = this.MdiChildren;
            this._cancelCloseAll = false;
            for (int i = sessions.Length - 1; i >= 0; i--)
            {
                if (this._cancelCloseAll) { break; }
                sessions[i].Activate();
                ((Session)sessions[i]).CloseSession();
                if (!sessions[i].IsDisposed) { this._cancelCloseAll = true; }
            }
        }
        private void FileMenu_SaveSession_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.SaveSession();
        }
        private void FileMenu_SaveSessionAs_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            this.ActiveSession.SaveSessionAs();
            this.EnableDragDrop();
        }
        private void FileMenu_SaveAll_Click(object sender, System.EventArgs e)
        {
            int activeSessionIndex = this.ActiveSessionIndex;
            Form[] sessions = this.MdiChildren;
            this._cancelSave = false;
            for (int i = 0; i < sessions.Length; i++)
            {
                if (this._cancelSave) { break; }
                sessions[i].Activate();
                this._cancelSave = !((Session)sessions[i]).SaveSession();
            }
            this.ActiveSessionIndex = activeSessionIndex;
        }
        private void FileMenu_StartModeling_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.StartModeling();
        }
        private void FileMenu_StopModeling_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.StopModeling();
        }
        private void FileMenu_GenerateReports_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.GenerateReports();
        }
        private void FileMenu_CancelReports_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.CancelReports();
        }
        private void FileMenu_Exit_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }
        #endregion
        #region 
        private void ViewMenu_NextSession_Click(object sender, System.EventArgs e)
        {
            int index = this.ActiveSessionIndex;
            if (index != -1)
            {
                index++;
                if (index >= this.MdiChildren.Length)
                {
                    index = 0;
                }
                this.ActiveSessionIndex = index;
            }
        }
        private void ViewMenu_PreviousSession_Click(object sender, System.EventArgs e)
        {
            int index = this.ActiveSessionIndex;
            if (index != -1)
            {
                index--;
                if (index < 0)
                {
                    index = this.MdiChildren.Length - 1;
                }
                this.ActiveSessionIndex = index;
            }
        }
        private void ViewMenu_InputFileLocation_Click(object sender, System.EventArgs e)
        {
            InputSettings settings = this.ActiveSession.Settings.InputSettings;
            string[] paths = new string[] {
                                              settings.MarketDataFile,
                                              settings.TechnologiesFile,
                                              settings.ParametersFile,
                                              settings.EmissionsRatesFile,
                                              settings.ScenariosFile
                                          };
            StringCollection uniquePaths = new StringCollection();
            for (int i = 0; i < paths.Length; i++)
            {
                if (paths[i] != "")
                {
                    string path = Path.GetDirectoryName(paths[i]);
                    if (!uniquePaths.Contains(path))
                    {
                        uniquePaths.Add(path);
                    }
                }
            }
            this.ExplorePaths(uniquePaths);
        }
        private void ViewMenu_OutputLocation_Click(object sender, System.EventArgs e)
        {
            this.ExplorePaths(this.ActiveSession.Settings.OutputSettings.OutputPath);
        }
        private void ViewMenu_ExcelApplication_Click(object sender, System.EventArgs e)
        {
            if (sender is Button && ((Button)sender).Text == "Hide Excel Application")
            {
                ((Button)sender).FindForm().Close();
                Global.HideExcelApplication();
            }
            else if (Global.ShowExcelApplication())
            {
                Form f = new Form();
                f.Size = new Size(Screen.PrimaryScreen.Bounds.Width, 160);
                f.Location = new Point(0, 0);
                f.TopMost = true;
                f.FormBorderStyle = FormBorderStyle.None;
                f.ShowInTaskbar = false;
                f.ControlBox = false;
                Button b = new Button();
                b.Text = "Hide Excel Application";
                b.Font = new Font(f.Font.FontFamily, 16, FontStyle.Bold);
                b.ForeColor = Color.Navy;
                b.Size = new Size(288, 48);
                b.Location = new Point((f.Width - b.Width) / 2, (f.Height - b.Height) / 2);
                b.Click += new EventHandler(this.ViewMenu_ExcelApplication_Click);
                f.Controls.Add(b);
                f.Show();
                f.Location = new Point(0, 0);
            }
        }
        private void ViewMenu_UpdateSpeed_Realtime_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalRealtime;
            this.ViewMenu_UpdateSpeed_SetChecked(true, false, false, false, false);
        }
        private void ViewMenu_UpdateSpeed_High_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalHigh;
            this.ViewMenu_UpdateSpeed_SetChecked(false, true, false, false, false);
        }
        private void ViewMenu_UpdateSpeed_Normal_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalNormal;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, true, false, false);
        }
        private void ViewMenu_UpdateSpeed_Low_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalLow;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, false, true, false);
        }
        private void ViewMenu_UpdateSpeed_Paused_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalPaused;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, false, false, true);
        }
        private void ViewMenu_UpdateSpeed_SetChecked(bool realtime, bool high, bool normal, bool low, bool paused)
        {
            this.ux_viewMenu_UpdateSpeed_Realtime.Checked = realtime;
            this.ux_viewMenu_UpdateSpeed_High    .Checked = high;
            this.ux_viewMenu_UpdateSpeed_Normal  .Checked = normal;
            this.ux_viewMenu_UpdateSpeed_Low     .Checked = low;
            this.ux_viewMenu_UpdateSpeed_Paused  .Checked = paused;
        }
        private void ViewMenu_Refresh_Click(object sender, System.EventArgs e)
        {
            Control.ControlCollection toolbarControls = this.ux_toolbar.Controls;
            int toolbarControlCount = toolbarControls.Count;
            for (int i = 0; i < toolbarControlCount; i++)
            {
                if (toolbarControls[i] is ToolbarButton)
                {
                    ((ToolbarButton)toolbarControls[i]).Refresh();
                }
            }
            this.Control_AfterClick(this, EventArgs.Empty);
            if (this._activeSession != null)
            {
                this._activeSession.RefreshSession();
            }
        }
        #endregion
        #region 
        private void ToolsMenu_ModelingSettings_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            Session session = this.ActiveSession;
            ManageModelingSettings mms = new ManageModelingSettings(session);
            mms.ShowDialog();
            this.RefreshSession();
            this.EnableDragDrop();
        }
        #endregion
        #region 
        private void HelpMenu_HelpContents_Click(object sender, System.EventArgs e)
        {
        }
        private void HelpMenu_SourceCode_Click(object sender, System.EventArgs e)
        {
            string docFile = Cafe2d.StartupPath + "\\..\\src\\CAFE Model.chm";
            if (File.Exists(docFile))
            {
                Process.Start(docFile);
            }
        }
        private void HelpMenu_About_Click(object sender, System.EventArgs e)
        {
            Program.ShowAbout();
        }
        #endregion
        #region 
        private void Toolbar_NewSession_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_NewSession_Click(sender, e);
        }
        private void Toolbar_OpenSession_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_OpenSession_Click(sender, e);
        }
        private void Toolbar_SaveSession_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_SaveSession_Click(sender, e);
        }
        private void Toolbar_ModelingSettings_Click(object sender, System.EventArgs e)
        {
            this.ToolsMenu_ModelingSettings_Click(sender, e);
        }
        private void Toolbar_StartModeling_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_StartModeling_Click(sender, e);
        }
        private void Toolbar_StopModeling_Click(object sender, System.EventArgs e)
        {
            if (this._activeSession.Running)
            {
                this.FileMenu_StopModeling_Click(sender, e);
            }
            else
            {
                this.FileMenu_CancelReports_Click(sender, e);
            }
        }
        #endregion
        #region 
        private void DisableDragDrop()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EmptyEventHandler(this.DisableDragDrop));
            }
            else
            {
                this.AllowDrop  = false;
                this.DragEnter -= new DragEventHandler(this.Cafe2d_DragEnter);
                this.DragDrop  -= new DragEventHandler(this.Cafe2d_DragDrop);
            }
        }
        private void EnableDragDrop()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EmptyEventHandler(this.EnableDragDrop));
            }
            else
            {
                this.AllowDrop  = true;
                this.DragEnter += new DragEventHandler(this.Cafe2d_DragEnter);
                this.DragDrop  += new DragEventHandler(this.Cafe2d_DragDrop);
            }
        }
        private void NewSession(bool parseCustFiles, string[] files)
        {
            Session session = new Session(this);
            session.RefreshInterval = Cafe2d.RefreshIntervalNormal;    
            session.MdiParent = this;
            session.Settings.UseRecommendedSettings();
            session.Show();         
            session.RefreshSession();
            this.ToolsMenu_ModelingSettings_Click(this, EventArgs.Empty);
        }
        public bool OpenSession(string filename, bool silent)
        {
            this.DisableDragDrop();
            bool opened = false;
            if (filename == null || filename == "")
            {   
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "All Files (*.*)|*.*|CAFE Model Session Data (*.cmsd)|*.cmsd";
                dlg.FilterIndex = 2;
                dlg.Title = "Please select the session file you would like to open:";
                if (dlg.ShowDialog() == DialogResult.OK) { filename = dlg.FileName; }
                else                                     { filename = null; }
            }
            if (filename != null)
            {   
                try
                {
                    Session session = new Session(this, filename);
                    session.MdiParent = this;
                    session.Show();
                    session.RefreshSession();
                    opened = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "CAFE Model Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    opened = false;
                }
            }
            this.EnableDragDrop();
            return opened;
        }
        private void SetStatus(string message)
        {
            this.ux_statusPanel.Text = message;
        }
        internal void SetStatus(Session child, string message)
        {
            if (this._activeSession != null && child == this._activeSession)
            {
                this.SetStatus(message);
            }
        }
        private void ExplorePaths(params string[] paths)
        {
            for (int i = 0; i < paths.Length; i++)
            {
                Process.Start("explorer", "/e," + paths[i]);
            }
        }
        private void ExplorePaths(ICollection paths)
        {
            string[] array = new string[paths.Count];
            paths.CopyTo(array, 0);
            this.ExplorePaths(array);
        }
        private void AddMenuItemEventHandlers(Menu.MenuItemCollection items)
        {
            for (int i = 0, count = items.Count; i < count; i++)
            {
                items[i].Select += new EventHandler(this.Control_AfterSelect);
                items[i].Click  += new EventHandler(this.Control_AfterClick);
                this.AddMenuItemEventHandlers(items[i].MenuItems);
            }
        }
        private void AddToolbarEventHandlers(Panel toolbar)
        {
            Control.ControlCollection items = toolbar.Controls;
            for (int i = 0, count = items.Count; i < count; i++)
            {
                if (items[i] is ToolbarButton)
                {
                    items[i].MouseEnter += new EventHandler(this.Control_AfterSelect);
                    items[i].MouseLeave += new EventHandler(this.Control_AfterClick);
                    items[i].MouseUp    += new MouseEventHandler(this.Control_AfterMouseClick);
                }
            }
        }
        #endregion
        public void Start(ProgramArgs args)
        {
            this._args = (args == null) ? new ProgramArgs() : args;
            Application.Run(this);
        }
        public void Start()
        {
            this.Start(null);
        }
        internal void RefreshSession()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EmptyEventHandler(this.RefreshSession));
            }
            else
            {
                bool anyOpen = (this.Sessions.Length > 0);
                bool anyActive = this.SessionsActive();
                bool running = (this._activeSession == null) ? false : this._activeSession.Running;
                bool reporting = (this._activeSession == null) ? false : this._activeSession.Reporting;
                bool canStart = (this._activeSession == null) ? false :
                    (this._activeSession.Compliance != null && !this._activeSession.Compliance.Running);
                bool saveReq = (this._activeSession == null) ? false : this._activeSession.SaveRequired;
                bool or = anyOpen && running;
                bool op = anyOpen && reporting;
                bool onr = anyOpen && !running && !reporting;
                bool onra = anyOpen && !anyActive;
                this.ux_fileMenu_CloseSession.Enabled = onr;
                this.ux_fileMenu_CloseAll.Enabled = onra;
                this.ux_fileMenu_SaveSession.Enabled = (onr && saveReq);
                this.ux_fileMenu_SaveSessionAs.Enabled = onr;
                this.ux_fileMenu_SaveAll.Enabled = onra;
                this.ux_fileMenu_StartModeling.Enabled = (onr && canStart);
                this.ux_fileMenu_StopModeling.Enabled = or;
                this.ux_fileMenu_GenerateReports.Enabled = onr;
                this.ux_fileMenu_CancelReports.Enabled = !running && op;
                this.ux_fileMenu_Exit.Enabled = !anyActive;
                this.ux_toolsMenu_ModelingSettings.Enabled = anyOpen;
                this.ux_viewMenu_InputFileLocation.Enabled = anyOpen;
                this.ux_viewMenu_OutputLocation.Enabled = anyOpen;
                this.ux_viewMenu_UpdateSpeed.Enabled = anyOpen;
                this.ux_viewMenu_Refresh.Enabled = anyOpen;
                this.ux_toolbar_SaveSession.Enabled = (onr && saveReq);
                this.ux_toolbar_ModelingSettings.Enabled = anyOpen;
                this.ux_toolbar_StartModeling.Enabled = (onr && canStart);
                this.ux_toolbar_StopModeling.Enabled = or || (!running && op);
            }
        }
        private bool SessionsActive()
        {
            Session[] sessions = this.Sessions;
            for (int i = 0; i < sessions.Length; i++)
            {
                if (!sessions[i].IsDisposed && (sessions[i].Running || sessions[i].Reporting))
                {
                    return true;
                }
            }
            return false;
        }
        #endregion
        #region 
        #region 
        internal static new Font DefaultFont { get { return Cafe2d._instance.Font; } }
        public static string StartupPath { get { return Cafe2d._startupPath; } }
        public static string DefaultDataPath { get { return Cafe2d._dataPath; } }
        public static string DefaultOutputPath { get { return Cafe2d._outputPath; } }
        public static string ThemesPath { get { return Cafe2d._themesPath; } }
        public static Assembly[] Assemblies
        {
            get
            {
                Assembly[] assemblies = new Assembly[Cafe2d._assemblies.Count];
                for (int i = 0; i < assemblies.Length; i++)
                {
                    assemblies[i] = (Assembly)Cafe2d._assemblies[i];
                }
                return assemblies;
            }
        }
        public static Type[] ComplianceTypes
        {
            get
            {
                Type[] types = new Type[Cafe2d._cmpTypes.Count];
                for (int i = 0; i < types.Length; i++)
                {
                    types[i] = (Type)Cafe2d._cmpTypes[i];
                }
                return types;
            }
        }
        #endregion
        public Session[] Sessions
        {
            get
            {
                Form[] children = this.MdiChildren;
                int childCount = children.Length;
                bool[] liveChildren = new bool[childCount];
                int liveCount = 0;
                for (int i = 0; i < childCount; i++)
                {
                    liveChildren[i] = !(children[i].Disposing || children[i].IsDisposed);
                    if (liveChildren[i]) { liveCount++; }
                }
                Session[] sessions = new Session[liveCount];
                for (int i = 0, j = 0; i < childCount; i++)
                {
                    if (liveChildren[i]) { sessions[j++] = (Session)children[i]; }
                }
                return sessions;
            }
        }
        public Session ActiveSession
        {
            get
            {
                if (this._activeSession == null)
                {
                    this.FileMenu_NewSession_Click(this, EventArgs.Empty);
                }
                return this._activeSession;
            }
        }
        private int ActiveSessionIndex
        {
            get
            {
                Form child = this.ActiveMdiChild;
                for (int i = 0; i < this.MdiChildren.Length; i++)
                {
                    if (this.MdiChildren[i] == child)
                    {
                        return i;
                    }
                }
                return -1;
            }
            set
            {
                if (value >= 0 && value < this.MdiChildren.Length)
                {
                    this.MdiChildren[value].Activate();
                }
            }
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.MainMenu ux_mainMenu;
        System.Windows.Forms.MenuItem ux_fileMenu;
        System.Windows.Forms.MenuItem ux_viewMenu;
        System.Windows.Forms.MenuItem ux_helpMenu;
        System.Windows.Forms.MenuItem ux_fileMenu_NewSession;
        System.Windows.Forms.MenuItem ux_fileMenu_OpenSession;
        System.Windows.Forms.MenuItem ux_fileMenu_CloseSession;
        System.Windows.Forms.MenuItem ux_fileMenu_CloseAll;
        System.Windows.Forms.MenuItem ux_fileMenu_SaveSession;
        System.Windows.Forms.MenuItem ux_fileMenu_SaveSessionAs;
        System.Windows.Forms.MenuItem ux_fileMenu_Separator0;
        System.Windows.Forms.MenuItem ux_fileMenu_Separator1;
        System.Windows.Forms.MenuItem ux_fileMenu_StartModeling;
        System.Windows.Forms.MenuItem ux_fileMenu_StopModeling;
        System.Windows.Forms.MenuItem ux_fileMenu_GenerateReports;
        System.Windows.Forms.MenuItem ux_fileMenu_CancelReports;
        System.Windows.Forms.MenuItem ux_fileMenu_Separator3;
        System.Windows.Forms.MenuItem ux_fileMenu_Exit;
        System.Windows.Forms.MenuItem ux_fileMenu_SaveAll;
        System.Windows.Forms.MenuItem ux_viewMenu_Separator0;
        System.Windows.Forms.MenuItem ux_viewMenu_InputFileLocation;
        System.Windows.Forms.MenuItem ux_viewMenu_OutputLocation;
        System.Windows.Forms.MenuItem ux_viewMenu_Separator1;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Realtime;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_High;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Normal;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Low;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Separator0;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Paused;
        System.Windows.Forms.MenuItem ux_viewMenu_Refresh;
        System.Windows.Forms.MenuItem ux_toolsMenu_ModelingSettings;
        System.Windows.Forms.MenuItem ux_helpMenu_About;
        System.Windows.Forms.StatusBar ux_statusBar;
        System.Windows.Forms.StatusBarPanel ux_statusPanel;
        System.Windows.Forms.StatusBarPanel ux_versionPanel;
        System.Windows.Forms.Panel ux_toolbar;
        Volpe.Cafe.Ui.ToolbarButton ux_toolbar_StopModeling;
        Volpe.Cafe.Ui.ToolbarButton ux_toolbar_StartModeling;
        Volpe.Cafe.Ui.ToolbarButton ux_toolbar_ModelingSettings;
        Volpe.Cafe.Ui.ToolbarButton ux_toolbar_SaveSession;
        Volpe.Cafe.Ui.ToolbarButton ux_toolbar_OpenSession;
        Volpe.Cafe.Ui.ToolbarButton ux_toolbar_NewSession;
        System.ComponentModel.IContainer components = null;
        #endregion
        static string _startupPath;
        static string _dataPath;
        static string _outputPath;
        static string _themesPath;
        static Cafe2d     _instance;
        static ArrayList  _assemblies;
        static ArrayList  _cmpTypes;        
        const int RefreshIntervalRealtime = 125;
        const int RefreshIntervalHigh     = 500;
        const int RefreshIntervalNormal   = 2000;
        const int RefreshIntervalLow      = 4000;
        const int RefreshIntervalPaused   = -1;
        Session _activeSession;
        bool _cancelSave;
        bool _cancelCloseAll;
        ProgramArgs _args;
        #endregion
    }
}

