using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.Ui.Panels
{
    public class MonteCarloPanel : Volpe.Cafe.Ui.Panels.CafeUserControl
    {
        #region 
        public MonteCarloPanel()
        {
            this.InitializeComponent();
            this.PostInitialize();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_trialsFile = new System.Windows.Forms.TextBox();
            this.ux_trialPairCount = new System.Windows.Forms.TextBox();
            this.ux_useTrialsFile = new System.Windows.Forms.RadioButton();
            this.ux_trialPairCountLabel = new System.Windows.Forms.Label();
            this.ux_generateTrialPairs = new System.Windows.Forms.RadioButton();
            this.ux_generateTrialsLabel = new System.Windows.Forms.Label();
            this.ux_generateTrialsPanel = new System.Windows.Forms.Panel();
            this.ux_browseTrialsFile = new System.Windows.Forms.Button();
            this.ux_generateTrialsPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_trialsFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_trialsFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_trialsFile.Enabled = false;
            this.ux_trialsFile.Location = new System.Drawing.Point(24, 56);
            this.ux_trialsFile.Name = "ux_trialsFile";
            this.ux_trialsFile.Size = new System.Drawing.Size(279, 21);
            this.ux_trialsFile.TabIndex = 4;
            this.ux_trialsFile.Text = "";
            this.ux_trialsFile.WordWrap = false;
            this.ux_trialPairCount.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_trialPairCount.Location = new System.Drawing.Point(200, 24);
            this.ux_trialPairCount.MaxLength = 8;
            this.ux_trialPairCount.Multiline = true;
            this.ux_trialPairCount.Name = "ux_trialPairCount";
            this.ux_trialPairCount.Size = new System.Drawing.Size(64, 18);
            this.ux_trialPairCount.TabIndex = 2;
            this.ux_trialPairCount.Text = "10000";
            this.ux_trialPairCount.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_useTrialsFile.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_useTrialsFile.Location = new System.Drawing.Point(8, 40);
            this.ux_useTrialsFile.Name = "ux_useTrialsFile";
            this.ux_useTrialsFile.Size = new System.Drawing.Size(248, 16);
            this.ux_useTrialsFile.TabIndex = 3;
            this.ux_useTrialsFile.Text = "Use existing trials from a pre-generated file:";
            this.ux_trialPairCountLabel.Location = new System.Drawing.Point(24, 24);
            this.ux_trialPairCountLabel.Name = "ux_trialPairCountLabel";
            this.ux_trialPairCountLabel.Size = new System.Drawing.Size(176, 16);
            this.ux_trialPairCountLabel.TabIndex = 1;
            this.ux_trialPairCountLabel.Text = "Number of trial pairs to generate:";
            this.ux_generateTrialPairs.Checked = true;
            this.ux_generateTrialPairs.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_generateTrialPairs.Location = new System.Drawing.Point(8, 8);
            this.ux_generateTrialPairs.Name = "ux_generateTrialPairs";
            this.ux_generateTrialPairs.Size = new System.Drawing.Size(280, 16);
            this.ux_generateTrialPairs.TabIndex = 0;
            this.ux_generateTrialPairs.TabStop = true;
            this.ux_generateTrialPairs.Text = "Automatically generate new trial pairs for analysis:";
            this.ux_generateTrialsLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_generateTrialsLabel.Name = "ux_generateTrialsLabel";
            this.ux_generateTrialsLabel.Size = new System.Drawing.Size(288, 16);
            this.ux_generateTrialsLabel.TabIndex = 0;
            this.ux_generateTrialsLabel.Text = "Please specify options for generating Monte-Carlo trials:";
            this.ux_generateTrialsPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_generateTrialsPanel.Controls.Add(this.ux_browseTrialsFile);
            this.ux_generateTrialsPanel.Controls.Add(this.ux_trialsFile);
            this.ux_generateTrialsPanel.Controls.Add(this.ux_trialPairCount);
            this.ux_generateTrialsPanel.Controls.Add(this.ux_generateTrialPairs);
            this.ux_generateTrialsPanel.Controls.Add(this.ux_useTrialsFile);
            this.ux_generateTrialsPanel.Controls.Add(this.ux_trialPairCountLabel);
            this.ux_generateTrialsPanel.Location = new System.Drawing.Point(8, 16);
            this.ux_generateTrialsPanel.Name = "ux_generateTrialsPanel";
            this.ux_generateTrialsPanel.Size = new System.Drawing.Size(384, 82);
            this.ux_generateTrialsPanel.TabIndex = 1;
            this.ux_browseTrialsFile.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_browseTrialsFile.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_browseTrialsFile.Location = new System.Drawing.Point(304, 56);
            this.ux_browseTrialsFile.Name = "ux_browseTrialsFile";
            this.ux_browseTrialsFile.Size = new System.Drawing.Size(80, 21);
            this.ux_browseTrialsFile.TabIndex = 5;
            this.ux_browseTrialsFile.Text = "Browse";
            this.Controls.Add(this.ux_generateTrialsLabel);
            this.Controls.Add(this.ux_generateTrialsPanel);
            this.Name = "MonteCarloPanel";
            this.Size = new System.Drawing.Size(400, 104);
            this.ux_generateTrialsPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        void PostInitialize()
        {
            this.InitializeTextBoxDragDrop(this.ux_trialsFile);
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.RegisterNumericTextControl(this.ux_trialPairCount, 10000.0, 1.0, 1000000.0, "The number of trial pairs to generate should be between 1 and 1,000,000.", true, "0");
            this.ux_generateTrialPairs   .CheckedChanged += new EventHandler(this.GenerateTrialPairs_CheckedChanged);
            this.ux_useTrialsFile        .CheckedChanged += new EventHandler(this.UseTrialsFile_CheckedChanged);
            this.ux_trialsFile           .TextChanged    += new EventHandler(this.TrialsFile_TextChanged);
            this.ux_trialsFile           .EnabledChanged += new EventHandler(this.TrialsFile_EnabledChanged);
            this.ux_browseTrialsFile     .Click          += new EventHandler(this.BrowseTrialsFile_Click);
        }
        void GenerateTrialPairs_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = this.ux_generateTrialPairs.Checked;
            this.ux_trialPairCountLabel.Enabled = enabled;
            this.ux_trialPairCount     .Enabled = enabled;
        }
        void UseTrialsFile_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = this.ux_useTrialsFile.Checked;
            this.ux_trialsFile      .Enabled = enabled;
            this.ux_browseTrialsFile.Enabled = enabled;
        }
        void TrialsFile_TextChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (File.Exists(tb.Text))
            {
                bool trialsFileChanged = !this.CompareFiles(this._mcSettings.TrialsFile, tb.Text);
                tb.ForeColor = (this._visualTracking && trialsFileChanged) ? this._visualTrackingColor : Control.DefaultForeColor;
                tb.BackColor = Color.Empty;
                this._messages.RemoveMessage(tb);
            }
            else
            {
                this._messages.AddMessage("The specified location for Monte-Carlo trials file does not exist on disk.", Color.Red, tb);
                tb.BackColor = Color.Honeydew;
                tb.ForeColor = Color.Red;
            }
        }
        void TrialsFile_EnabledChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Enabled) { this.TrialsFile_TextChanged(sender, e); }
            else            { this._messages.RemoveMessage(sender); tb.BackColor = Color.Empty; }
        }
        bool CompareFiles(string file1, string file2)
        {
            if (File.Exists(file1)) { file1 = Path.GetFullPath(file1.TrimEnd('\\')); }
            if (File.Exists(file2)) { file2 = Path.GetFullPath(file2.TrimEnd('\\')); }
            return (file1 == file2);
        }
        void BrowseTrialsFile_Click(object sender, EventArgs e)
        {
            TextBox tb = this.ux_trialsFile;
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "All Files (*.*)|*.*|CSV Files(*.*)|*.*";
            ofd.FilterIndex = 1;
            ofd.Multiselect = false;
            ofd.FileName = File.Exists(tb.Text) ? tb.Text : "";
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                tb.Text = ofd.FileName;
            }
        }
        void InitializeTextBoxDragDrop(params TextBox[] values)
        {
            for (int i = 0; i < values.Length; i++)
            {
                values[i].AllowDrop = true;
                values[i].DragEnter += new DragEventHandler(this.MonteCarloPanel_DragEnter);
                values[i].DragDrop  += new DragEventHandler(this.MonteCarloPanel_DragDrop);
            }
        }
        void MonteCarloPanel_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        void MonteCarloPanel_DragDrop(object sender, DragEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            for (int i = 0; i < files.Length; i++)
            {
                if (File.Exists(files[i]))
                {
                    tb.Text = files[i];
                    break;
                }
            }
        }
        public void SetInitialState(MonteCarloSettings monteCarloSettings)
        {
            this._mcSettings = monteCarloSettings;
            this.ux_trialPairCount.Text    = this._mcSettings.TrialPairs.ToString();
            this.ux_useTrialsFile .Checked = this._mcSettings.UseTrialsFile;
            this.ux_trialsFile    .Text    = this._mcSettings.TrialsFile;
            this.SaveChanges();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._mcSettings.TrialPairs    = Global.GetInt32(this.ux_trialPairCount.Text);
                this._mcSettings.UseTrialsFile = this.ux_useTrialsFile.Checked;
                this._mcSettings.TrialsFile    = this.ux_trialsFile.Text;
                base.SaveChanges();
                if (this._visualTracking)
                {   
                    this.ux_trialsFile.ForeColor = Control.DefaultForeColor;
                    this.ux_trialsFile.BackColor = Color.Empty;
                }
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public MonteCarloSettings MonteCarloSettings { get { return this._mcSettings; } }
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                if (this.ux_useTrialsFile.Checked && !File.Exists(this.ux_trialsFile.Text)) { return false; }
                return base.SettingsChanged ||
                    (this.ux_trialsFile.Enabled && !this.CompareFiles(this._mcSettings.TrialsFile, this.ux_trialsFile.Text));
            }
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.Label ux_generateTrialsLabel;
        System.Windows.Forms.Panel ux_generateTrialsPanel;
        System.Windows.Forms.RadioButton ux_generateTrialPairs;
        System.Windows.Forms.Label ux_trialPairCountLabel;
        System.Windows.Forms.TextBox ux_trialPairCount;
        System.Windows.Forms.RadioButton ux_useTrialsFile;
        System.Windows.Forms.TextBox ux_trialsFile;
        System.Windows.Forms.Button ux_browseTrialsFile;
        #endregion
        MonteCarloSettings _mcSettings;
        #endregion
    }
}

