using System;
using System.Collections;
using Volpe.Cafe;
namespace Volpe.Cafe.Collections
{
    [Serializable]
    public sealed class TechnologyCollection : CollectionBase, ICloneable
    {
        #region 
        public TechnologyCollection() : base()
        {
        }
        public TechnologyCollection(int capacity) : base()
        {
            this.InnerList.Capacity = capacity;
        }
        #endregion
        #region 
        public TechnologyCollection GetTechnologyGroup(TechnologyType type)
        {
            TechnologyCollection tc = new TechnologyCollection(this.GetTechnologyGroupCount(type));
            for (int i = 0; i < this.InnerList.Count; i++)
            {
                if (this[i].Type == type) { tc.Add(this[i]); }
            }
            return tc;
        }
        public int GetTechnologyGroupCount(TechnologyType type)
        {
            int count = 0;
            for (int i = 0; i < this.InnerList.Count; i++)
            {
                if (this[i].Type == type) { count++; }
            }
            return count;
        }
        public bool HasTechnologyGroup(TechnologyType type)
        {
            for (int i = 0, count = this.InnerList.Count; i < count; i++)
            {
                if      (this[i]      == null) { break; }
                else if (this[i].Type == type) { return true; }
            }
            return false;
        }
        public int Add(Technology value)
        {
            return this.InnerList.Add(value);
        }
        public void AddUnique(Technology value)
        {
            if (this.IndexOf(value) == -1)
            {
                this.InnerList.Add(value);
            }
        }
        public void AddRange(ICollection values)
        {
            this.InnerList.AddRange(values);
        }
        public void Insert(int index, Technology value)
        {
            this.InnerList.Insert(index, value);
        }
        public void InsertRange(int index, ICollection values)
        {
            this.InnerList.InsertRange(index, values);
        }
        public void Remove(Technology value)
        {
            this.InnerList.Remove(value);
        }
        public new void RemoveAt(int index)
        {
            base.RemoveAt(index);
        }
        public new void Clear()
        {
            base.Clear();
        }
        public bool Contains(Technology value)
        {
            return this.InnerList.Contains(value);
        }
        public int IndexOf(Technology value)
        {
            return this.InnerList.IndexOf(value);
        }
        public int IndexOf(Technology value, int startIndex)
        {
            return this.InnerList.IndexOf(value, startIndex);
        }
        public int IndexOf(Technology value, int startIndex, int count)
        {
            return this.InnerList.IndexOf(value, startIndex, count);
        }
        public void CopyTo(Technology[] array)
        {
            this.CopyTo(array, 0);
        }
        public void CopyTo(Technology[] array, int index)
        {
            this.InnerList.CopyTo(array, index);
        }
        public Technology[] ToArray()
        {
            Technology[] array = new Technology[this.Count];
            this.CopyTo(array, 0);
            return array;
        }
        public new IEnumerator GetEnumerator()
        {
            return base.GetEnumerator();
        }
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public TechnologyCollection Clone()
        {
            TechnologyCollection newCollection = new TechnologyCollection(this.Count);
            for (int i = 0; i < this.Count; i++)
            {
                newCollection.Add((Technology)(this[i].Clone()));
            }
            return newCollection;
        }
        #endregion
        #endregion
        #region 
        public Technology this[int index]
        {
            get { return (Technology)(this.InnerList[index]); }
            set { this.InnerList[index] = value; }
        }
        public new int Count { get { return base.Count; } }
        public int Capacity
        {
            get { return this.InnerList.Capacity; }
            set { this.InnerList.Capacity = value; }
        }
        public bool IsReadOnly { get { return this.InnerList.IsReadOnly; } }
        public bool IsFixedSize { get { return this.InnerList.IsFixedSize; } }
        public bool IsSynchronized { get { return this.InnerList.IsSynchronized; } }
        public object SyncRoot { get { return this.InnerList.SyncRoot; } }
        public TechnologyCollection OtherTechnologies { get { return this.GetTechnologyGroup(TechnologyType.Other); } }
        public TechnologyCollection EngineTechnologies { get { return this.GetTechnologyGroup(TechnologyType.Engine); } }
        public TechnologyCollection ElecTechnologies { get { return this.GetTechnologyGroup(TechnologyType.Elec); } }
        public TechnologyCollection TransmissionTechnologies { get { return this.GetTechnologyGroup(TechnologyType.Transmission); } }
        public TechnologyCollection HybridTechnologies { get { return this.GetTechnologyGroup(TechnologyType.Hybrid); } }
        public TechnologyCollection MsrTechnologies { get { return this.GetTechnologyGroup(TechnologyType.MSR); } }
        public TechnologyCollection DlrTechnologies { get { return this.GetTechnologyGroup(TechnologyType.DLR); } }
        public TechnologyCollection AeroTechnologies { get { return this.GetTechnologyGroup(TechnologyType.Aerodynamics); } }
        public bool HasOther { get { return this.HasTechnologyGroup(TechnologyType.Other); } }
        public bool HasEngine { get { return this.HasTechnologyGroup(TechnologyType.Engine); } }
        public bool HasElec { get { return this.HasTechnologyGroup(TechnologyType.Elec); } }
        public bool HasTransmission { get { return this.HasTechnologyGroup(TechnologyType.Transmission); } }
        public bool HasHybrid { get { return this.HasTechnologyGroup(TechnologyType.Hybrid); } }
        public bool HasMsr { get { return this.HasTechnologyGroup(TechnologyType.MSR); } }
        public bool HasDlr { get { return this.HasTechnologyGroup(TechnologyType.DLR); } }
        public bool HasAero { get { return this.HasTechnologyGroup(TechnologyType.Aerodynamics); } }
        #endregion
    }
}

