using System;
namespace Volpe.Cafe.Data.Optimization
{
    [Serializable]
    public struct IterationData
    {
        #region 
        public void Reset()
        {
            this.Valid = false;
            if (this.Coefficients != null) { Array.Clear(this.Coefficients, 0, this.Coefficients.Length); }
            this.Standard        = 0;
            this.CAFE            = 0;
            this.TechCost        = 0;
            this.Fines           = 0;
            this.Benefits        = 0;
            this.DiscBenefits    = 0;
            this.FuelConsumption = 0;
            this.CO2Emissions    = 0;
            this.CO2DiscCosts    = 0;
            this.DeltaStandard        = 0;
            this.DeltaCAFE            = 0;
            this.DeltaTechCost        = 0;
            this.DeltaFines           = 0;
            this.DeltaBenefits        = 0;
            this.DeltaDiscBenefits    = 0;
            this.DeltaFuelConsumption = 0;
            this.DeltaCO2Emissions    = 0;
            this.DeltaCO2DiscCosts    = 0;
            this.FuelSavings         = 0;
            this.CO2EmissionSavings  = 0;
            this.CO2MonetizedSavings = 0;
            this.NetBenefits = 0;
            this.BCRatio     = 0;
            this.MBCRatio    = 0;
            this.AdditionalIterationData = null;
        }
        #endregion
        #region 
        public bool Valid;
        public double Standard;
        public double[] Coefficients;
        public double CAFE;
        public double TechCost;
        public double Fines;
        public double Benefits;
        public double DiscBenefits;
        public double FuelConsumption;
        public double CO2Emissions;
        public double CO2DiscCosts;
        public double DeltaStandard;
        public double DeltaCAFE;
        public double DeltaTechCost;
        public double DeltaFines;
        public double DeltaBenefits;
        public double DeltaDiscBenefits;
        public double DeltaFuelConsumption;
        public double DeltaCO2Emissions;
        public double DeltaCO2DiscCosts;
        public double FuelSavings;
        public double CO2EmissionSavings;
        public double CO2MonetizedSavings;
        public double NetBenefits;
        public double BCRatio;
        public double MBCRatio;
        public IterationData[] AdditionalIterationData;
        #endregion
    }
}

