using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public struct RCDouble
    {
        #region 
        static RCDouble()
        {
            RCDouble.NaN  = new RCDouble(double.NaN);
            RCDouble.Zero = new RCDouble(0);
            RCDouble.One  = new RCDouble(1);
        }
        RCDouble(double value)
            : this(value, value, value, value)
        {
        }
        RCDouble(double unregulated, double domesticAuto, double importedAuto, double lightTruck)
        {
            this.Unregulated  = unregulated;
            this.DomesticAuto = domesticAuto;
            this.ImportedAuto = importedAuto;
            this.LightTruck   = lightTruck;
        }
        #endregion
        #region 
        #region 
        public static RCDouble operator +(RCDouble value1, RCDouble value2)
        {
            return new RCDouble(value1.Unregulated + value2.Unregulated, value1.DomesticAuto + value2.DomesticAuto,
                value1.ImportedAuto + value2.ImportedAuto, value1.LightTruck + value2.LightTruck);
        }
        public static RCDouble operator +(RCDouble value1, double value2)
        {
            return value1 + new RCDouble(value2);
        }
        public static RCDouble operator +(double value1, RCDouble value2)
        {
            return new RCDouble(value1) + value2;
        }
        public static RCDouble operator +(RCDouble value1, int value2)
        {
            return value1 + new RCDouble(value2);
        }
        public static RCDouble operator +(int value1, RCDouble value2)
        {
            return new RCDouble(value1) + value2;
        }
        public static RCDouble operator -(RCDouble value1, RCDouble value2)
        {
            return new RCDouble(value1.Unregulated - value2.Unregulated, value1.DomesticAuto - value2.DomesticAuto,
                value1.ImportedAuto - value2.ImportedAuto, value1.LightTruck - value2.LightTruck);
        }
        public static RCDouble operator -(RCDouble value1, double value2)
        {
            return value1 - new RCDouble(value2);
        }
        public static RCDouble operator -(double value1, RCDouble value2)
        {
            return new RCDouble(value1) - value2;
        }
        public static RCDouble operator -(RCDouble value1, int value2)
        {
            return value1 - new RCDouble(value2);
        }
        public static RCDouble operator -(int value1, RCDouble value2)
        {
            return new RCDouble(value1) - value2;
        }
        public static RCDouble operator *(RCDouble value1, RCDouble value2)
        {
            return new RCDouble(value1.Unregulated * value2.Unregulated, value1.DomesticAuto * value2.DomesticAuto,
                value1.ImportedAuto * value2.ImportedAuto, value1.LightTruck * value2.LightTruck);
        }
        public static RCDouble operator *(RCDouble value1, double value2)
        {
            return value1 * new RCDouble(value2);
        }
        public static RCDouble operator *(double value1, RCDouble value2)
        {
            return new RCDouble(value1) * value2;
        }
        public static RCDouble operator *(RCDouble value1, int value2)
        {
            return value1 * new RCDouble(value2);
        }
        public static RCDouble operator *(int value1, RCDouble value2)
        {
            return new RCDouble(value1) * value2;
        }
        public static RCDouble operator /(RCDouble value1, RCDouble value2)
        {
            return new RCDouble(value1.Unregulated / value2.Unregulated, value1.DomesticAuto / value2.DomesticAuto,
                value1.ImportedAuto / value2.ImportedAuto, value1.LightTruck / value2.LightTruck);
        }
        public static RCDouble operator /(RCDouble value1, double value2)
        {
            return value1 / new RCDouble(value2);
        }
        public static RCDouble operator /(double value1, RCDouble value2)
        {
            return new RCDouble(value1) / value2;
        }
        public static RCDouble operator /(RCDouble value1, int value2)
        {
            return value1 / new RCDouble(value2);
        }
        public static RCDouble operator /(int value1, RCDouble value2)
        {
            return new RCDouble(value1) / value2;
        }
        public static RCDouble operator +(RCDouble value)
        {
            return RCDouble.Zero + value;
        }
        public static RCDouble operator -(RCDouble value)
        {
            return RCDouble.Zero - value;
        }
        public static RCDouble operator ++(RCDouble value)
        {
            return value + RCDouble.One;
        }
        public static RCDouble operator --(RCDouble value)
        {
            return value - RCDouble.One;
        }
        public static bool operator ==(RCDouble value1, RCDouble value2)
        {
            return value1.Equals(value2);
        }
        public static bool operator !=(RCDouble value1, RCDouble value2)
        {
            return !value1.Equals(value2);
        }
        #endregion
        public override string ToString()
        {
            return "{Dom Auto="  + this.DomesticAuto.ToString() +
                ", Imp Auto="    + this.ImportedAuto.ToString() +
                ", Light Truck=" + this.LightTruck  .ToString() +
                ", Unregulated=" + this.Unregulated .ToString() + "}";
        }
        public string ToString(string format)
        {
            return "{Dom Auto="  + this.DomesticAuto.ToString(format) +
                ", Imp Auto="    + this.ImportedAuto.ToString(format) +
                ", Light Truck=" + this.LightTruck  .ToString(format) +
                ", Unregulated=" + this.Unregulated .ToString(format) + "}";
        }
        public string ToString(int digits)
        {
            return "{Dom Auto="  + Math.Round(this.DomesticAuto, digits).ToString() +
                ", Imp Auto="    + Math.Round(this.ImportedAuto, digits).ToString() +
                ", Light Truck=" + Math.Round(this.LightTruck  , digits).ToString() +
                ", Unregulated=" + Math.Round(this.Unregulated , digits).ToString() + "}";
        }
        public override int GetHashCode()
        {
            return this.DomesticAuto.GetHashCode() ^ this.ImportedAuto.GetHashCode() ^ this.LightTruck.GetHashCode() ^
                this.Unregulated.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            if (obj is RCDouble) { return this.Equals((RCDouble)obj); }
            else                 { return base.Equals(obj); }
        }
        public bool Equals(RCDouble value)
        {
            return (this.DomesticAuto == value.DomesticAuto && this.ImportedAuto == value.ImportedAuto &&
                    this.LightTruck   == value.LightTruck   && this.Unregulated  == value.Unregulated);
        }
        public double Value(RegulatoryClass regClass)
        {
            return
                (regClass == RegulatoryClass.DomesticAuto) ? this.DomesticAuto :
                (regClass == RegulatoryClass.ImportedAuto) ? this.ImportedAuto :
                (regClass == RegulatoryClass.LightTruck  ) ? this.LightTruck   : this.Unregulated;
        }
        public void ZeroNaNs()
        {
            if (double.IsNaN(this.DomesticAuto)) { this.DomesticAuto = 0; }
            if (double.IsNaN(this.ImportedAuto)) { this.ImportedAuto = 0; }
            if (double.IsNaN(this.LightTruck  )) { this.LightTruck   = 0; }
            if (double.IsNaN(this.Unregulated )) { this.Unregulated  = 0; }
        }
        public static RCDouble ZeroNaNs(RCDouble value)
        {
            value.ZeroNaNs();
            return value;
        }
        public RCDouble CreateRounded(int digits)
        {
            RCDouble value = new RCDouble();
            value.DomesticAuto = Math.Round(this.DomesticAuto, digits);
            value.ImportedAuto = Math.Round(this.ImportedAuto, digits);
            value.LightTruck   = Math.Round(this.LightTruck  , digits);
            value.Unregulated  = Math.Round(this.Unregulated , digits);
            return value;
        }
        public void Clear()
        {
            this.Unregulated  = 0.0;
            this.DomesticAuto = 0.0;
            this.ImportedAuto = 0.0;
            this.LightTruck   = 0.0;
        }
        #endregion
        #region 
        public double this[RegulatoryClass regClass]
        {
            get { return this.Value(regClass); }
            set
            {
                if      (regClass == RegulatoryClass.DomesticAuto) { this.DomesticAuto = value; }
                else if (regClass == RegulatoryClass.ImportedAuto) { this.ImportedAuto = value; }
                else if (regClass == RegulatoryClass.LightTruck  ) { this.LightTruck   = value; }
                else if (regClass == RegulatoryClass.Unregulated ) { this.Unregulated  = value; }
                else
                {
                    throw new ArgumentException("The value specified does not represent a valid regulatory class.");
                }
            }
        }
        public double Total
        {
            get
            {
                if (double.IsNaN(this.DomesticAuto) && double.IsNaN(this.ImportedAuto) && double.IsNaN(this.LightTruck))
                {
                    return double.NaN;
                }
                else
                {
                    return (double.IsNaN(this.DomesticAuto) ? 0 : this.DomesticAuto) +
                           (double.IsNaN(this.ImportedAuto) ? 0 : this.ImportedAuto) +
                           (double.IsNaN(this.LightTruck  ) ? 0 : this.LightTruck  );
                }
            }
        }
        public double TotalAll
        {
            get
            {
                double total = this.Total;
                if (double.IsNaN(total) && double.IsNaN(this.Unregulated))
                {
                    return double.NaN;
                }
                else
                {
                    return (double.IsNaN(total) ? 0 : total) + (double.IsNaN(this.Unregulated) ? 0 : this.Unregulated);
                }
            }
        }
        #endregion
        #region 
        public static readonly RCDouble NaN;
        public static readonly RCDouble Zero;
        public static readonly RCDouble One;
        public double Unregulated;
        public double DomesticAuto;
        public double ImportedAuto;
        public double LightTruck;
        #endregion
    }
}

