using System;
namespace Volpe.Cafe.IO
{
    public class InputException : Exception
    {
        #region 
        public InputException(string fileName)
            : this("", fileName)
        {
        }
        public InputException(string message, string fileName)
            : this(message, fileName, null)
        {
        }
        public InputException(string message, string fileName, Exception innerException)
            : base("Error loading and/or parsing file: " + fileName + "\nAdditional information: " + message,
            innerException)
        {
            this._fileName = fileName;
        }
        #endregion
        #region 
        public string FileName { get { return this._fileName; } }
        #endregion
        #region 
        private string _fileName;
        #endregion
    }
}

