using System;
namespace Volpe.Cafe.IO
{
    public class OutputException : Exception
    {
        #region 
        public OutputException(string fileName)
            : this("", fileName)
        {
        }
        public OutputException(string message, string fileName)
            : this(message, fileName, null)
        {
        }
        public OutputException(string message, string fileName, Exception innerException)
            : base("Error writing file: " + fileName +
            "\nAdditional information: " + message, innerException)
        {
            this._fileName = fileName;
        }
        #endregion
        #region 
        public string FileName { get { return this._fileName; } }
        #endregion
        #region 
        private string _fileName;
        #endregion
    }
}

